DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.15631605696904E-11   0.00000000000000E+00   2.32934792024997E-14   1.57119550074477E-22
      1.15632410962209E-08   1.15632643897003E-08  -7.94489340993827E-19  -2.48476022247094E-01  -2.48476022247105E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07050858840524E-11   0.00000000000000E+00   1.07050858840524E-11
      3.70608115860942E-18  -2.48476022246873E-01  -2.44829628802409E-01   0.00000000000000E+00  -1.83871710667725E-14
     -9.83008693145157E-23  -1.15739510884132E-08  -1.15739694755844E-08  -2.91159181761560E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.11043042626016E-11   0.00000000000000E+00   3.63543055542199E-14   1.51846244918240E-22
      1.11043320293913E-08   1.11043683836970E-08  -7.98263410094506E-19  -2.46740124908967E-01  -2.46740124908978E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12985080596425E-11   0.00000000000000E+00   1.12985080596425E-11
      3.71370765154968E-18  -2.46740124908482E-01  -2.43238121077425E-01   0.00000000000000E+00  -2.43605677446265E-14
     -9.82420313700251E-23  -1.11156425311888E-08  -1.11156668917566E-08  -2.91544424145518E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.06571122371382E-11   0.00000000000000E+00   9.36577904130964E-14   1.48183813444430E-22
      1.06570650586981E-08   1.06571587164886E-08  -8.02239875802195E-19  -2.44821708441120E-01  -2.44821708441131E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10187084107885E-11   0.00000000000000E+00   1.10187084107885E-11
      3.72374844958902E-18  -2.44821708440034E-01  -2.41460702162149E-01   0.00000000000000E+00  -7.80739532328346E-14
     -9.81576022695007E-23  -1.06680993509461E-08  -1.06681774248994E-08  -2.92150857378682E-18
      2.39379687500000E-09
      0.00000000000000E+00  -1.05237536787128E-11   0.00000000000000E+00  -2.15296286560764E-14   1.47249169459238E-22
      1.05238080162534E-08   1.05237864866249E-08  -8.03472067503962E-19  -2.44217084407874E-01  -2.44217084407885E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08367844922291E-11   0.00000000000000E+00   1.08367844922291E-11
      3.72708126879465E-18  -2.44217084410566E-01  -2.40898117555150E-01   0.00000000000000E+00   3.81437278498342E-14
     -9.81289937455488E-23  -1.05346614148448E-08  -1.05346232711171E-08  -2.92360920129069E-18
      2.80898515625000E-09
      0.00000000000000E+00  -1.03666991780880E-11   0.00000000000000E+00  -1.65286779375032E-14   1.46389101491037E-22
      1.03667304315284E-08   1.03667139028507E-08  -8.04967746219558E-19  -2.43469162882041E-01  -2.43469162882052E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05054531080308E-11   0.00000000000000E+00   1.05054531080308E-11
      3.73144300981432E-18  -2.43469162883555E-01  -2.40199787122356E-01   0.00000000000000E+00   3.36557684640517E-14
     -9.80905977296736E-23  -1.03772530117271E-08  -1.03772193559587E-08  -2.92647526359477E-18
      3.36948933593750E-09
      0.00000000000000E+00  -1.01869590273728E-11   0.00000000000000E+00  -1.13687083418212E-14   1.45723686885280E-22
      1.01870161007867E-08   1.01870047320785E-08  -8.06738956619146E-19  -2.42565264235596E-01  -2.42565264235606E-01
      0.00000000000000E+00   0.00000000000000E+00   9.96001795852327E-12   0.00000000000000E+00   9.96001795852327E-12
      3.73702564150984E-18  -2.42565264237310E-01  -2.39352678690019E-01   0.00000000000000E+00   2.85692573605209E-14
     -9.80401861367702E-23  -1.01969933192943E-08  -1.01969647500371E-08  -2.93028668489069E-18
      4.12616997851563E-09
      0.00000000000000E+00  -9.98802332658133E-12   0.00000000000000E+00  -4.67335870475612E-15   1.45376958067487E-22
      9.98800738046709E-09   9.98800270710853E-09  -8.08777130436148E-19  -2.41503618204174E-01  -2.41503618204183E-01
      0.00000000000000E+00   0.00000000000000E+00   9.15765488095278E-12   0.00000000000000E+00   9.15765488095278E-12
      3.74395506168967E-18  -2.41503618207957E-01  -2.38353982501265E-01   0.00000000000000E+00   2.13118083294448E-14
     -9.79760495376136E-23  -9.99718167379771E-09  -9.99716036198948E-09  -2.93517793125352E-18
      5.14768884599610E-09
      0.00000000000000E+00  -9.77549460468311E-12   0.00000000000000E+00   3.82897038545257E-15   1.45440084138809E-22
      9.77547746754016E-09   9.77548129651069E-09  -8.11044408291761E-19  -2.40299793863050E-01  -2.40299793863058E-01
      0.00000000000000E+00   0.00000000000000E+00   8.08560801060255E-12   0.00000000000000E+00   8.08560801060255E-12
      3.75221466282755E-18  -2.40299793873178E-01  -2.37217452832355E-01   0.00000000000000E+00   1.14857182896741E-14
     -9.78978722733855E-23  -9.78357839023949E-09  -9.78356690452130E-09  -2.94117025453579E-18
      6.52673931709473E-09
      0.00000000000000E+00  -9.55763888802686E-12   0.00000000000000E+00   1.42077034768048E-14   1.45932802182542E-22
      9.55764317269117E-09   9.55765738039480E-09  -8.13465121246315E-19  -2.38993052644370E-01  -2.38993052644377E-01
      0.00000000000000E+00   0.00000000000000E+00   6.77948241830329E-12   0.00000000000000E+00   6.77948241830329E-12
      3.76156391125031E-18  -2.38993052669670E-01  -2.35979751222834E-01   0.00000000000000E+00  -9.70732558778461E-16
     -9.78077183317342E-23  -9.56443589208046E-09  -9.56443686281311E-09  -2.94809879000400E-18
      8.38845745307788E-09
      0.00000000000000E+00  -9.34492647665422E-12   0.00000000000000E+00   2.61580743681670E-14   1.46781369169496E-22
      9.34495037310443E-09   9.34497653117894E-09  -8.15920856111718E-19  -2.37649927155924E-01  -2.37649927155929E-01
      0.00000000000000E+00   0.00000000000000E+00   5.33099917043450E-12   0.00000000000000E+00   5.33099917043450E-12
      3.77148872908882E-18  -2.37649927213443E-01  -2.34704090443984E-01   0.00000000000000E+00  -1.55701213001302E-14
     -9.77106876001694E-23  -9.35029196022798E-09  -9.35030753034938E-09  -2.95556787297710E-18
      1.03884574530779E-08
      0.00000000000000E+00  -9.17905488125743E-12   0.00000000000000E+00   1.52991303281779E-14   1.47648341803924E-22
      9.17907870363440E-09   9.17909400276488E-09  -8.17895629627596E-19  -2.36560566529684E-01  -2.36560566529688E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10763913733235E-12   0.00000000000000E+00   4.10763913733235E-12
      3.77970400736349E-18  -2.36560566633846E-01  -2.33667372782585E-01   0.00000000000000E+00  -7.04080134942196E-15
     -9.76297631488615E-23  -9.18319460110078E-09  -9.18320164190223E-09  -2.96180837773589E-18
      1.23884574530779E-08
      0.00000000000000E+00  -9.05653400182259E-12   0.00000000000000E+00   6.59164189582033E-15   1.48390386320504E-22
      9.05646961939622E-09   9.05647621103826E-09  -8.19387921450074E-19  -2.35732973812359E-01  -2.35732973812362E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15885055062972E-12   0.00000000000000E+00   3.15885055062972E-12
      3.78602170846475E-18  -2.35732973973085E-01  -2.32878706774831E-01   0.00000000000000E+00  -1.93893562115520E-16
     -9.75673245152940E-23  -9.05963486769524E-09  -9.05963506158890E-09  -2.96663378701468E-18
      1.43884574530779E-08
      0.00000000000000E+00  -8.96468926461506E-12   0.00000000000000E+00   2.78818041809695E-15   1.48995605718154E-22
      8.96468361368603E-09   8.96468640186660E-09  -8.20522670902702E-19  -2.35101579474522E-01  -2.35101579474525E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42746878523898E-12   0.00000000000000E+00   2.42746878523898E-12
      3.79087664603522E-18  -2.35101579698070E-01  -2.32276459921129E-01   0.00000000000000E+00   2.14227468970408E-15
     -9.75193038344993E-23  -8.96711601292643E-09  -8.96711387065184E-09  -2.97035397513252E-18
      1.63884574530779E-08
      0.00000000000000E+00  -8.89534648802338E-12   0.00000000000000E+00   3.60478789511205E-14   1.49476768120824E-22
      8.89536578773233E-09   8.89540183561143E-09  -8.21389087897178E-19  -2.34618481461488E-01  -2.34618481461490E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86521051883468E-12   0.00000000000000E+00   1.86521051883468E-12
      3.79460706707289E-18  -2.34618481749223E-01  -2.31815377533297E-01   0.00000000000000E+00  -3.24414030088107E-14
     -9.74823890988318E-23  -8.89723460472716E-09  -8.89726704613027E-09  -2.97321797917572E-18
      1.83884574530779E-08
      0.00000000000000E+00  -8.84271945360347E-12   0.00000000000000E+00   3.01064057011287E-15   1.49854669484541E-22
      8.84273563129693E-09   8.84273864193765E-09  -8.22052590632585E-19  -2.34248051699351E-01  -2.34248051699352E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43350892884501E-12   0.00000000000000E+00   1.43350892884501E-12
      3.79747408493059E-18  -2.34248052045820E-01  -2.31461664897658E-01   0.00000000000000E+00  -1.16964010545040E-16
     -9.74541313881949E-23  -8.84417203390239E-09  -8.84417215086650E-09  -2.97542149429800E-18
      2.03884574530779E-08
      0.00000000000000E+00  -8.80258330344378E-12   0.00000000000000E+00   2.48807357786538E-14   1.50148391585566E-22
      8.80257403864820E-09   8.80259891938413E-09  -8.22561599343862E-19  -2.33963632784182E-01  -2.33963632784183E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10206432668276E-12   0.00000000000000E+00   1.10206432668276E-12
      3.79967821358395E-18  -2.33963633175169E-01  -2.31190003269454E-01   0.00000000000000E+00  -2.27881755782323E-14
     -9.74323901173125E-23  -8.80367819553515E-09  -8.80370098371082E-09  -2.97711661424009E-18
      2.23884574530779E-08
      0.00000000000000E+00  -8.77181531647926E-12   0.00000000000000E+00   6.49338006833686E-16   1.50376292509685E-22
      8.77186729576509E-09   8.77186794510325E-09  -8.22952680556221E-19  -2.33744999693542E-01  -2.33744999693543E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47590214105423E-13   0.00000000000000E+00   8.47590214105423E-13
      3.80137339401216E-18  -2.33745000104381E-01  -2.30981124496036E-01   0.00000000000000E+00   1.05833029388545E-15
     -9.74157593214504E-23  -8.77271659364756E-09  -8.77271553531736E-09  -2.97842071345594E-18
      2.43884574530779E-08
      0.00000000000000E+00  -8.74839490849134E-12   0.00000000000000E+00   7.95280455965836E-15   1.50552158679676E-22
      8.74831823123600E-09   8.74832618404071E-09  -8.23253391334217E-19  -2.33576827814379E-01  -2.33576827814379E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52094092821308E-13   0.00000000000000E+00   6.52094092821308E-13
      3.80267758219780E-18  -2.33576828208247E-01  -2.30820433278011E-01   0.00000000000000E+00  -6.68529363518461E-15
     -9.74029550900361E-23  -8.74897159283979E-09  -8.74897827813353E-09  -2.97942419086359E-18
      2.63884574530779E-08
      0.00000000000000E+00  -8.73020965052425E-12   0.00000000000000E+00   3.10848186950537E-17   1.50687967359454E-22
      8.73024482972030E-09   8.73024486080527E-09  -8.23484791894374E-19  -2.33447391288268E-01  -2.33447391288269E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01857497889733E-13   0.00000000000000E+00   5.01857497889733E-13
      3.80368129719358E-18  -2.33447391615155E-01  -2.30696738018248E-01   0.00000000000000E+00   9.76810672898418E-16
     -9.73931392145910E-23  -8.73074769511374E-09  -8.73074671830316E-09  -2.98019650529921E-18
      2.83884574530779E-08
      0.00000000000000E+00  -8.71634109520591E-12   0.00000000000000E+00   2.57244913434540E-15   1.50792583439364E-22
      8.71635153329506E-09   8.71635410574434E-09  -8.23662926744455E-19  -2.33347734339862E-01  -2.33347734339862E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86337105082991E-13   0.00000000000000E+00   3.86337105082991E-13
      3.80445397140375E-18  -2.33347734536394E-01  -2.30601494392393E-01   0.00000000000000E+00  -1.81294208206385E-15
     -9.73855833659676E-23  -8.71673862990725E-09  -8.71674044284943E-09  -2.98079104465929E-18
      3.03884574530779E-08
      0.00000000000000E+00  -8.70568710568984E-12   0.00000000000000E+00  -9.93401672899656E-17   1.50873238490339E-22
      8.70566762660818E-09   8.70566752726816E-09  -8.23800111881426E-19  -2.33270980221763E-01  -2.33270980221763E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97480905628782E-13   0.00000000000000E+00   2.97480905628782E-13
      3.80504893321501E-18  -2.33270980212083E-01  -2.30528134011796E-01   0.00000000000000E+00   6.94960556982371E-16
     -9.73797810744070E-23  -8.70596570313426E-09  -8.70596500817380E-09  -2.98124882133358E-18
      3.23884574530779E-08
      0.00000000000000E+00  -8.69742107934116E-12   0.00000000000000E+00   8.08945070954249E-16   1.50935348217778E-22
      8.69744450721419E-09   8.69744531615941E-09  -8.23905781685460E-19  -2.33211854815334E-01  -2.33211854815334E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29104941909523E-13   0.00000000000000E+00   2.29104941909523E-13
      3.80550714309883E-18  -2.33211854514356E-01  -2.30471620535739E-01   0.00000000000000E+00  -3.56069470562813E-16
     -9.73753140177946E-23  -8.69767406503175E-09  -8.69767442110132E-09  -2.98160136141336E-18
      3.43884574530779E-08
      0.00000000000000E+00  -8.69108379247384E-12   0.00000000000000E+00  -9.94175609915981E-17   1.50983208901456E-22
      8.69111426251674E-09   8.69111416309933E-09  -8.23987193472717E-19  -2.33166300983593E-01  -2.33166300983593E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76474776154860E-13   0.00000000000000E+00   1.76474776154860E-13
      3.80586009265114E-18  -2.33166300301605E-01  -2.30428077238330E-01   0.00000000000000E+00   4.51884680097629E-16
     -9.73718794599775E-23  -8.69129108976006E-09  -8.69129063787548E-09  -2.98187289917842E-18
      3.63884574530779E-08
      0.00000000000000E+00  -8.68621602140184E-12   0.00000000000000E+00   2.33346505760120E-16   1.51020068812033E-22
      8.68623879245552E-09   8.68623902580217E-09  -8.24049922375575E-19  -2.33131200132070E-01  -2.33131200132071E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35952323208100E-13   0.00000000000000E+00   1.35952323208100E-13
      3.80613199729755E-18  -2.33131198982228E-01  -2.30394524694399E-01   0.00000000000000E+00   3.60896406623838E-17
     -9.73692345890577E-23  -8.68637501421493E-09  -8.68637497812538E-09  -2.98208207492198E-18
      3.83884574530779E-08
      0.00000000000000E+00  -8.68245038717633E-12   0.00000000000000E+00   3.31079481769013E-16   1.51048477305031E-22
      8.68248333369932E-09   8.68248366477896E-09  -8.24098260938926E-19  -2.33104151200457E-01  -2.33104151200457E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04746382173181E-13   0.00000000000000E+00   1.04746382173181E-13
      3.80634149006190E-18  -2.33104149508957E-01  -2.30368668204113E-01   0.00000000000000E+00  -1.26580690968136E-16
     -9.73671993414339E-23  -8.68258828458035E-09  -8.68258841116114E-09  -2.98224322912297E-18
      4.03884574530779E-08
      0.00000000000000E+00  -8.67960320032290E-12   0.00000000000000E+00   5.24258310727305E-17   1.51070348714671E-22
      8.67959012573724E-09   8.67959017816322E-09  -8.24135513267510E-19  -2.33083305622078E-01  -2.33083305622079E-01
      0.00000000000000E+00   0.00000000000000E+00   8.07098746994601E-14   0.00000000000000E+00   8.07098746994601E-14
      3.80650290981130E-18  -2.33083303341208E-01  -2.30348741109873E-01   0.00000000000000E+00   1.06948885516666E-16
     -9.73656315996746E-23  -8.67967099498670E-09  -8.67967088803792E-09  -2.98236739654379E-18
      4.23884574530779E-08
      0.00000000000000E+00  -8.67739892662992E-12   0.00000000000000E+00   9.39526380585016E-17   1.51087208303055E-22
      8.67736073802696E-09   8.67736083197975E-09  -8.24164223257662E-19  -2.33067240107470E-01  -2.33067240107470E-01
      0.00000000000000E+00   0.00000000000000E+00   6.21937276922021E-14   0.00000000000000E+00   6.21937276922021E-14
      3.80662729726668E-18  -2.33067237231479E-01  -2.30333383198585E-01   0.00000000000000E+00   2.83577834564166E-17
     -9.73644245414776E-23  -8.67742305406513E-09  -8.67742302570744E-09  -2.98246307400902E-18
      4.43884574530779E-08
      0.00000000000000E+00  -8.67556203188577E-12   0.00000000000000E+00   8.67075798837852E-16   1.51100209355620E-22
      8.67564257468559E-09   8.67564344176154E-09  -8.24186349619428E-19  -2.33054858474893E-01  -2.33054858474893E-01
      0.00000000000000E+00   0.00000000000000E+00   4.79284713661477E-14   0.00000000000000E+00   4.79284713661477E-14
      3.80672315420942E-18  -2.33054855057802E-01  -2.30321546823821E-01   0.00000000000000E+00  -7.81394213492607E-16
     -9.73634946282905E-23  -8.67569058883859E-09  -8.67569137023290E-09  -2.98253680458999E-18
      4.63884574530779E-08
      0.00000000000000E+00  -8.67427620556486E-12   0.00000000000000E+00   1.93866504130369E-17   1.51110205057302E-22
      8.67431894315094E-09   8.67431896253774E-09  -8.24203404572453E-19  -2.33045314847751E-01  -2.33045314847751E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69365740205959E-14   0.00000000000000E+00   3.69365740205959E-14
      3.80679702735746E-18  -2.33045311022583E-01  -2.30312423260196E-01   0.00000000000000E+00   5.18950812413734E-17
     -9.73627782730170E-23  -8.67435595100674E-09  -8.67435589911176E-09  -2.98259362278500E-18
      4.83884574530779E-08
      0.00000000000000E+00  -8.67326591345558E-12   0.00000000000000E+00   2.95415268713795E-16   1.51117919870949E-22
      8.67329844663270E-09   8.67329874204812E-09  -8.24216549795224E-19  -2.33037959075441E-01  -2.33037959075441E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84671610158961E-14   0.00000000000000E+00   2.84671610158961E-14
      3.80685396167949E-18  -2.33037955072992E-01  -2.30305391484204E-01   0.00000000000000E+00  -2.42225283197404E-16
     -9.73622263778729E-23  -8.67332696698376E-09  -8.67332720920914E-09  -2.98263741188426E-18
      5.03884574530779E-08
      0.00000000000000E+00  -8.67253115555792E-12   0.00000000000000E+00  -1.13696208808289E-18   1.51123857508545E-22
      8.67251207777413E-09   8.67251207663732E-09  -8.24226682481666E-19  -2.33032289086558E-01  -2.33032289086558E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19409181561826E-14   0.00000000000000E+00   2.19409181561826E-14
      3.80689784351580E-18  -2.33032285251958E-01  -2.30299971463740E-01   0.00000000000000E+00   4.39706542113740E-17
     -9.73618011613266E-23  -8.67253406152604E-09  -8.67253401755548E-09  -2.98267116103413E-18
      5.23884574530779E-08
      0.00000000000000E+00  -8.67188824239747E-12   0.00000000000000E+00   9.80179343585021E-17   1.51128437563775E-22
      8.67190581693427E-09   8.67190591495236E-09  -8.24234493033608E-19  -2.33027918531169E-01  -2.33027918531170E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69119189253319E-14   0.00000000000000E+00   1.69119189253319E-14
      3.80693166735365E-18  -2.33027915334991E-01  -2.30295794132508E-01   0.00000000000000E+00  -6.56269858451490E-17
     -9.73614735477164E-23  -8.67192276124419E-09  -8.67192282687128E-09  -2.98269717432004E-18
      5.43884574530779E-08
      0.00000000000000E+00  -8.67142901871143E-12   0.00000000000000E+00  -5.13677239454985E-18   1.51131964361352E-22
      8.67143853878472E-09   8.67143853364810E-09  -8.24240514216635E-19  -2.33024549284712E-01  -2.33024549284712E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30366403975602E-14   0.00000000000000E+00   1.30366403975602E-14
      3.80695774063444E-18  -2.33024547326038E-01  -2.30292574559786E-01   0.00000000000000E+00   3.07415581143763E-17
     -9.73612211451414E-23  -8.67145160102995E-09  -8.67145157028849E-09  -2.98271722641781E-18
      5.63884574530779E-08
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   3.09310902017855E-17   1.51134683611603E-22
      8.67107825394851E-09   8.67107828487976E-09  -8.24245156258297E-19  -2.33021951787160E-01  -2.33021951787160E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00504581396785E-14   0.00000000000000E+00   1.00504581396785E-14
      3.80697784155073E-18  -2.33021951784085E-01  -2.30290093465743E-01   0.00000000000000E+00  -1.14213501887044E-17
     -9.73610267167896E-23  -8.67108832391645E-09  -8.67108833533790E-09  -2.98273268529243E-18
      5.83884574530779E-08
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00  -4.62967155312171E-18   1.51136778037309E-22
      8.67080048982186E-09   8.67080048519234E-09  -8.24248735533348E-19  -2.33019948997145E-01  -2.33019948997145E-01
      0.00000000000000E+00   0.00000000000000E+00   7.74941628130344E-15   0.00000000000000E+00   7.74941628130344E-15
      3.80699334038329E-18  -2.33019951761325E-01  -2.30288181677111E-01   0.00000000000000E+00   1.98797623035744E-17
     -9.73608769802430E-23  -8.67080825448829E-09  -8.67080823460863E-09  -2.98274460484994E-18
      6.03884574530779E-08
      0.00000000000000E+00  -8.67060241607656E-12   0.00000000000000E+00   8.74386425670578E-18   1.51138392466116E-22
      8.67058628526867E-09   8.67058629401269E-09  -8.24251495696850E-19  -2.33018404561455E-01  -2.33018404561455E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97631573276315E-15   0.00000000000000E+00   5.97631573276315E-15
      3.80700529301475E-18  -2.33018410951934E-01  -2.30286708911125E-01   0.00000000000000E+00   2.92328290032665E-18
     -9.73607617063086E-23  -8.67059227325161E-09  -8.67059227032843E-09  -2.98275379731790E-18
      6.23884574530779E-08
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00  -3.30506110353069E-18   1.51139636246358E-22
      8.67042109739004E-09   8.67042109408513E-09  -8.24253624531688E-19  -2.33017213389130E-01  -2.33017213389130E-01
      0.00000000000000E+00   0.00000000000000E+00   4.60992601682614E-15   0.00000000000000E+00   4.60992601682614E-15
      3.80701451286679E-18  -2.33017224242411E-01  -2.30285574674281E-01   0.00000000000000E+00   1.23591055194590E-17
     -9.73606730051781E-23  -8.67042571637015E-09  -8.67042570401114E-09  -2.98276088833510E-18
      6.43884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.79243469155180E-18   1.51140595146281E-22
      8.67029369116203E-09   8.67029369295461E-09  -8.24255266593170E-19  -2.33016294574739E-01  -2.33016294574739E-01
      0.00000000000000E+00   0.00000000000000E+00   3.55673360997766E-15   0.00000000000000E+00   3.55673360997766E-15
      3.80702162633401E-18  -2.33016310607929E-01  -2.30284701510739E-01   0.00000000000000E+00   5.13817513024511E-18
     -9.73606047928297E-23  -8.67029725482630E-09  -8.67029724968822E-09  -2.98276635974084E-18
      6.63884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00  -2.15652050216656E-18   1.51141334551790E-22
      8.67019544344963E-09   8.67019544129327E-09  -8.24256533149147E-19  -2.33015585836800E-01  -2.33015585836800E-01
      0.00000000000000E+00   0.00000000000000E+00   2.74455628652181E-15   0.00000000000000E+00   2.74455628652181E-15
      3.80702711544658E-18  -2.33015607523238E-01  -2.30284029634718E-01   0.00000000000000E+00   7.51639005350653E-18
     -9.73605523660159E-23  -8.67019819336585E-09  -8.67019818584956E-09  -2.98277058229743E-18
      6.83884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.32354605301392E-19   1.51141905465590E-22
      8.67011971152176E-09   8.67011971138956E-09  -8.24257509727614E-19  -2.33015039294949E-01  -2.33015039294949E-01
      0.00000000000000E+00   0.00000000000000E+00   2.11765416578849E-15   0.00000000000000E+00   2.11765416578849E-15
      3.80703135075491E-18  -2.33015066713617E-01  -2.30283512881833E-01   0.00000000000000E+00   4.22982969872849E-18
     -9.73605120854033E-23  -8.67012183327345E-09  -8.67012182904372E-09  -2.98277384102730E-18
      7.03884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.35403680856988E-18   1.51142347019500E-22
      8.67006140243374E-09   8.67006140107985E-09  -8.24258262004408E-19  -2.33014618176245E-01  -2.33014618176245E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63295321194927E-15   0.00000000000000E+00   1.63295321194927E-15
      3.80703461666134E-18  -2.33014650839909E-01  -2.30283115531021E-01   0.00000000000000E+00   4.51242516109094E-18
     -9.73604811226925E-23  -8.67006303854539E-09  -8.67006303403306E-09  -2.98277635465693E-18
      7.23884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -4.87489974595926E-19   1.51142689641140E-22
      8.67001660618651E-09   8.67001660569917E-09  -8.24258840318059E-19  -2.33014294290867E-01  -2.33014294290867E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25716604830471E-15   0.00000000000000E+00   1.25716604830471E-15
      3.80703713099343E-18  -2.33014330962192E-01  -2.30282809884682E-01   0.00000000000000E+00   2.92162412421765E-18
     -9.73604572729163E-23  -8.67001786578674E-09  -8.67001786286522E-09  -2.98277829067537E-18
      7.43884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -8.20134022403704E-19   1.51142956740601E-22
      8.66998233176055E-09   8.66998233094057E-09  -8.24259283187489E-19  -2.33014046065776E-01  -2.33014046065776E-01
      0.00000000000000E+00   0.00000000000000E+00   9.64574608512299E-16   0.00000000000000E+00   9.64574608512299E-16
      3.80703906014265E-18  -2.33014084575369E-01  -2.30282574388144E-01   0.00000000000000E+00   2.70874480879576E-18
     -9.73604388053103E-23  -8.66998329822382E-09  -8.66998329551517E-09  -2.98277977695516E-18
      7.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.23234803908361E-19   1.51143166425794E-22
      8.66995628901824E-09   8.66995628859516E-09  -8.24259620042069E-19  -2.33013857020491E-01  -2.33013857020490E-01
      0.00000000000000E+00   0.00000000000000E+00   7.35354502307539E-16   0.00000000000000E+00   7.35354502307539E-16
      3.80704053085165E-18  -2.33013894107024E-01  -2.30282392196734E-01   0.00000000000000E+00   1.90513636623873E-18
     -9.73604243542129E-23  -8.66995702585470E-09  -8.66995702394966E-09  -2.98278091080958E-18
      7.83884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -4.73786325880666E-19   1.51143332542450E-22
      8.66993672524607E-09   8.66993672477244E-09  -8.24259873367105E-19  -2.33013714570060E-01  -2.33013714570060E-01
      0.00000000000000E+00   0.00000000000000E+00   5.54296277126835E-16   0.00000000000000E+00   5.54296277126835E-16
      3.80704163944421E-18  -2.33013745768008E-01  -2.30282250078285E-01   0.00000000000000E+00   1.66913843031643E-18
     -9.73604128342661E-23  -8.66993728073775E-09  -8.66993727906871E-09  -2.98278176607710E-18
      8.03884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.75892690102825E-19   1.51143465603601E-22
      8.66992229096933E-09   8.66992229069359E-09  -8.24260060402355E-19  -2.33013609079226E-01  -2.33013609079226E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09852759723247E-16   0.00000000000000E+00   4.09852759723247E-16
      3.80704245914973E-18  -2.33013628685980E-01  -2.30282137589245E-01   0.00000000000000E+00   1.26445375438336E-18
     -9.73604033810161E-23  -8.66992270181070E-09  -8.66992270054634E-09  -2.98278239874737E-18
      8.23884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.52732005820155E-19   1.51143573390573E-22
      8.66991193529124E-09   8.66991193503867E-09  -8.24260194505270E-19  -2.33013533104092E-01  -2.33013533104092E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93422019690226E-16   0.00000000000000E+00   2.93422019690226E-16
      3.80704304599376E-18  -2.33013534262584E-01  -2.30282046465048E-01   0.00000000000000E+00   1.11606553260170E-18
     -9.73603953078369E-23  -8.66991222957665E-09  -8.66991222846068E-09  -2.98278285148850E-18
      8.43884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.43748403712718E-19   1.51143661449780E-22
      8.66990481919171E-09   8.66990481904811E-09  -8.24260286261500E-19  -2.33013480775482E-01  -2.33013480775482E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98820303414471E-16   0.00000000000000E+00   1.98820303414471E-16
      3.80704344363437E-18  -2.33013455711883E-01  -2.30281970186039E-01   0.00000000000000E+00   9.33964103771176E-19
     -9.73603880797207E-23  -8.66990501880228E-09  -8.66990501786841E-09  -2.98278315737287E-18
      8.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.14896306804679E-19   1.51143733427944E-22
      8.66990024539304E-09   8.66990024527829E-09  -8.24260344401889E-19  -2.33013447289851E-01  -2.33013447289851E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21886412277282E-16   0.00000000000000E+00   1.21886412277282E-16
      3.80704368740720E-18  -2.33013387745460E-01  -2.30281903684787E-01   0.00000000000000E+00   8.75524708195652E-19
     -9.73603812983715E-23  -8.66990036804013E-09  -8.66990036716470E-09  -2.98278334300531E-18
      8.83884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.49190469031850E-20   1.51143791346747E-22
      8.66989759980772E-09   8.66989759974295E-09  -8.24260376567466E-19  -2.33013428484248E-01  -2.33013428484248E-01
      0.00000000000000E+00   0.00000000000000E+00   6.01839049966377E-17   0.00000000000000E+00   6.01839049966377E-17
      3.80704380777501E-18  -2.33013326377965E-01  -2.30281843170180E-01   0.00000000000000E+00   8.17343181893964E-19
     -9.73603746986520E-23  -8.66989766074409E-09  -8.66989765992685E-09  -2.98278343120754E-18
      8.93884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.84780086541385E-20   1.51143826126873E-22
      8.66989668588633E-09   8.66989668581800E-09  -8.24260387066120E-19  -2.33013422258649E-01  -2.33013422258649E-01
      0.00000000000000E+00   0.00000000000000E+00   3.29370437300584E-17   0.00000000000000E+00   3.29370437300584E-17
      3.80704384071205E-18  -2.33013296922523E-01  -2.30281814011230E-01   0.00000000000000E+00   8.23263202031598E-19
     -9.73603713069720E-23  -8.66989671957820E-09  -8.66989671875504E-09  -2.98278345364593E-18
      8.95572074530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.12682281142172E-20   1.51143821310380E-22
      8.66989654287109E-09   8.66989654282997E-09  -8.24260388682998E-19  -2.33013421296217E-01  -2.33013421296217E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84471931209927E-17   0.00000000000000E+00   2.84471931209927E-17
      3.80704384551251E-18  -2.33013291985449E-01  -2.30281809120624E-01   0.00000000000000E+00   7.94948789992408E-19
     -9.73603708635049E-23  -8.66989657207202E-09  -8.66989657127717E-09  -2.98278345682952E-18
      8.97850199530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.84152063611404E-20   1.51143826745898E-22
      8.66989636962855E-09   8.66989636959028E-09  -8.24260390594470E-19  -2.33013420151867E-01  -2.33013420151867E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25536383985415E-17   0.00000000000000E+00   2.25536383985415E-17
      3.80704385065052E-18  -2.33013285375319E-01  -2.30281802566925E-01   0.00000000000000E+00   7.94109343207369E-19
     -9.73603701148374E-23  -8.66989639293793E-09  -8.66989639214392E-09  -2.98278346005604E-18
      9.00925668280779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.25555386067441E-20   1.51143833866528E-22
      8.66989616964763E-09   8.66989616961523E-09  -8.24260392705951E-19  -2.33013418875519E-01  -2.33013418875519E-01
      0.00000000000000E+00   0.00000000000000E+00   1.49361201990783E-17   0.00000000000000E+00   1.49361201990783E-17
      3.80704385524407E-18  -2.33013276542209E-01  -2.30281793799213E-01   0.00000000000000E+00   7.91309358397137E-19
     -9.73603691143731E-23  -8.66989618534256E-09  -8.66989618455134E-09  -2.98278346253812E-18
      9.05077551093279E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.60027328751580E-20   1.51143842971193E-22
      8.66989595641974E-09   8.66989595639389E-09  -8.24260394764090E-19  -2.33013417608221E-01  -2.33013417608221E-01
      0.00000000000000E+00   0.00000000000000E+00   5.24634277524953E-18   0.00000000000000E+00   5.24634277524953E-18
      3.80704385742229E-18  -2.33013264758385E-01  -2.30281782085610E-01   0.00000000000000E+00   7.86872543799083E-19
     -9.73603677557815E-23  -8.66989596242701E-09  -8.66989596164024E-09  -2.98278346265820E-18
      9.10682592890154E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.09916562062923E-20   1.51143854244171E-22
      8.66989575970045E-09   8.66989575967961E-09  -8.24260396250771E-19  -2.33013416646226E-01  -2.33013416646226E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76150153900650E-18   0.00000000000000E+00  -6.76150153900650E-18
      3.80704385363244E-18  -2.33013249054627E-01  -2.30281766447598E-01   0.00000000000000E+00   7.82918548266934E-19
     -9.73603659197231E-23  -8.66989575370094E-09  -8.66989575291812E-09  -2.98278345738167E-18
      9.18249399315936E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.53878785333336E-16   1.51143868412269E-22
      8.66989547729602E-09   8.66989532341738E-09  -8.24260395448478E-19  -2.33013416917654E-01  -2.33013416917654E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42506036706765E-17   0.00000000000000E+00  -2.42506036706765E-17
      3.80704383528248E-18  -2.33013227153100E-01  -2.30281744640475E-01   0.00000000000000E+00   1.52931722933542E-16
     -9.73603545170648E-23  -8.66989545209840E-09  -8.66989529916678E-09  -2.98278343983400E-18
      9.23356993653338E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.32743100907736E-16   1.51143877871235E-22
      8.66989584705484E-09   8.66989571431189E-09  -8.24260393920233E-19  -2.33013417666181E-01  -2.33013417666181E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.20922939936911E-17   0.00000000000000E+00  -3.20922939936911E-17
      3.80704381889104E-18  -2.33013214201041E-01  -2.30281731574418E-01   0.00000000000000E+00   1.36054895874148E-16
     -9.73603683492776E-23  -8.66989581827439E-09  -8.66989568221959E-09  -2.98278342497081E-18
      9.30252246008831E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.43094154408471E-21   1.51143888850100E-22
      8.66989587731170E-09   8.66989587731528E-09  -8.24260390518733E-19  -2.33013419453213E-01  -2.33013419453213E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.53709127709724E-17   0.00000000000000E+00  -4.53709127709724E-17
      3.80704378760665E-18  -2.33013195143639E-01  -2.30281712511675E-01   0.00000000000000E+00   7.96865435375245E-19
     -9.73603593461357E-23  -8.66989583274111E-09  -8.66989583194435E-09  -2.98278339708791E-18
      9.39560836688747E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.11889660803360E-20   1.51143899784948E-22
      8.66989611082456E-09   8.66989611083590E-09  -8.24260384696745E-19  -2.33013422740929E-01  -2.33013422740929E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63700232559541E-17   0.00000000000000E+00  -5.63700232559541E-17
      3.80704373513410E-18  -2.33013169559769E-01  -2.30281686857680E-01   0.00000000000000E+00   7.83048397333901E-19
     -9.73603562097650E-23  -8.66989605524883E-09  -8.66989605446588E-09  -2.98278335043736E-18
      9.52127434106633E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   8.88826007689323E-21   1.51143906746911E-22
      8.66989633965120E-09   8.66989633966024E-09  -8.24260376976297E-19  -2.33013427484426E-01  -2.33013427484426E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.34056328021435E-17   0.00000000000000E+00  -6.34056328021435E-17
      3.80704365545479E-18  -2.33013135149362E-01  -2.30281652377373E-01   0.00000000000000E+00   7.71746041927482E-19
     -9.73603520576584E-23  -8.66989627702625E-09  -8.66989627625461E-09  -2.98278327847850E-18
      9.69092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.61864469511864E-21   1.51143900437139E-22
      8.66989603725513E-09   8.66989603724866E-09  -8.24260372701688E-19  -2.33013431275302E-01  -2.33013431275302E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.75784648792938E-17   0.00000000000000E+00  -5.75784648792938E-17
      3.80704355777347E-18  -2.33013089949970E-01  -2.30281607271392E-01   0.00000000000000E+00   7.18478662709459E-19
     -9.73603468956957E-23  -8.66989598038858E-09  -8.66989597967020E-09  -2.98278318507178E-18
      9.89092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.92164541006736E-20   1.51143868703254E-22
      8.66989406994524E-09   8.66989406989618E-09  -8.24260386325900E-19  -2.33013426635906E-01  -2.33013426635906E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72609408924696E-17   0.00000000000000E+00  -2.72609408924696E-17
      3.80704350325158E-18  -2.33013041486130E-01  -2.30281559417792E-01   0.00000000000000E+00   6.05912323669792E-19
     -9.73603420694101E-23  -8.66989404324104E-09  -8.66989404263522E-09  -2.98278311692569E-18
      9.94092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.02013518169282E-16   1.51143860153349E-22
      8.66989332124694E-09   8.66989342326061E-09  -8.24260390843030E-19  -2.33013424886771E-01  -2.33013424886771E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.84738515709401E-17   0.00000000000000E+00  -1.84738515709401E-17
      3.80704349401466E-18  -2.33013028956265E-01  -2.30281547121098E-01   0.00000000000000E+00  -1.01453490116614E-16
     -9.73603353725989E-23  -8.66989330333318E-09  -8.66989340478676E-09  -2.98278310317163E-18
      1.00084234062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.26402872209198E-20   1.51143844977787E-22
      8.66989247032872E-09   8.66989247026623E-09  -8.24260399693575E-19  -2.33013421212823E-01  -2.33013421212823E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.76339766529710E-18   0.00000000000000E+00  -4.76339766529710E-18
      3.80704349079937E-18  -2.33013014114447E-01  -2.30281532542976E-01   0.00000000000000E+00   4.98834393784602E-19
     -9.73603395460506E-23  -8.66989246600155E-09  -8.66989246550282E-09  -2.98278309110579E-18
      1.00995484062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -9.91937140021677E-20   1.51143819418340E-22
      8.66989064208907E-09   8.66989064199003E-09  -8.24260417211560E-19  -2.33013413380996E-01  -2.33013413380996E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91328025097687E-17   0.00000000000000E+00   1.91328025097687E-17
      3.80704350823413E-18  -2.33012995673491E-01  -2.30281514670489E-01   0.00000000000000E+00   4.27060779233641E-19
     -9.73603381619294E-23  -8.66989066154978E-09  -8.66989066112282E-09  -2.98278309102258E-18
      1.02225671562078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.39809039061354E-19   1.51143774973670E-22
      8.66988714672539E-09   8.66988714658573E-09  -8.24260453702071E-19  -2.33013396181077E-01  -2.33013396181077E-01
      0.00000000000000E+00   0.00000000000000E+00   6.13182385778984E-17   0.00000000000000E+00   6.13182385778984E-17
      3.80704358366706E-18  -2.33012975178932E-01  -2.30281495263874E-01   0.00000000000000E+00   2.80945830553947E-19
     -9.73603372200456E-23  -8.66988720818481E-09  -8.66988720790396E-09  -2.98278312996499E-18
      1.03886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.10137854134796E-19   1.51143695079110E-22
      8.66988008151674E-09   8.66988008130676E-09  -8.24260532940967E-19  -2.33013357294065E-01  -2.33013357294065E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38085580222946E-16   0.00000000000000E+00   1.38085580222946E-16
      3.80704381299312E-18  -2.33012959227019E-01  -2.30281481513726E-01   0.00000000000000E+00   3.65589133615423E-21
     -9.73603382478785E-23  -8.66988021939589E-09  -8.66988021939233E-09  -2.98278328005216E-18
      1.05886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.15304625217444E-19   1.51143568955600E-22
      8.66986742883465E-09   8.66986742851950E-09  -8.24260682652170E-19  -2.33013281703277E-01  -2.33013281703277E-01
      0.00000000000000E+00   0.00000000000000E+00   2.60058673379946E-16   0.00000000000000E+00   2.60058673379946E-16
      3.80704433311047E-18  -2.33012964726841E-01  -2.30281490961463E-01   0.00000000000000E+00  -4.53859066251483E-19
     -9.73603439898675E-23  -8.66986768812421E-09  -8.66986768857816E-09  -2.98278365045830E-18
      1.07886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.30546586580669E-19   1.51143414653434E-22
      8.66985007656987E-09   8.66985007613948E-09  -8.24260895544516E-19  -2.33013172198560E-01  -2.33013172198560E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09727404748526E-16   0.00000000000000E+00   4.09727404748526E-16
      3.80704515256528E-18  -2.33013003562401E-01  -2.30281535216874E-01   0.00000000000000E+00  -1.04688158394968E-18
     -9.73603554318554E-23  -8.66985048481990E-09  -8.66985048586687E-09  -2.98278425702076E-18
      1.08886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.92325480695371E-19   1.51143330871283E-22
      8.66984017107561E-09   8.66984017058344E-09  -8.24261018735313E-19  -2.33013108401390E-01  -2.33013108401390E-01
      0.00000000000000E+00   0.00000000000000E+00   4.91072086494020E-16   0.00000000000000E+00   4.91072086494020E-16
      3.80704564363737E-18  -2.33013032434429E-01  -2.30281567184100E-01   0.00000000000000E+00  -1.37221384908515E-18
     -9.73603627259613E-23  -8.66984066028320E-09  -8.66984066165551E-09  -2.98278462490205E-18
      1.10236424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -5.77824690282770E-19   1.51143207469130E-22
      8.66982449088307E-09   8.66982449030539E-09  -8.24261217132707E-19  -2.33013004774615E-01  -2.33013004774615E-01
      0.00000000000000E+00   0.00000000000000E+00   6.11000386508170E-16   0.00000000000000E+00   6.11000386508170E-16
      3.80704646848789E-18  -2.33013091449448E-01  -2.30281631101547E-01   0.00000000000000E+00  -1.87308376415897E-18
     -9.73603757828903E-23  -8.66982509943260E-09  -8.66982510130578E-09  -2.98278525135518E-18
      1.12058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -6.86974718659137E-19   1.51143029634284E-22
      8.66979926278090E-09   8.66979926209408E-09  -8.24261543598915E-19  -2.33012832369703E-01  -2.33012832369703E-01
      0.00000000000000E+00   0.00000000000000E+00   7.84023003707990E-16   0.00000000000000E+00   7.84023003707990E-16
      3.80704789736981E-18  -2.33013214170890E-01  -2.30281761716868E-01   0.00000000000000E+00  -2.64027777330221E-18
     -9.73603999338038E-23  -8.66980004347670E-09  -8.66980004611708E-09  -2.98278635377090E-18
      1.14058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -7.87455950170386E-19   1.51142836250310E-22
      8.66976749201030E-09   8.66976749122299E-09  -8.24261965105925E-19  -2.33012607112286E-01  -2.33012607112286E-01
      0.00000000000000E+00   0.00000000000000E+00   9.72422558610872E-16   0.00000000000000E+00   9.72422558610872E-16
      3.80704984221493E-18  -2.33013407611888E-01  -2.30281965108255E-01   0.00000000000000E+00  -3.55003142709440E-18
     -9.73604347415586E-23  -8.66976846009542E-09  -8.66976846364554E-09  -2.98278787710900E-18
      1.16058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -8.53055333030073E-19   1.51142665967307E-22
      8.66973321325599E-09   8.66973321240309E-09  -8.24262432651501E-19  -2.33012354035214E-01  -2.33012354035214E-01
      0.00000000000000E+00   0.00000000000000E+00   1.13862921904989E-15   0.00000000000000E+00   1.13862921904989E-15
      3.80705211947336E-18  -2.33013663572262E-01  -2.30282231816196E-01   0.00000000000000E+00  -4.45849756337750E-18
     -9.73604776277447E-23  -8.66973434657371E-09  -8.66973435103231E-09  -2.98278968682187E-18
      1.18058924687078E-07
      0.00000000000000E+00  -8.66968396870449E-12   0.00000000000000E+00  -8.55454797478815E-19   1.51142546436888E-22
      8.66969893060695E-09   8.66969892975165E-09  -8.24262916948559E-19  -2.33012087781629E-01  -2.33012087781629E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25576619921149E-15   0.00000000000000E+00   1.25576619921149E-15
      3.80705463100576E-18  -2.33013980907422E-01  -2.30282559915632E-01   0.00000000000000E+00  -5.27358210305027E-18
     -9.73605274345632E-23  -8.66970018024417E-09  -8.66970018551785E-09  -2.98279171405720E-18
      1.20058924687078E-07
      0.00000000000000E+00  -8.66968396870449E-12   0.00000000000000E+00  -7.67082448677260E-19   1.51142511394674E-22
      8.66966819470426E-09   8.66966819393733E-09  -8.24263374713333E-19  -2.33011830501342E-01  -2.33011830501342E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29101917916616E-15   0.00000000000000E+00   1.29101917916616E-15
      3.80705721304412E-18  -2.33014351649014E-01  -2.30282940329880E-01   0.00000000000000E+00  -5.87558066611008E-18
     -9.73605818062600E-23  -8.66966947908083E-09  -8.66966948495651E-09  -2.98279383833079E-18
      1.22058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00  -5.52334038235088E-19   1.51142599683240E-22
      8.66964566408826E-09   8.66964566353607E-09  -8.24263747406410E-19  -2.33011612636115E-01  -2.33011612636115E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20657837578439E-15   0.00000000000000E+00   1.20657837578439E-15
      3.80705962620087E-18  -2.33014758995590E-01  -2.30283354801682E-01   0.00000000000000E+00  -6.12050161045113E-18
     -9.73606369371818E-23  -8.66964686399386E-09  -8.66964687011445E-09  -2.98279587879447E-18
      1.24058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00  -8.05631161825564E-20   1.51142853330571E-22
      8.66963707679852E-09   8.66963707671811E-09  -8.24263961037598E-19  -2.33011473168820E-01  -2.33011473168820E-01
      0.00000000000000E+00   0.00000000000000E+00   9.61497285013921E-16   0.00000000000000E+00   9.61497285013921E-16
      3.80706154919544E-18  -2.33015175393739E-01  -2.30283773982697E-01   0.00000000000000E+00  -5.94108677710476E-18
     -9.73606873678091E-23  -8.66963803227421E-09  -8.66963803821539E-09  -2.98279758815785E-18
      1.26058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00   3.96215224818644E-19   1.51143314492744E-22
      8.66964909785409E-09   8.66964909825046E-09  -8.24263927501496E-19  -2.33011459085376E-01  -2.33011459085376E-01
      0.00000000000000E+00   0.00000000000000E+00   5.14660368565633E-16   0.00000000000000E+00   5.14660368565633E-16
      3.80706257851618E-18  -2.33015560949943E-01  -2.30284155892466E-01   0.00000000000000E+00  -4.85999636501963E-18
     -9.73607258677898E-23  -8.66964960805073E-09  -8.66964961291082E-09  -2.98279865101469E-18
      1.28058924687078E-07
      0.00000000000000E+00  -8.66968396870449E-12   0.00000000000000E+00   1.92277206416496E-18   1.51144021114220E-22
      8.66968900640863E-09   8.66968900833156E-09  -8.24263547933457E-19  -2.33011623781638E-01  -2.33011623781638E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71004782564804E-16   0.00000000000000E+00  -1.71004782564804E-16
      3.80706223650662E-18  -2.33015862473597E-01  -2.30284445058680E-01   0.00000000000000E+00  -3.71724959244637E-18
     -9.73607434565914E-23  -8.66968883360942E-09  -8.66968883732677E-09  -2.98279868857316E-18
      1.30058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00   2.21647419390334E-18   1.51145001209477E-22
      8.66976419082354E-09   8.66976419304017E-09  -8.24262718590099E-19  -2.33012024136305E-01  -2.33012024136305E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12297846567208E-15   0.00000000000000E+00  -1.12297846567208E-15
      3.80705999054968E-18  -2.33016013511611E-01  -2.30284572709113E-01   0.00000000000000E+00  -4.04050061479017E-20
     -9.73607296158667E-23  -8.66976307002120E-09  -8.66976307006170E-09  -2.98279727195959E-18
      1.32058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   5.72140958869814E-18   1.51146265851712E-22
      8.66988141856497E-09   8.66988142428653E-09  -8.24261339659910E-19  -2.33012716014310E-01  -2.33012716014310E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35230226861352E-15   0.00000000000000E+00  -2.35230226861352E-15
      3.80705528594515E-18  -2.33015935789954E-01  -2.30284458441032E-01   0.00000000000000E+00   1.80746975041850E-18
     -9.73606727482454E-23  -8.66987907379164E-09  -8.66987907198426E-09  -2.98279394628524E-18
      1.34058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   4.78264289830928E-18   1.51147800921176E-22
      8.67004587746627E-09   8.67004588224907E-09  -8.24259327341732E-19  -2.33013748000783E-01  -2.33013748000783E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.84562489885814E-15   0.00000000000000E+00  -3.84562489885814E-15
      3.80704759469535E-18  -2.33015542475369E-01  -2.30284013782469E-01   0.00000000000000E+00   9.58756497033394E-18
     -9.73605609446669E-23  -8.67004204621164E-09  -8.67004203662417E-09  -2.98278826735362E-18
      1.36058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.04593039381265E-17   1.51149558259127E-22
      8.67025996766966E-09   8.67025997812912E-09  -8.24256629225931E-19  -2.33015153311233E-01  -2.33015153311233E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55643960905571E-15   0.00000000000000E+00  -5.55643960905571E-15
      3.80703648181613E-18  -2.33014743708803E-01  -2.30283148103496E-01   0.00000000000000E+00   1.19673636864403E-17
     -9.73603830934820E-23  -8.67025443365677E-09  -8.67025442168951E-09  -2.98277985259020E-18
      1.38058924687078E-07
      0.00000000000000E+00  -8.67051057133935E-12   0.00000000000000E+00   7.34766307857360E-18   1.51151446377506E-22
      8.67052191000134E-09   8.67052191734915E-09  -8.24253242810900E-19  -2.33016939937758E-01  -2.33016939937758E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.39627815845396E-15   0.00000000000000E+00  -7.39627815845396E-15
      3.80702168925981E-18  -2.33013454714507E-01  -2.30281777161012E-01   0.00000000000000E+00   2.43407800361671E-17
     -9.73601303793136E-23  -8.67051454541168E-09  -8.67051452107099E-09  -2.98276844644892E-18
      1.40058924687078E-07
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00   1.29534759070495E-17   1.51153322343964E-22
      8.67082417598657E-09   8.67082418894019E-09  -8.24249236454586E-19  -2.33019079355167E-01  -2.33019079355167E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.22639869149395E-15   0.00000000000000E+00  -9.22639869149395E-15
      3.80700323646243E-18  -2.33011606793518E-01  -2.30279834584229E-01   0.00000000000000E+00   2.82322907342034E-17
     -9.73597981472257E-23  -8.67081499077369E-09  -8.67081496254150E-09  -2.98275400000785E-18
      1.42058924687078E-07
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   8.53891853638956E-18   1.51154985002943E-22
      8.67115191466526E-09   8.67115192320433E-09  -8.24244771625731E-19  -2.33021494354827E-01  -2.33021494354827E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08516488798228E-14   0.00000000000000E+00  -1.08516488798228E-14
      3.80698153316467E-18  -2.33009161137653E-01  -2.30277286182414E-01   0.00000000000000E+00   4.21754506256336E-17
     -9.73593881255492E-23  -8.67114111373080E-09  -8.67114107155545E-09  -2.98273676153894E-18
      1.44058924687078E-07
      0.00000000000000E+00  -8.67152086344864E-12   0.00000000000000E+00   9.90265013233961E-18   1.51156172294363E-22
      8.67148143904976E-09   8.67148144895257E-09  -8.24240124664788E-19  -2.33024046912254E-01  -2.33024046912254E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20171748103693E-14   0.00000000000000E+00  -1.20171748103693E-14
      3.80695749881505E-18  -2.33006125318087E-01  -2.30274146909237E-01   0.00000000000000E+00   4.85685493202908E-17
     -9.73589108810914E-23  -8.67146948034619E-09  -8.67146943177774E-09  -2.98271737415027E-18
      1.46058924687078E-07
      0.00000000000000E+00  -8.67179639766026E-12   0.00000000000000E+00   7.49529780999484E-18   1.51156562926341E-22
      8.67177905730438E-09   8.67177906479983E-09  -8.24235705551367E-19  -2.33026527385933E-01  -2.33026527385933E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24105692208748E-14   0.00000000000000E+00  -1.24105692208748E-14
      3.80693267767661E-18  -2.33002571710650E-01  -2.30270499657081E-01   0.00000000000000E+00   5.63188359494668E-17
     -9.73583883956527E-23  -8.67176671054935E-09  -8.67176665423061E-09  -2.98269697212524E-18
      1.48058924687078E-07
      0.00000000000000E+00  -8.67198008713468E-12   0.00000000000000E+00   7.33091072007477E-18   1.51155785774914E-22
      8.67200042970553E-09   8.67200043703659E-09  -8.24232070502096E-19  -2.33028646714789E-01  -2.33028646714789E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16704106366714E-14   0.00000000000000E+00  -1.16704106366714E-14
      3.80690933685534E-18  -2.32998656834608E-01  -2.30266514801033E-01   0.00000000000000E+00   5.69611078407475E-17
     -9.73578564896191E-23  -8.67198882358697E-09  -8.67198876662596E-09  -2.98267726635324E-18
      1.50058924687078E-07
      0.00000000000000E+00  -8.67207193187188E-12   0.00000000000000E+00   5.89017131197293E-18   1.51153437668017E-22
      8.67209078652089E-09   8.67209079241121E-09  -8.24229924615927E-19  -2.33030033628284E-01  -2.33030033628284E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.40372130045168E-15   0.00000000000000E+00  -9.40372130045168E-15
      3.80689052941274E-18  -2.32994639900428E-01  -2.30262468683562E-01   0.00000000000000E+00   5.25795961432006E-17
     -9.73573668391385E-23  -8.67208144126941E-09  -8.67208138868991E-09  -2.98266060479681E-18
      1.52058924687078E-07
      0.00000000000000E+00  -8.67198008713468E-12   0.00000000000000E+00   3.41727447257142E-17   1.51149112447951E-22
      8.67198632930555E-09   8.67198636347845E-09  -8.24230109766289E-19  -2.33030239426622E-01  -2.33030239426622E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.21419177392870E-15   0.00000000000000E+00  -5.21419177392870E-15
      3.80688010102919E-18  -2.32990898331368E-01  -2.30258758703495E-01   0.00000000000000E+00   9.77727628603276E-18
     -9.73569881339061E-23  -8.67198115906385E-09  -8.67198114928667E-09  -2.98264999126290E-18
      1.54058924687078E-07
      0.00000000000000E+00  -8.67161270818585E-12   0.00000000000000E+00   8.79521316168087E-18   1.51142441593951E-22
      8.67161717577976E-09   8.67161718457512E-09  -8.24233573903446E-19  -2.33028752501328E-01  -2.33028752501328E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25841860716259E-15   0.00000000000000E+00   1.25841860716259E-15
      3.80688261786640E-18  -2.32987937305783E-01  -2.30255911942963E-01   0.00000000000000E+00   9.88595629736391E-18
     -9.73568059832527E-23  -8.67161845287958E-09  -8.67161844299372E-09  -2.98264904396296E-18
      1.56058924687078E-07
      0.00000000000000E+00  -8.67087795028819E-12   0.00000000000000E+00   1.38085603603584E-16   1.51133149570978E-22
      8.67091205384451E-09   8.67091219193027E-09  -8.24241315198287E-19  -2.33025026059054E-01  -2.33025026059054E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02847472741807E-14   0.00000000000000E+00   1.02847472741807E-14
      3.80690318736095E-18  -2.32986390086617E-01  -2.30254584034738E-01   0.00000000000000E+00  -1.57971386514602E-16
     -9.73569209620394E-23  -8.67092231870606E-09  -8.67092247667754E-09  -2.98266187216266E-18
      1.58058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.89402622402862E-17   1.51121117856674E-22
      8.66980542725624E-09   8.66980544619666E-09  -8.24254299963549E-19  -2.33018520041774E-01  -2.33018520041774E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19812001373607E-14   0.00000000000000E+00   2.19812001373607E-14
      3.80694714976123E-18  -2.32987004602739E-01  -2.30255543519258E-01   0.00000000000000E+00  -8.96889927365587E-17
     -9.73574443293574E-23  -8.66982733770770E-09  -8.66982742739679E-09  -2.98269284979768E-18
      1.60058924687078E-07
      0.00000000000000E+00  -8.66830629764637E-12   0.00000000000000E+00   3.27571912815677E-16   1.51106469008809E-22
      8.66824621748670E-09   8.66824654505876E-09  -8.24273346600940E-19  -2.33008761169071E-01  -2.33008761169071E-01
      0.00000000000000E+00   0.00000000000000E+00   3.62336757930862E-14   0.00000000000000E+00   3.62336757930862E-14
      3.80701961711281E-18  -2.32990613464060E-01  -2.30259639135100E-01   0.00000000000000E+00  -4.68354441305242E-16
     -9.73584908223563E-23  -8.66828231038001E-09  -8.66828277873455E-09  -2.98274627051187E-18
      1.62058924687078E-07
      0.00000000000000E+00  -8.66619386869060E-12   0.00000000000000E+00   2.34085734669503E-17   1.51089641916642E-22
      8.66621003923035E-09   8.66621006263908E-09  -8.24298980946187E-19  -2.32995419137997E-01  -2.32995419137997E-01
      0.00000000000000E+00   0.00000000000000E+00   5.26118873125537E-14   0.00000000000000E+00   5.26118873125537E-14
      3.80712484088744E-18  -2.32998080948447E-01  -2.30267742979411E-01   0.00000000000000E+00  -2.38884636134084E-16
     -9.73601680690808E-23  -8.66626243564166E-09  -8.66626267452639E-09  -2.98282585994125E-18
      1.64058924687078E-07
      0.00000000000000E+00  -8.66371406078600E-12   0.00000000000000E+00   4.67792535013254E-16   1.51071496542052E-22
      8.66371141878512E-09   8.66371188657780E-09  -8.24331257320895E-19  -2.32978401572293E-01  -2.32978401572293E-01
      0.00000000000000E+00   0.00000000000000E+00   7.02884452177197E-14   0.00000000000000E+00   7.02884452177197E-14
      3.80726541777787E-18  -2.33010227401092E-01  -2.30280671080760E-01   0.00000000000000E+00  -7.83807910130632E-16
     -9.73625624769084E-23  -8.66378139121501E-09  -8.66378217502302E-09  -2.98293416045698E-18
      1.66058924687078E-07
      0.00000000000000E+00  -8.66077502919536E-12   0.00000000000000E+00  -9.09623256067185E-18   1.51053371534897E-22
      8.66082028693380E-09   8.66082027783772E-09  -8.24369559114244E-19  -2.32957961636675E-01  -2.32957961636675E-01
      0.00000000000000E+00   0.00000000000000E+00   8.79501756397175E-14   0.00000000000000E+00   8.79501756397175E-14
      3.80744131812915E-18  -2.33027723254388E-01  -2.30299072254400E-01   0.00000000000000E+00  -3.89514910546984E-16
     -9.73657211997376E-23  -8.66090783849836E-09  -8.66090822801337E-09  -2.98307175901491E-18
      1.68058924687078E-07
      0.00000000000000E+00  -8.65774415286751E-12   0.00000000000000E+00   2.97641554742125E-16   1.51037179589338E-22
      8.65767529889497E-09   8.65767559653668E-09  -8.24412383146495E-19  -2.32934815620952E-01  -2.32934815620952E-01
      0.00000000000000E+00   0.00000000000000E+00   1.03750129610517E-13   0.00000000000000E+00   1.03750129610517E-13
      3.80764881838837E-18  -2.33050959287124E-01  -2.30323294174925E-01   0.00000000000000E+00  -8.06026590640540E-16
     -9.73696312331821E-23  -8.65777854063960E-09  -8.65777934666629E-09  -2.98323643524188E-18
      1.70058924687078E-07
      0.00000000000000E+00  -8.65443774232804E-12   0.00000000000000E+00  -7.26946303252384E-17   1.51025404953697E-22
      8.65450018687399E-09   8.65450011417951E-09  -8.24457128966660E-19  -2.32910260302436E-01  -2.32910260302436E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15258086949013E-13   0.00000000000000E+00   1.15258086949013E-13
      3.80787933456227E-18  -2.33079887821449E-01  -2.30353219442884E-01   0.00000000000000E+00  -4.93940506813104E-16
     -9.73741954217332E-23  -8.65461487832586E-09  -8.65461537226646E-09  -2.98342220559561E-18
      1.72058924687078E-07
      0.00000000000000E+00  -8.65159055547461E-12   0.00000000000000E+00  -7.20685292149454E-17   1.51021123142685E-22
      8.65161350404309E-09   8.65161343197472E-09  -8.24499916057532E-19  -2.32886277926940E-01  -2.32886277926940E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19496402178540E-13   0.00000000000000E+00   1.19496402178540E-13
      3.80811832736663E-18  -2.33113847976432E-01  -2.30388087750436E-01   0.00000000000000E+00  -5.41191133825183E-16
     -9.73792082235187E-23  -8.65173238718566E-09  -8.65173292837689E-09  -2.98361841130910E-18
      1.74058924687078E-07
      0.00000000000000E+00  -8.64938628178162E-12   0.00000000000000E+00   2.75837239064650E-17   1.51027894395171E-22
      8.64943616035214E-09   8.64943618793602E-09  -8.24535457449714E-19  -2.32865613755420E-01  -2.32865613755420E-01
      0.00000000000000E+00   0.00000000000000E+00   1.13004568166520E-13   0.00000000000000E+00   1.13004568166520E-13
      3.80834433650296E-18  -2.33151379676229E-01  -2.30426307501031E-01   0.00000000000000E+00  -6.49461171416994E-16
     -9.73843318895059E-23  -8.64954854304292E-09  -8.64954919250419E-09  -2.98380887905325E-18
      1.76058924687078E-07
      0.00000000000000E+00  -8.64846783440955E-12   0.00000000000000E+00  -2.38188690856644E-17   1.51049602264130E-22
      8.64848920613271E-09   8.64848918231399E-09  -8.24557033235941E-19  -2.32851803769062E-01  -2.32851803769063E-01
      0.00000000000000E+00   0.00000000000000E+00   9.20148753364291E-14   0.00000000000000E+00   9.20148753364291E-14
      3.80852836625363E-18  -2.33190045360140E-01  -2.30465278158099E-01   0.00000000000000E+00  -5.44170078082596E-16
     -9.73890773004126E-23  -8.64858065301915E-09  -8.64858119718933E-09  -2.98397133301769E-18
      1.78058924687078E-07
      0.00000000000000E+00  -8.64938628178162E-12   0.00000000000000E+00   8.22483738200056E-16   1.51090182204423E-22
      8.64938117860236E-09   8.64938200108625E-09  -8.24556595154559E-19  -2.32849134520929E-01  -2.32849134520929E-01
      0.00000000000000E+00   0.00000000000000E+00   5.27094127890758E-14   0.00000000000000E+00   5.27094127890758E-14
      3.80863378507921E-18  -2.33226279317480E-01  -2.30501243486940E-01   0.00000000000000E+00  -1.25714764117736E-15
     -9.73927921518656E-23  -8.64943345335129E-09  -8.64943471049903E-09  -2.98407718992465E-18
      1.80058924687078E-07
      0.00000000000000E+00  -8.65278453705830E-12   0.00000000000000E+00   8.42518959098552E-17   1.51153210190407E-22
      8.65278230380847E-09   8.65278238806051E-09  -8.24525071370055E-19  -2.32862499774014E-01  -2.32862499774014E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.38987433437227E-15   0.00000000000000E+00  -8.38987433437227E-15
      3.80861700533054E-18  -2.33255289535215E-01  -2.30529201408567E-01   0.00000000000000E+00  -2.82433414384603E-16
     -9.73946618678172E-23  -8.65277371575267E-09  -8.65277399818618E-09  -2.98409193396049E-18
      1.82058924687078E-07
      0.00000000000000E+00  -8.65939735813724E-12   0.00000000000000E+00   1.64131784708093E-16   1.51241394929289E-22
      8.65937837866286E-09   8.65937854279479E-09  -8.24452879874576E-19  -2.32897145391692E-01  -2.32897145391692E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.39318146921402E-14   0.00000000000000E+00  -9.39318146921402E-14
      3.80842914170116E-18  -2.33271050267652E-01  -2.30542910941196E-01   0.00000000000000E+00  -6.12867478622966E-18
     -9.73937267912987E-23  -8.65928460485132E-09  -8.65928461098010E-09  -2.98397626182658E-18
      1.84058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00   2.59711157246676E-16   1.51355909420998E-22
      8.66980918655159E-09   8.66980944626290E-09  -8.24330731983670E-19  -2.32958260626853E-01  -2.32958260626853E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05106790692949E-13   0.00000000000000E+00  -2.05106790692949E-13
      3.80801892811977E-18  -2.33266413383545E-01  -2.30535022757856E-01   0.00000000000000E+00   3.83386817338265E-16
     -9.73889223828775E-23  -8.66960472285892E-09  -8.66960433947220E-09  -2.98368819613610E-18
      1.86058924687078E-07
      0.00000000000000E+00  -8.68456281613211E-12   0.00000000000000E+00   3.67962560582948E-16   1.51495624975531E-22
      8.68458142942780E-09   8.68458179739051E-09  -8.24150721294016E-19  -2.33050414095433E-01  -2.33050414095433E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.40929958090824E-13   0.00000000000000E+00  -3.40929958090824E-13
      3.80733706820359E-18  -2.33233385499010E-01  -2.30497383519825E-01   0.00000000000000E+00   8.93865724307326E-16
     -9.73791461745000E-23  -8.68424176129805E-09  -8.68424086743242E-09  -2.98318634690957E-18
      1.88058924687078E-07
      0.00000000000000E+00  -8.70394205568289E-12   0.00000000000000E+00   4.82846542699426E-16   1.51656279300928E-22
      8.70396114185313E-09   8.70396162469982E-09  -8.23907715885225E-19  -2.33176822184248E-01  -2.33176822184247E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.97446767613593E-13   0.00000000000000E+00  -4.97446767613593E-13
      3.80634217466837E-18  -2.33163607388826E-01  -2.30421548936189E-01   0.00000000000000E+00   1.52191282404344E-15
     -9.73633562764760E-23  -8.70346569984493E-09  -8.70346417793221E-09  -2.98243445878314E-18
      1.90058924687078E-07
      0.00000000000000E+00  -8.72782168735685E-12   0.00000000000000E+00   5.95245559328715E-16   1.51829638700884E-22
      8.72784496614187E-09   8.72784556138758E-09  -8.23601028785229E-19  -2.33338459927852E-01  -2.33338459927852E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66922825811004E-13   0.00000000000000E+00  -6.66922825811004E-13
      3.80500832901674E-18  -2.33049072730953E-01  -2.30299542808869E-01   0.00000000000000E+00   2.25033796917521E-15
     -9.73407042268480E-23  -8.72718088889964E-09  -8.72717863856177E-09  -2.98140730023152E-18
      1.92058924687078E-07
      0.00000000000000E+00  -8.75555879799353E-12   0.00000000000000E+00   6.92237839682426E-16   1.52002749475153E-22
      8.75561490847057E-09   8.75561560070856E-09  -8.23236306539575E-19  -2.33533042324034E-01  -2.33533042324033E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37088276650764E-13   0.00000000000000E+00  -8.37088276650764E-13
      3.80333415246344E-18  -2.32883113674588E-01  -2.30124888123445E-01   0.00000000000000E+00   3.04474910173167E-15
     -9.73107029185082E-23  -8.75478155718091E-09  -8.75477851243190E-09  -2.98009784592386E-18
      1.94058924687078E-07
      0.00000000000000E+00  -8.78595940600922E-12   0.00000000000000E+00   7.57279497024310E-16   1.52157394736222E-22
      8.78598462500466E-09   8.78598538228430E-09  -8.22827533036116E-19  -2.33753926986635E-01  -2.33753926986634E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90533187897836E-13   0.00000000000000E+00  -9.90533187897836E-13
      3.80135308608764E-18  -2.32661664709603E-01  -2.29893919157635E-01   0.00000000000000E+00   3.84973011659437E-15
     -9.72734272549825E-23  -8.78499869882643E-09  -8.78499484909641E-09  -2.97852555305153E-18
      1.96058924687078E-07
      0.00000000000000E+00  -8.81681923771095E-12   0.00000000000000E+00   7.69909650583471E-16   1.52269889186928E-22
      8.81685025031958E-09   8.81685102022939E-09  -8.22398998512127E-19  -2.33989014792804E-01  -2.33989014792803E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10437249972658E-12   0.00000000000000E+00  -1.10437249972658E-12
      3.79914434108819E-18  -2.32384791012864E-01  -2.29607356720666E-01   0.00000000000000E+00   4.58655717486600E-15
     -9.72297410213424E-23  -8.81575123428675E-09  -8.81574664772967E-09  -2.97674534257606E-18
      1.98058924687078E-07
      0.00000000000000E+00  -8.84519926150807E-12   0.00000000000000E+00   7.06674863125894E-16   1.52311347630310E-22
      8.84516496248730E-09   8.84516566916231E-09  -8.21987034355638E-19  -2.34219752660464E-01  -2.34219752660463E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15032101884513E-12   0.00000000000000E+00  -1.15032101884513E-12
      3.79684369905050E-18  -2.32058430653067E-01  -2.29272089902030E-01   0.00000000000000E+00   5.15139696576752E-15
     -9.71815380259846E-23  -8.84402049954034E-09  -8.84401534814347E-09  -2.97485666469487E-18
      2.00058924687078E-07
      0.00000000000000E+00  -8.86687461948905E-12   0.00000000000000E+00   5.42199702618937E-16   1.52248549321683E-22
      8.86686367410173E-09   8.86686421630158E-09  -8.21641264434656E-19  -2.34420370915460E-01  -2.34420370915459E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09533959812220E-12   0.00000000000000E+00  -1.09533959812220E-12
      3.79465301985426E-18  -2.31696249997150E-01  -2.28903055409178E-01   0.00000000000000E+00   5.41572525590248E-15
     -9.71319787160701E-23  -8.86577429242863E-09  -8.86576887670347E-09  -2.97301175541960E-18
      2.02058924687078E-07
      0.00000000000000E+00  -8.87688569584467E-12   0.00000000000000E+00   2.51242622391163E-16   1.52045489868269E-22
      8.87687175577389E-09   8.87687200701667E-09  -8.21425073344973E-19  -2.34557516611711E-01  -2.34557516611710E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.03032218707211E-13   0.00000000000000E+00  -9.03032218707211E-13
      3.79284695541684E-18  -2.31321447990791E-01  -2.28525039540527E-01   0.00000000000000E+00   5.22886312683711E-15
     -9.70856950855219E-23  -8.87597420366098E-09  -8.87596897479795E-09  -2.97142188207187E-18
      2.04058924687078E-07
      0.00000000000000E+00  -8.86917073791924E-12   0.00000000000000E+00  -1.88848955125616E-16   1.51665671841840E-22
      8.86923812369137E-09   8.86923793484257E-09  -8.21414939704562E-19  -2.34590474128986E-01  -2.34590474128986E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.35988101578757E-13   0.00000000000000E+00  -5.35988101578757E-13
      3.79177497921368E-18  -2.30968270058599E-01  -2.28174150893421E-01   0.00000000000000E+00   4.42390324262398E-15
     -9.70489269388065E-23  -8.86870637064413E-09  -8.86870194674098E-09  -2.97036003950912E-18
      2.06058924687078E-07
      0.00000000000000E+00  -8.83739245884543E-12   0.00000000000000E+00  -7.90235252401767E-16   1.51075149578448E-22
      8.83743597704680E-09   8.83743518681170E-09  -8.21698226543321E-19  -2.34472196135879E-01  -2.34472196135879E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07328296812303E-14   0.00000000000000E+00   4.07328296812303E-14
      3.79185644487305E-18  -2.30682913141675E-01  -2.27898631749257E-01   0.00000000000000E+00   2.82264898277239E-15
     -9.70295420046254E-23  -8.83747874229026E-09  -8.83747591964137E-09  -2.97015821832973E-18
      2.08058924687078E-07
      0.00000000000000E+00  -8.77484619280711E-12   0.00000000000000E+00  -1.57683386404877E-15   1.50246335386327E-22
      8.77487053884549E-09   8.77486896201178E-09  -8.22368961799215E-19  -2.34151401046218E-01  -2.34151401046219E-01
      0.00000000000000E+00   0.00000000000000E+00   8.54792283950037E-13   0.00000000000000E+00   8.54792283950037E-13
      3.79356602944095E-18  -2.30523433329064E-01  -2.27758607249626E-01   0.00000000000000E+00   2.75648025198898E-16
     -9.70368823433026E-23  -8.77572402994366E-09  -8.77572375429573E-09  -2.97119706764173E-18
      2.10058924687078E-07
      0.00000000000000E+00  -8.67565387662298E-12   0.00000000000000E+00  -2.47302883189251E-15   1.49162622439476E-22
      8.67561820494404E-09   8.67561573191536E-09  -8.23521087415087E-19  -2.33576023441455E-01  -2.33576023441457E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92033147873428E-12   0.00000000000000E+00   1.92033147873428E-12
      3.79740669239842E-18  -2.30558227873167E-01  -2.27824336499707E-01   0.00000000000000E+00  -3.42489191080306E-15
     -9.70813721686921E-23  -8.67753263850209E-09  -8.67753606339410E-09  -2.97388560498333E-18
      2.12058924687078E-07
      0.00000000000000E+00  -8.53540696290708E-12   0.00000000000000E+00  -3.61825097392403E-15   1.47823993832225E-22
      8.53539193639655E-09   8.53538831814572E-09  -8.25238629134051E-19  -2.32698319441520E-01  -2.32698319441523E-01
      0.00000000000000E+00   0.00000000000000E+00   3.23032918668796E-12   0.00000000000000E+00   3.23032918668796E-12
      3.80386735077179E-18  -2.30862681931365E-01  -2.28172557557630E-01   0.00000000000000E+00  -8.20181752726089E-15
     -9.71738212332915E-23  -8.53861044551478E-09  -8.53861864733240E-09  -2.97862872163774E-18
      2.14058924687078E-07
      0.00000000000000E+00  -8.35272778060131E-12   0.00000000000000E+00  -4.55928005935499E-15   1.46253975392616E-22
      8.35268179234766E-09   8.35267723306775E-09  -8.27582277800146E-19  -2.31481908468983E-01  -2.31481908468988E-01
      0.00000000000000E+00   0.00000000000000E+00   4.74786467442150E-12   0.00000000000000E+00   4.74786467442150E-12
      3.81336308012064E-18  -2.31513677725821E-01  -2.28880640007426E-01   0.00000000000000E+00  -1.44582260458848E-14
     -9.73243678442066E-23  -8.35741063951603E-09  -8.35742509774218E-09  -2.98578080232049E-18
      2.16058924687078E-07
      0.00000000000000E+00  -8.12991244813585E-12   0.00000000000000E+00  -5.84542514243896E-15   1.44508415068416E-22
      8.12996382729524E-09   8.12995798187024E-09  -8.30572052990794E-19  -2.29910937286192E-01  -2.29910937286198E-01
      0.00000000000000E+00   0.00000000000000E+00   6.39697694502496E-12   0.00000000000000E+00   6.39697694502496E-12
      3.82615703401068E-18  -2.32581877036713E-01  -2.30018489453555E-01   0.00000000000000E+00  -2.14471665603851E-14
     -9.75410330655506E-23  -8.13633351164861E-09  -8.13635495881526E-09  -2.99558498101989E-18
      2.18058924687078E-07
      0.00000000000000E+00  -7.87485961291055E-12   0.00000000000000E+00  -6.37116117303998E-15   1.42686559781054E-22
      7.87481470283764E-09   7.87480833167661E-09  -8.34166120575596E-19  -2.28001332711346E-01  -2.28001332711354E-01
      0.00000000000000E+00   0.00000000000000E+00   8.05437152392780E-12   0.00000000000000E+00   8.05437152392780E-12
      3.84226577705854E-18  -2.34122004944860E-01  -2.31638482709624E-01   0.00000000000000E+00  -2.98528789166025E-14
     -9.78279079787175E-23  -7.88283285032152E-09  -7.88286270320054E-09  -3.00809965648294E-18
      2.20058924687078E-07
      0.00000000000000E+00  -7.60070307234608E-12   0.00000000000000E+00  -6.84294399731403E-15   1.40944279067446E-22
      7.60074786440572E-09   7.60074102146186E-09  -8.38236617333892E-19  -2.25813696205043E-01  -2.25813696205053E-01
      0.00000000000000E+00   0.00000000000000E+00   9.54369026808342E-12   0.00000000000000E+00   9.54369026808342E-12
      3.86135315759471E-18  -2.36161714322526E-01  -2.33764070649448E-01   0.00000000000000E+00  -3.82958247676296E-14
     -9.81830744795434E-23  -7.61024641590508E-09  -7.61028471172994E-09  -3.02311654026082E-18
      2.22058924687078E-07
      0.00000000000000E+00  -7.32764866862811E-12   0.00000000000000E+00  -6.82562358572442E-15   1.39508007149866E-22
      7.32761557112549E-09   7.32760874550205E-09  -8.42544625644347E-19  -2.23466719334964E-01  -2.23466719334975E-01
      0.00000000000000E+00   0.00000000000000E+00   1.06346122577264E-11   0.00000000000000E+00   1.06346122577264E-11
      3.88262238211016E-18  -2.38689898513769E-01  -2.36377964524474E-01   0.00000000000000E+00  -4.62139199803786E-14
     -9.85964594416178E-23  -7.33819714383969E-09  -7.33824335775977E-09  -3.04007775646582E-18
      2.24058924687078E-07
      0.00000000000000E+00  -7.08150477291194E-12   0.00000000000000E+00  -6.15568243383610E-15   1.38685538559869E-22
      7.08154392361288E-09   7.08153776793058E-09  -8.46718451135749E-19  -2.21149010098790E-01  -2.21149010098801E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10490250478241E-11   0.00000000000000E+00   1.10490250478241E-11
      3.90472043220581E-18  -2.41645361335469E-01  -2.39410824499294E-01   0.00000000000000E+00  -5.24193529219825E-14
     -9.90479263653754E-23  -7.09253437362539E-09  -7.09258679297841E-09  -3.05800198107006E-18
      2.26058924687078E-07
      0.00000000000000E+00  -6.89460073269462E-12   0.00000000000000E+00  -4.68215247494718E-15   1.38866569917253E-22
      6.89455492069066E-09   6.89455023853833E-09  -8.50242082176125E-19  -2.19125943702579E-01  -2.19125943702589E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04764018921566E-11   0.00000000000000E+00   1.04764018921566E-11
      3.92567323599012E-18  -2.44906430117836E-01  -2.42730986938866E-01   0.00000000000000E+00  -5.53887888232706E-14
     -9.95059812497941E-23  -6.90497125164156E-09  -6.90502664043048E-09  -3.07543115381400E-18
      2.28058924687078E-07
      0.00000000000000E+00  -6.80422551128241E-12   0.00000000000000E+00  -2.27440846472077E-15   1.40502294030227E-22
      6.80423390865872E-09   6.80423163425039E-09  -8.52463711934702E-19  -2.17736824502358E-01  -2.17736824502367E-01
      0.00000000000000E+00   0.00000000000000E+00   8.59994839574041E-12   0.00000000000000E+00   8.59994839574041E-12
      3.94287313278160E-18  -2.48281382918327E-01  -2.46134988162799E-01   0.00000000000000E+00  -5.33687307217564E-14
     -9.99274684558383E-23  -6.81277821391531E-09  -6.81283158264613E-09  -3.09040942084690E-18
      2.30058924687077E-07
      0.00000000000000E+00  -6.85391351411168E-12   0.00000000000000E+00   1.22023250884691E-15   1.44049961020869E-22
      6.85387265983257E-09   6.85387388006522E-09  -8.52636001799824E-19  -2.17376880405752E-01  -2.17376880405757E-01
      0.00000000000000E+00   0.00000000000000E+00   5.13424794812354E-12   0.00000000000000E+00   5.13424794812354E-12
      3.95314162867785E-18  -2.51498722387093E-01  -2.49337781358966E-01   0.00000000000000E+00  -4.46594846716314E-14
     -1.00258543161507E-22  -6.85896346852858E-09  -6.85900812801335E-09  -3.10050562687803E-18
      2.32058924687077E-07
      0.00000000000000E+00  -7.09326089927450E-12   0.00000000000000E+00   5.95933132541841E-15   1.49868508718627E-22
      7.09328650074614E-09   7.09329246007761E-09  -8.49997285080950E-19  -2.18459551395876E-01  -2.18459551395876E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25554555543651E-13   0.00000000000000E+00  -1.25554555543651E-13
      3.95289051956676E-18  -2.54195957616579E-01  -2.51961245448838E-01   0.00000000000000E+00  -2.79550384384130E-14
     -1.00436957157093E-22  -7.09313895048352E-09  -7.09316690552206E-09  -3.10289323448581E-18
      2.34058924687077E-07
      0.00000000000000E+00  -7.57976247226277E-12   0.00000000000000E+00   1.21249822446927E-14   1.58060173112058E-22
      7.57979501946390E-09   7.57980714444630E-09  -8.43892381587616E-19  -2.21358600458625E-01  -2.21358600458617E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.24503052630011E-12   0.00000000000000E+00  -7.24503052630011E-12
      3.93840045851416E-18  -2.55906569541567E-01  -2.53520822914684E-01   0.00000000000000E+00  -2.77265531616696E-15
     -1.00395276792223E-22  -7.57255934126459E-09  -7.57256211392001E-09  -3.09450807692654E-18
      2.36058924687077E-07
      0.00000000000000E+00  -8.37770954912176E-12   0.00000000000000E+00   1.98830636520920E-14   1.68281191759421E-22
      8.37770817036784E-09   8.37772805343166E-09  -8.33911624408573E-19  -2.26337560346406E-01  -2.26337560346390E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60890097134893E-11   0.00000000000000E+00  -1.60890097134893E-11
      3.90622243908718E-18  -2.56048060828523E-01  -2.53413712080833E-01   0.00000000000000E+00   3.02545973478827E-14
     -1.00064065670831E-22  -8.36166929831542E-09  -8.36163904371817E-09  -3.07231081467861E-18
      2.38058924687077E-07
      0.00000000000000E+00  -9.55368956432693E-12   0.00000000000000E+00   2.92832875130720E-14   1.79594804777489E-22
      9.55361996083745E-09   9.55364924412514E-09  -8.20003522631989E-19  -2.33484449633557E-01  -2.33484449633531E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62760615852708E-11   0.00000000000000E+00  -2.62760615852708E-11
      3.85367031591664E-18  -2.53919190778989E-01  -2.50917570225781E-01   0.00000000000000E+00   6.93359732054743E-14
     -9.93736844011126E-23  -9.52744251851297E-09  -9.52737318253986E-09  -3.03366679328465E-18
      2.40058924687077E-07
      0.00000000000000E+00  -1.11651054786330E-11   0.00000000000000E+00   4.00944689567820E-14   1.90477782133230E-22
      1.11651445212036E-08   1.11651846156728E-08  -8.02507481429431E-19  -2.42677271532811E-01  -2.42677271532773E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.71881608115719E-11   0.00000000000000E+00  -3.71881608115719E-11
      3.77929399429350E-18  -2.48718995006546E-01  -2.45213084863593E-01   0.00000000000000E+00   1.11712557707701E-13
     -9.82541378198037E-23  -1.11281081674188E-08  -1.11279964548612E-08  -2.97678651286407E-18
      2.42058924687077E-07
      0.00000000000000E+00  -1.32433681921649E-11   0.00000000000000E+00   5.16611727653112E-14   1.99033874650561E-22
      1.32433335337292E-08   1.32433851949022E-08  -7.82077988743327E-19  -2.53601808553116E-01  -2.53601808553068E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.80874363182883E-11   0.00000000000000E+00  -4.80874363182883E-11
      3.68311912165692E-18  -2.39599594545117E-01  -2.35442359079554E-01   0.00000000000000E+00   1.53757794114331E-13
     -9.66358841847347E-23  -1.31954515163779E-08  -1.31952977585839E-08  -2.90104113291359E-18
      2.44058924687077E-07
      0.00000000000000E+00  -1.57720374969625E-11   0.00000000000000E+00   6.28151254544042E-14   2.03267663189432E-22
      1.57719981913869E-08   1.57720610065126E-08  -7.59528942528641E-19  -2.65821741058409E-01  -2.65821741058350E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83493710704037E-11   0.00000000000000E+00  -5.83493710704037E-11
      3.56642037951611E-18  -2.25758404430308E-01  -2.20807708686600E-01   0.00000000000000E+00   1.90756905138249E-13
     -9.44616200381606E-23  -1.57139023923472E-08  -1.57137116354422E-08  -2.80689143698747E-18
      2.46058924687077E-07
      0.00000000000000E+00  -1.86679020611159E-11   0.00000000000000E+00   7.19049198112048E-14   2.01112453260929E-22
      1.86678562778726E-08   1.86679281827926E-08  -7.35674070362846E-19  -2.78871688287501E-01  -2.78871688287433E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76899068275576E-11   0.00000000000000E+00  -6.76899068275576E-11
      3.43104056586100E-18  -2.06567634198054E-01  -2.00707490099908E-01   0.00000000000000E+00   2.16942669867497E-13
     -9.17276723474275E-23  -1.86004552186349E-08  -1.86002382759651E-08  -2.69536649549815E-18
      2.48058924687077E-07
      0.00000000000000E+00  -2.17706009734605E-11   0.00000000000000E+00   7.70299545377523E-14   1.90322991046376E-22
      2.17705394266331E-08   2.17706164565878E-08  -7.11224181979672E-19  -2.92330866516111E-01  -2.92330866516035E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.60906770441299E-11   0.00000000000000E+00  -7.60906770441299E-11
      3.27885921177274E-18  -1.81721297005333E-01  -1.74886235617151E-01   0.00000000000000E+00   2.27882786535189E-13
     -8.85728108012216E-23  -2.16947536623301E-08  -2.16945257795437E-08  -2.56763502979307E-18
      2.50058924687077E-07
      0.00000000000000E+00  -2.48551146278381E-11   0.00000000000000E+00   7.65917574892131E-14   1.69426680620649E-22
      2.48550092891984E-08   2.48550858809561E-08  -6.86750447003287E-19  -3.05849763372919E-01  -3.05849763372835E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.32622892062482E-11   0.00000000000000E+00  -8.32622892062482E-11
      3.11233463336024E-18  -1.51355734509837E-01  -1.43551097718048E-01   0.00000000000000E+00   2.25357580189362E-13
     -8.53198518917612E-23  -2.47720489493299E-08  -2.47718235917498E-08  -2.42558418635696E-18
      2.52058924687077E-07
      0.00000000000000E+00  -2.75617790333439E-11   0.00000000000000E+00   6.72246441929602E-14   1.38762787444390E-22
      2.75616969022903E-08   2.75617641269347E-08  -6.62771900488864E-19  -3.19127041209714E-01  -3.19127041209625E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.86797420553316E-11   0.00000000000000E+00  -8.86797420553316E-11
      2.93497514924958E-18  -1.16305836283707E-01  -1.07650090455770E-01   0.00000000000000E+00   2.16958271551115E-13
     -8.13165296295157E-23  -2.74733013431508E-08  -2.74730843848793E-08  -2.27220324876071E-18
      2.54058924687077E-07
      0.00000000000000E+00  -2.88407169989587E-11   0.00000000000000E+00   3.19510506432114E-14   9.80439572947990E-23
      2.88407096244913E-08   2.88407415755421E-08  -6.39879696233996E-19  -3.31852128823294E-01  -3.31852128823202E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.16325528213165E-11   0.00000000000000E+00  -9.16325528213165E-11
      2.75171004360695E-18  -7.94416965416512E-02  -7.03838788848422E-02   0.00000000000000E+00   2.12915763546562E-13
     -7.04943886558815E-23  -2.87493219384842E-08  -2.87491090227207E-08  -2.11183034737295E-18
      2.56058924687077E-07
      0.00000000000000E+00  -2.63318861573979E-11   0.00000000000000E+00  -6.17080131484767E-14   5.59965150300148E-23
      2.63318968322906E-08   2.63318351242775E-08  -6.17834688179800E-19  -3.43645991371929E-01  -3.43645991371845E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46268312091146E-11   0.00000000000000E+00  -8.46268312091146E-11
      2.58245638118872E-18  -4.81763900222608E-02  -3.99068020337189E-02   0.00000000000000E+00   2.35805286396545E-13
     -4.68567717590471E-23  -2.62474440983547E-08  -2.62472082930683E-08  -1.96462169300892E-18
      2.58058924687077E-07
      0.00000000000000E+00  -2.06675456795981E-11   0.00000000000000E+00  -1.39644665848824E-13   2.89553204467458E-23
      2.06676736749847E-08   2.06675340303189E-08  -5.96300148899625E-19  -3.53994496804572E-01  -3.53994496804508E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.38589846656006E-11   0.00000000000000E+00  -6.38589846656006E-11
      2.45473841185752E-18  -2.85381401681188E-02  -2.20466203145975E-02   0.00000000000000E+00   2.39895294107883E-13
     -2.70296371153340E-23  -2.06039149409474E-08  -2.06036750456534E-08  -1.85843826295789E-18
      2.60058924687077E-07
      0.00000000000000E+00  -1.58595655315213E-11   0.00000000000000E+00  -1.18457138186509E-13   1.65440014257183E-23
      1.58596861524637E-08   1.58595676953255E-08  -5.77689929203874E-19  -3.62211845841705E-01  -3.62211845841663E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.21199545612970E-11   0.00000000000000E+00  -4.21199545612970E-11
      2.37049850273492E-18  -1.86252494796313E-02  -1.36417017258764E-02   0.00000000000000E+00   1.71630102779953E-13
     -1.74171344738984E-23  -1.58176193708670E-08  -1.58174477407643E-08  -1.79280857353105E-18
      2.62058924687077E-07
      0.00000000000000E+00  -1.31342566443624E-11   0.00000000000000E+00  -6.70937118921571E-14   1.12802712135916E-23
      1.31343547697558E-08   1.31342876760439E-08  -5.65181850648960E-19  -3.67522699835790E-01  -3.67522699835766E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43272228717618E-11   0.00000000000000E+00  -2.43272228717618E-11
      2.32184405699140E-18  -1.41871650925627E-02  -1.00566533248687E-02   0.00000000000000E+00   9.36473781328091E-14
     -1.37386615209885E-23  -1.31100541005502E-08  -1.31099604531721E-08  -1.75666220634244E-18
      2.64058924687077E-07
      0.00000000000000E+00  -1.17929561021836E-11   0.00000000000000E+00  -3.30409900040256E-14   9.12251588346606E-24
      1.17930057461367E-08   1.17929727051468E-08  -5.61303620958467E-19  -3.69157923116136E-01  -3.69157923116128E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.05048135458146E-12   0.00000000000000E+00  -8.05048135458146E-12
      2.30574309428224E-18  -1.24174447966486E-02  -8.70440765302865E-03   0.00000000000000E+00   4.15098331888916E-14
     -1.27256332896686E-23  -1.17849637336254E-08  -1.17849222237922E-08  -1.74443947332377E-18
      2.66058924687077E-07
      0.00000000000000E+00  -1.10839147309415E-11   0.00000000000000E+00  -1.75659330913767E-14   8.35931757119406E-24
      1.10839162465611E-08   1.10838986806280E-08  -5.68055813822967E-19  -3.66376023738211E-01  -3.66376023738220E-01
      0.00000000000000E+00   0.00000000000000E+00   8.95998684559268E-12   0.00000000000000E+00   8.95998684559268E-12
      2.32366306797342E-18  -1.20289554762351E-02  -8.53396508656841E-03   0.00000000000000E+00   9.77389623800749E-15
     -1.33811770797632E-23  -1.10928684413698E-08  -1.10928586674736E-08  -1.75560725415045E-18
      2.68058924687077E-07
      0.00000000000000E+00  -1.05583791446401E-11   0.00000000000000E+00  -1.31859247369479E-14   8.36791490175605E-24
      1.05584292519478E-08   1.05584160660231E-08  -5.87125506781375E-19  -3.58432896320619E-01  -3.58432896320646E-01
      0.00000000000000E+00   0.00000000000000E+00   2.77278422700205E-11   0.00000000000000E+00   2.77278422700205E-11
      2.37911875251346E-18  -1.26339617913354E-02  -9.29862220766342E-03   0.00000000000000E+00  -1.28731991665831E-14
     -1.57994541457159E-23  -1.05861310350939E-08  -1.05861439082931E-08  -1.79199324573209E-18
      2.70058924687077E-07
      0.00000000000000E+00  -9.92988560792896E-12   0.00000000000000E+00  -1.59127802004662E-14   8.90725741942123E-24
      9.92992832271076E-09   9.92991240993057E-09  -6.19799431199451E-19  -3.44566007080830E-01  -3.44566007080879E-01
      0.00000000000000E+00   0.00000000000000E+00   4.87989633044295E-11   0.00000000000000E+00   4.87989633044295E-11
      2.47671667912232E-18  -1.44107045532569E-02  -1.12667499896302E-02   0.00000000000000E+00  -3.38499224759626E-14
     -2.09911480537280E-23  -9.97867752331252E-09  -9.97871137323502E-09  -1.85691724792287E-18
      2.72058924687077E-07
      0.00000000000000E+00  -8.90701076964874E-12   0.00000000000000E+00  -2.58784861571585E-14   9.64895469088565E-24
      8.90701262162148E-09   8.90698674313534E-09  -6.66592974351352E-19  -3.24007590457626E-01  -3.24007590457699E-01
      0.00000000000000E+00   0.00000000000000E+00   7.31589887711716E-11   0.00000000000000E+00   7.31589887711716E-11
      2.62303465666466E-18  -1.81008420385632E-02  -1.52715067667513E-02   0.00000000000000E+00  -5.77302774558943E-14
     -3.10222030738307E-23  -8.98008800162902E-09  -8.98014573190651E-09  -1.95644168231331E-18
      2.74058924687077E-07
      0.00000000000000E+00  -7.15259259951056E-12   0.00000000000000E+00  -4.42374837731128E-14   9.34204460459776E-24
      7.15260949290771E-09   7.15256525542395E-09  -7.26947223378560E-19  -2.96054549113510E-01  -2.96054549113612E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02360239053497E-10   0.00000000000000E+00   1.02360239053497E-10
      2.82775513477166E-18  -2.50864085235725E-02  -2.28006372057418E-02   0.00000000000000E+00  -9.02463288488988E-14
     -4.78057334217738E-23  -7.25483524814854E-09  -7.25492549447744E-09  -2.10080791139310E-18
      2.76058924687077E-07
      0.00000000000000E+00  -4.66249808434010E-12   0.00000000000000E+00  -6.27358721394766E-14   4.53516633349500E-24
      4.66261660854029E-09   4.66255387266815E-09  -7.99939768271574E-19  -2.60257889641621E-01  -2.60257889641757E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35147759788354E-10   0.00000000000000E+00   1.35147759788354E-10
      3.09805065434837E-18  -3.67318785731044E-02  -3.52202981602650E-02   0.00000000000000E+00  -1.46701537546467E-13
     -6.78225628120840E-23  -4.79755493091889E-09  -4.79770163245651E-09  -2.29811088607679E-18
      2.78058924687077E-07
      0.00000000000000E+00  -2.28087220381172E-12   0.00000000000000E+00  -6.05735554671210E-14  -8.31137588627781E-24
      2.28093396983792E-09   2.28087339628245E-09  -8.85605139872973E-19  -2.16807130220747E-01  -2.16807130220911E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63459347648894E-10   0.00000000000000E+00   1.63459347648894E-10
      3.42496934964616E-18  -5.27412080446388E-02  -5.19710925544360E-02   0.00000000000000E+00  -2.50195350621740E-13
     -8.17748003576885E-23  -2.44408254858064E-09  -2.44433274393134E-09  -2.53936420977318E-18
      2.80058924687077E-07
      0.00000000000000E+00  -8.21643019058534E-13   0.00000000000000E+00  -3.78722485271999E-14  -2.52638365775846E-23
      8.21670859057537E-10   8.21632986808984E-10  -9.84428004130672E-19  -1.66868025822181E-01  -1.66868025822361E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79098426338918E-10   0.00000000000000E+00   1.79098426338918E-10
      3.78316620232399E-18  -7.12500360317522E-02  -7.09347463235951E-02   0.00000000000000E+00  -4.04670065568777E-13
     -8.86338267369893E-23  -1.00032674308225E-09  -1.00073141314790E-09  -2.79873819819332E-18
      2.82058924687077E-07
      0.00000000000000E+00  -2.01966577119351E-13   0.00000000000000E+00  -1.84325055817145E-14  -3.81026077221648E-23
      2.01962064109828E-10   2.01943631604208E-10  -1.09419491903258E-18  -1.12816859914944E-01  -1.12816859915123E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79487930565907E-10   0.00000000000000E+00   1.79487930565907E-10
      4.14214206345581E-18  -9.05982879108365E-02  -9.04781150050855E-02   0.00000000000000E+00  -5.95135592247316E-13
     -9.42569629272803E-23  -3.80836426577773E-10  -3.81431562170115E-10  -3.04794714442322E-18
      2.84058924687077E-07
      0.00000000000000E+00  -2.00221527112408E-14   0.00000000000000E+00  -7.90890135676858E-15  -4.36557331559927E-23
      1.99937640399900E-11   1.99858551385896E-11  -1.19721828464756E-18  -6.29672120500166E-02  -6.29672120501747E-02
      0.00000000000000E+00   0.00000000000000E+00   1.58076257808618E-10   0.00000000000000E+00   1.58076257808618E-10
      4.45829457907304E-18  -1.09956192162048E-01  -1.09900092426924E-01   0.00000000000000E+00  -7.27457297620371E-13
     -1.00305641971219E-22  -1.77334655649487E-10  -1.78062112947207E-10  -3.26107629442548E-18
      2.86058924687077E-07
      0.00000000000000E+00   8.26602634867741E-16   0.00000000000000E+00  -2.70663274753331E-15  -4.50261837964382E-23
     -8.08925638899649E-13  -8.11632271692209E-13  -1.26361263109802E-18  -3.16316737772586E-02  -3.16316737773700E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11358654786179E-10   0.00000000000000E+00   1.11358654786179E-10
      4.68101188864540E-18  -1.29056826499406E-01  -1.29021997996176E-01   0.00000000000000E+00  -6.12474326681803E-13
     -1.04617860086222E-22  -1.09934548187700E-10  -1.10547022514486E-10  -3.41739925754738E-18
      2.88058924687077E-07
      0.00000000000000E+00  -1.12969026765258E-14   0.00000000000000E+00  -4.60590379589289E-16  -4.48865207605216E-23
      1.12805943261746E-11   1.12801337357502E-11  -1.29593967025725E-18  -1.72537929485024E-02  -1.72537929485731E-02
      0.00000000000000E+00   0.00000000000000E+00   7.06630084390330E-11   0.00000000000000E+00   7.06630084390330E-11
      4.82233790552346E-18  -1.47827667068673E-01  -1.47801850591932E-01   0.00000000000000E+00  -4.25188777503471E-13
     -1.07275197084836E-22  -8.15179533971722E-11  -8.19431421747830E-11  -3.52639823526621E-18
      2.90058924687077E-07
      0.00000000000000E+00  -2.36040974623344E-14   0.00000000000000E+00   2.37249124300717E-16  -4.37085841800446E-23
      2.36049038855483E-11   2.36051411346289E-11  -1.30980413894822E-18  -1.14285657127985E-02  -1.14285657128457E-02
      0.00000000000000E+00   0.00000000000000E+00   4.71277428151716E-11   0.00000000000000E+00   4.71277428151716E-11
      4.91659339115381E-18  -1.66240107835100E-01  -1.66217823365795E-01   0.00000000000000E+00  -3.25172791038651E-13
     -1.09182080712338E-22  -7.04077111586524E-11  -7.07328839498003E-11  -3.60678925220559E-18
      2.92058924687077E-07
      0.00000000000000E+00  -3.27885711830871E-14   0.00000000000000E+00   3.59818501621685E-16  -4.12775864714042E-23
      3.28024373813580E-11   3.28027971998184E-11  -1.31521742815024E-18  -9.01880613717639E-03  -9.01880613721103E-03
      0.00000000000000E+00   0.00000000000000E+00   3.46453818856978E-11   0.00000000000000E+00   3.46453818856978E-11
      4.98588415492520E-18  -1.84285458718612E-01  -1.84264209236434E-01   0.00000000000000E+00  -2.92780286040535E-13
     -1.10832906037984E-22  -6.71553987993652E-11  -6.74481790855166E-11  -3.67066672677496E-18
      2.94058924687077E-07
      0.00000000000000E+00  -3.97687712108591E-14   0.00000000000000E+00   3.23080851976757E-16  -3.72161391254366E-23
      3.97787242976124E-11   3.97790473784272E-11  -1.31688948446189E-18  -7.87214791829232E-03  -7.87214791832001E-03
      0.00000000000000E+00   0.00000000000000E+00   2.76921810513593E-11   0.00000000000000E+00   2.76921810513593E-11
      5.04126851702792E-18  -2.01965060970442E-01  -2.01943804346546E-01   0.00000000000000E+00  -2.88075691500719E-13
     -1.12409021230309E-22  -6.71831527381735E-11  -6.74712284297867E-11  -3.72437903256603E-18
      2.96058924687077E-07
      0.00000000000000E+00  -4.53713001805182E-14   0.00000000000000E+00   2.64121847106884E-16  -3.11407219815032E-23
      4.54175172910378E-11   4.54177814128538E-11  -1.31687184454281E-18  -7.21168822090766E-03  -7.21168822093112E-03
      0.00000000000000E+00   0.00000000000000E+00   2.34534380538464E-11   0.00000000000000E+00   2.34534380538464E-11
      5.08817539313561E-18  -2.19284543761359E-01  -2.19262846191658E-01   0.00000000000000E+00  -2.91207807246396E-13
     -1.13961624258927E-22  -6.85800116593399E-11  -6.88712194667002E-11  -3.77130354859281E-18
      2.98058924687077E-07
      0.00000000000000E+00  -5.02390712525171E-14   0.00000000000000E+00   2.17148931186212E-16  -2.27606373723546E-23
      5.02618346105762E-11   5.02620517594846E-11  -1.31607026859942E-18  -6.76848654925589E-03  -6.76848654927654E-03
      0.00000000000000E+00   0.00000000000000E+00   2.06551518971504E-11   0.00000000000000E+00   2.06551518971504E-11
      5.12948569692992E-18  -2.36251039874110E-01  -2.36228697847806E-01   0.00000000000000E+00  -2.95307282154005E-13
     -1.15500344634107E-22  -7.06218963743654E-11  -7.09172036566349E-11  -3.81341542833049E-18
      3.00058924687077E-07
      0.00000000000000E+00  -5.46476186384784E-14   0.00000000000000E+00   1.85352380200448E-16  -1.19992146384969E-23
      5.46274381913754E-11   5.46276235437436E-11  -1.31490505098935E-18  -6.44353512963542E-03  -6.44353512965412E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87006283237367E-11   0.00000000000000E+00   1.87006283237367E-11
      5.16688695357739E-18  -2.52872031616573E-01  -2.52848930132305E-01   0.00000000000000E+00  -2.98670999574836E-13
     -1.17024673913374E-22  -7.30295808677884E-11  -7.33282518674802E-11  -3.85198190258803E-18
      3.02058924687077E-07
      0.00000000000000E+00  -5.86887870756096E-14   0.00000000000000E+00   1.64840802463196E-16   8.86515336388685E-25
      5.86978517345371E-11   5.86980165753404E-11  -1.31358036372572E-18  -6.19395037581926E-03  -6.19395037583654E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72779272019486E-11   0.00000000000000E+00   1.72779272019486E-11
      5.20144280798128E-18  -2.69154981177943E-01  -2.69131045693670E-01   0.00000000000000E+00  -3.01229821295570E-13
     -1.18533266430398E-22  -7.56747139558751E-11  -7.59759437772892E-11  -3.88786244425556E-18
      3.04058924687077E-07
      0.00000000000000E+00  -6.25462660383257E-14   0.00000000000000E+00   1.51745782628962E-16   1.48654233846611E-23
      6.25827261505019E-11   6.25828778962994E-11  -1.31219733869406E-18  -5.99709616645504E-03  -5.99709616647124E-03
      0.00000000000000E+00   0.00000000000000E+00   1.62039771998907E-11   0.00000000000000E+00   1.62039771998907E-11
      5.23385076238107E-18  -2.85107093587597E-01  -2.85082272693056E-01   0.00000000000000E+00  -3.03310410169466E-13
     -1.20025913514155E-22  -7.84835446859005E-11  -7.87868550961900E-11  -3.92165342368700E-18
      3.06058924687077E-07
      0.00000000000000E+00  -6.63119002638343E-14   0.00000000000000E+00   1.43363774002285E-16   2.88934298448723E-23
      6.63509657109257E-11   6.63511090747286E-11  -1.31080532059187E-18  -5.83920168470210E-03  -5.83920168471746E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53617189681497E-11   0.00000000000000E+00   1.53617189681497E-11
      5.26457420031737E-18  -3.00734335329282E-01  -3.00708592785534E-01   0.00000000000000E+00  -3.05245047353607E-13
     -1.21503574036487E-22  -8.14075829954033E-11  -8.17128280428784E-11  -3.95376887972550E-18
      3.08058924687077E-07
      0.00000000000000E+00  -7.00775344893429E-14   0.00000000000000E+00   1.37960726392810E-16   4.23142242565079E-23
      7.00472957026596E-11   7.00474336634283E-11  -1.30942705997486E-18  -5.71135378283707E-03  -5.71135378285174E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46715171804575E-11   0.00000000000000E+00   1.46715171804575E-11
      5.29391723467828E-18  -3.16039243225332E-01  -3.16012553791934E-01   0.00000000000000E+00  -3.07245883422549E-13
     -1.22967970718317E-22  -8.44117049603407E-11  -8.47189508438862E-11  -3.98449017470342E-18
      3.10058924687077E-07
      0.00000000000000E+00  -7.36594792404365E-14   0.00000000000000E+00   1.34410425366019E-16   5.46088726972395E-23
      7.37002259016496E-11   7.37003603121296E-11  -1.30807202048648E-18  -5.60759358083105E-03  -5.60759358084512E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40784068653886E-11   0.00000000000000E+00   1.40784068653886E-11
      5.32207404840906E-18  -3.31020195203759E-01  -3.30992541975056E-01   0.00000000000000E+00  -3.09425335434082E-13
     -1.24420953756100E-22  -8.74693418419595E-11  -8.77787671775180E-11  -4.01400202792258E-18
      3.12058924687077E-07
      0.00000000000000E+00  -7.73332687287375E-14   0.00000000000000E+00   1.31890150634146E-16   6.54629873376445E-23
      7.73294677954356E-11   7.73295996856517E-11  -1.30674264544301E-18  -5.52386530567287E-03  -5.52386530568642E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35527092038524E-11   0.00000000000000E+00   1.35527092038524E-11
      5.34917946681676E-18  -3.45682153401430E-01  -3.45653522612172E-01   0.00000000000000E+00  -3.12106153466967E-13
     -1.25865613111014E-22  -9.05702027359101E-11  -9.08823088895029E-11  -4.04243682137376E-18
      3.14058924687077E-07
      0.00000000000000E+00  -8.09152134798311E-14   0.00000000000000E+00   1.30722972591025E-16   7.47763682828265E-23
      8.09534594250655E-11   8.09535901481129E-11  -1.30543655615710E-18  -5.45752225107575E-03  -5.45752225108883E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30879615867526E-11   0.00000000000000E+00   1.30879615867526E-11
      5.37535538999027E-18  -3.60052007397211E-01  -3.60022381509804E-01   0.00000000000000E+00  -3.15996863619329E-13
     -1.27307977509704E-22  -9.37255548711200E-11  -9.40415517348666E-11  -4.06991883383317E-18
      3.16058924687077E-07
      0.00000000000000E+00  -8.45890029681321E-14   0.00000000000000E+00   1.30400901040565E-16   8.26220914916718E-23
      8.45936210774746E-11   8.45937514784582E-11  -1.30414701614141E-18  -5.40711524429816E-03  -5.40711524431086E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26939311047796E-11   0.00000000000000E+00   1.26939311047796E-11
      5.40074325219983E-18  -3.74190094834062E-01  -3.74159446486315E-01   0.00000000000000E+00  -3.22166297443559E-13
     -1.28758361155421E-22  -9.69655162856646E-11  -9.72876825832369E-11  -4.09659623605842E-18
      3.18058924687077E-07
      0.00000000000000E+00  -8.82627924564332E-14   0.00000000000000E+00   1.30461409848493E-16   8.91624117193471E-23
      8.82560120410837E-11   8.82561425025827E-11  -1.30287007522483E-18  -5.37225825673445E-03  -5.37225825674676E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23121429795769E-11   0.00000000000000E+00   1.23121429795769E-11
      5.42536753815898E-18  -3.88094353923199E-01  -3.88062672268320E-01   0.00000000000000E+00  -3.28858452889063E-13
     -1.30218520197850E-22  -1.00239427029141E-10  -1.00568285482160E-10  -4.12249746293415E-18
      3.20058924687077E-07
      0.00000000000000E+00  -9.19365819447343E-14   0.00000000000000E+00   1.30680441606453E-16   9.45986155221384E-23
      9.19401327344201E-11   9.19402634149564E-11  -1.30160223295155E-18  -5.35369676133005E-03  -5.35369676134197E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19156214885466E-11   0.00000000000000E+00   1.19156214885466E-11
      5.44919878113608E-18  -4.01739907744131E-01  -4.01707190592078E-01   0.00000000000000E+00  -3.35401231315013E-13
     -1.31686988817105E-22  -1.03520483672055E-10  -1.03855884903502E-10  -4.14759654818452E-18
      3.22058924687077E-07
      0.00000000000000E+00  -9.56103714330353E-14   0.00000000000000E+00   1.31328058655705E-16   9.91393901720906E-23
      9.56519451782992E-11   9.56520765064570E-11  -1.30033691196745E-18  -5.35361652049227E-03  -5.35361652050378E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15085291145643E-11   0.00000000000000E+00   1.15085291145643E-11
      5.47221583936520E-18  -4.15117312134218E-01  -4.15083554105537E-01   0.00000000000000E+00  -3.42214539776531E-13
     -1.33163968620647E-22  -1.06818391081112E-10  -1.07160605621022E-10  -4.17187892739775E-18
      3.24058924687077E-07
      0.00000000000000E+00  -9.93760056585439E-14   0.00000000000000E+00   1.27153540030203E-16   1.02979101748677E-22
      9.94062330831763E-11   9.94063602368193E-11  -1.29906251864043E-18  -5.37646348979031E-03  -5.37646348980140E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10919115007663E-11   0.00000000000000E+00   1.10919115007663E-11
      5.49439966236674E-18  -4.28226616607970E-01  -4.28191807336947E-01   0.00000000000000E+00  -3.49436492177747E-13
     -1.34649980069031E-22  -1.10148835245273E-10  -1.10498271737585E-10  -4.19533714372630E-18
      3.26058924687077E-07
      0.00000000000000E+00  -1.03233484621260E-13   0.00000000000000E+00   1.35885987670610E-16   1.06292111965195E-22
      1.03233929155106E-10   1.03234065041200E-10  -1.29775824005589E-18  -5.43087864499217E-03  -5.43087864500283E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06601840010907E-11   0.00000000000000E+00   1.06601840010907E-11
      5.51572003036892E-18  -4.41071354715623E-01  -4.41035475852074E-01   0.00000000000000E+00  -3.56960782741265E-13
     -1.36144680533875E-22  -1.13537288259414E-10  -1.13894249042292E-10  -4.21796179031302E-18
      3.28058924687077E-07
      0.00000000000000E+00  -1.07182808321184E-13   0.00000000000000E+00   1.42365007741490E-16   1.09243858056753E-22
      1.07200996190871E-10   1.07201138555988E-10  -1.29638394591264E-18  -5.53423958342384E-03  -5.53423958343404E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01982441459340E-11   0.00000000000000E+00   1.01982441459340E-11
      5.53611651866079E-18  -4.53656091971839E-01  -4.53619109144403E-01   0.00000000000000E+00  -3.64333087370906E-13
     -1.37645566758304E-22  -1.17035049614412E-10  -1.17399382701921E-10  -4.23973257274814E-18
      3.30058924687077E-07
      0.00000000000000E+00  -1.11499510969937E-13   0.00000000000000E+00   1.55632970130334E-16   1.12024622913204E-22
      1.11457667252023E-10   1.11457822885105E-10  -1.29485454914020E-18  -5.72421788011080E-03  -5.72421788012047E-03
      0.00000000000000E+00   0.00000000000000E+00   9.66929343209212E-12   0.00000000000000E+00   9.66929343209212E-12
      5.55545510552497E-18  -4.65985493989044E-01  -4.65947337093330E-01   0.00000000000000E+00  -3.70631960234398E-13
     -1.39146266225090E-22  -1.20756484356824E-10  -1.21127116317198E-10  -4.26060055638476E-18
      3.32058924687077E-07
      0.00000000000000E+00  -1.16367282041936E-13   0.00000000000000E+00   1.86673031532269E-16   1.14946889725033E-22
      1.16384383633141E-10   1.16384570306288E-10  -1.29296680064600E-18  -6.09194901957342E-03  -6.09194901958239E-03
      0.00000000000000E+00   0.00000000000000E+00   8.97500413402737E-12   0.00000000000000E+00   8.97500413402737E-12
      5.57340511379303E-18  -4.78063738483737E-01  -4.78024248545833E-01   0.00000000000000E+00  -3.73535609256203E-13
     -1.40631345968572E-22  -1.24986038830919E-10  -1.25359574440315E-10  -4.28043831314703E-18
      3.34058924687077E-07
      0.00000000000000E+00  -1.23163792595293E-13   0.00000000000000E+00   2.71815827291437E-16   1.18767212636170E-22
      1.23097908450987E-10   1.23098180266933E-10  -1.29015816037458E-18  -6.89159267058061E-03  -6.89159267058843E-03
      0.00000000000000E+00   0.00000000000000E+00   7.81421692457418E-12   0.00000000000000E+00   7.81421692457418E-12
      5.58903354764218E-18  -4.89893398096650E-01  -4.89852159215659E-01   0.00000000000000E+00  -3.66148053242593E-13
     -1.42059575308751E-22  -1.30546249138123E-10  -1.30912397191508E-10  -4.29887538726760E-18
      3.36058924687077E-07
      0.00000000000000E+00  -1.35470987381102E-13   0.00000000000000E+00   5.17966521680631E-16   1.25895480308447E-22
      1.35467966614431E-10   1.35468484581079E-10  -1.28462613784386E-18  -8.93894070645695E-03  -8.93894070646210E-03
      0.00000000000000E+00   0.00000000000000E+00   5.14528466515510E-12   0.00000000000000E+00   5.14528466515510E-12
      5.59932411697248E-18  -5.01471526547711E-01  -5.01427231936439E-01   0.00000000000000E+00  -3.24730486743705E-13
     -1.43302792744759E-22  -1.40289038759346E-10  -1.40613769246233E-10  -4.31469797912862E-18
      3.38058924687077E-07
      0.00000000000000E+00  -1.67432955929321E-13   0.00000000000000E+00   1.32825039278133E-15   1.43977344206889E-22
      1.67471999764918E-10   1.67473328015454E-10  -1.27076479008099E-18  -1.47359056209132E-02  -1.47359056209109E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.23304195383974E-12   0.00000000000000E+00  -2.23304195383974E-12
      5.59485803306480E-18  -5.12774317819754E-01  -5.12722266031547E-01   0.00000000000000E+00  -1.78293523520693E-13
     -1.43974569458047E-22  -1.65061992537949E-10  -1.65240286061614E-10  -4.32409324298381E-18
      3.40058924687077E-07
      0.00000000000000E+00  -2.51195356262586E-13   0.00000000000000E+00   3.17604777682087E-15   1.82870252425096E-22
      2.51243602979574E-10   2.51246779027534E-10  -1.24020215148966E-18  -2.77233005608185E-02  -2.77233005608018E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.67611210106324E-11   0.00000000000000E+00  -1.67611210106324E-11
      5.56133579104354E-18  -5.23720793860246E-01  -5.23646929643331E-01   0.00000000000000E+00   1.08148110255220E-13
     -1.43561547180574E-22  -2.34593806127014E-10  -2.34485658016902E-10  -4.32113363955388E-18
      3.42058924687077E-07
      0.00000000000000E+00  -4.15689280601266E-13   0.00000000000000E+00   5.45206808247090E-15   2.28877426746310E-22
      4.15649084932171E-10   4.15654537000483E-10  -1.19579591793514E-18  -4.59649035120805E-02  -4.59649035120509E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.95927692421240E-11   0.00000000000000E+00  -2.95927692421240E-11
      5.50215025255929E-18  -5.34158393172870E-01  -5.34036781261114E-01   0.00000000000000E+00   2.98610753116346E-13
     -1.42411425495283E-22  -3.86360378511333E-10  -3.86061767758359E-10  -4.30635433462415E-18
      3.44058924687077E-07
      0.00000000000000E+00  -6.90672423800601E-13   0.00000000000000E+00   8.13442392428498E-15   2.63586678568489E-22
      6.90688911691843E-10   6.90697046116031E-10  -1.14621597617743E-18  -6.57511380348341E-02  -6.57511380347974E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.66735263467911E-11   0.00000000000000E+00  -3.66735263467911E-11
      5.42880319986571E-18  -5.43871499370378E-01  -5.43665476469395E-01   0.00000000000000E+00   3.29034303721049E-13
     -1.41117564587790E-22  -6.54352554072820E-10  -6.54023519769240E-10  -4.28258722368828E-18
      3.46058924687077E-07
      0.00000000000000E+00  -1.12271006762481E-12   0.00000000000000E+00   1.18645140808734E-14   2.87085410984849E-22
      1.12272434649723E-09   1.12273621101159E-09  -1.09667277636362E-18  -8.56012581134737E-02  -8.56012581134325E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.12669182248504E-11   0.00000000000000E+00  -4.12669182248504E-11
      5.34626936341601E-18  -5.52565131516944E-01  -5.52224457507427E-01   0.00000000000000E+00   3.05561988902799E-13
     -1.39887913344568E-22  -1.08177485477551E-09  -1.08146929278674E-09  -4.24959658705238E-18
      3.48058924687077E-07
      0.00000000000000E+00  -1.77196051494481E-12   0.00000000000000E+00   1.71015118270032E-14   3.05189991417731E-22
      1.77194076549700E-09   1.77195786700913E-09  -1.04952777250099E-18  -1.05190088264585E-01  -1.05190088264540E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57002728570027E-11   0.00000000000000E+00  -4.57002728570027E-11
      5.25486881770200E-18  -5.59837850596364E-01  -5.59294058647009E-01   0.00000000000000E+00   2.78090349797196E-13
     -1.38739842803476E-22  -1.72653568450179E-09  -1.72625759415213E-09  -4.20534104520102E-18
      3.50058924687077E-07
      0.00000000000000E+00  -2.70216401338264E-12   0.00000000000000E+00   2.39265311584943E-14   3.20770960641993E-22
      2.70209901559001E-09   2.70212294212149E-09  -1.00576350940110E-18  -1.24442426424939E-01  -1.24442426424888E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08099671381930E-11   0.00000000000000E+00  -5.08099671381930E-11
      5.15324888342562E-18  -5.65173981405568E-01  -5.64338781738513E-01   0.00000000000000E+00   2.57475661152961E-13
     -1.37646125667697E-22  -2.65157045064431E-09  -2.65131297498329E-09  -4.14748537402452E-18
      3.52058924687077E-07
      0.00000000000000E+00  -3.96851925000002E-12   0.00000000000000E+00   3.21242962513710E-14   3.34226876712706E-22
      3.96846214874658E-09   3.96849427304317E-09  -9.65545563719628E-19  -1.43327364441178E-01  -1.43327364441122E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.67247381900048E-11   0.00000000000000E+00  -5.67247381900048E-11
      5.03979940704561E-18  -5.67960875143728E-01  -5.66728608678390E-01   0.00000000000000E+00   2.49200430559691E-13
     -1.36555291373363E-22  -3.91201873528359E-09  -3.91176953485317E-09  -4.07425384332598E-18
      3.54058924687077E-07
      0.00000000000000E+00  -5.61088684074502E-12   0.00000000000000E+00   4.13007020810915E-14   3.45077198061697E-22
      5.61083609355567E-09   5.61087739425810E-09  -9.28532656811465E-19  -1.61835622190697E-01  -1.61835622190634E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31691881886447E-11   0.00000000000000E+00  -6.31691881886447E-11
      4.91346103066832E-18  -5.67519844734953E-01  -5.65772224294305E-01   0.00000000000000E+00   2.61041943908614E-13
     -1.35380828264105E-22  -5.54796924801322E-09  -5.54770820606944E-09  -3.98492837385685E-18
      3.56058924687077E-07
      0.00000000000000E+00  -7.65489146729852E-12   0.00000000000000E+00   5.11510428487415E-14   3.52694613865252E-22
      7.65487436887818E-09   7.65492551992138E-09  -8.94161120872268E-19  -1.79968368401493E-01  -1.79968368401424E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96607059892815E-11   0.00000000000000E+00  -6.96607059892815E-11
      4.77413961868975E-18  -5.63134247559403E-01  -5.60744749463587E-01   0.00000000000000E+00   3.01426666064008E-13
     -1.33995029709435E-22  -7.58556624059802E-09  -7.58526481393209E-09  -3.87997849781749E-18
      3.58058924687077E-07
      0.00000000000000E+00  -1.01194531455253E-11   0.00000000000000E+00   6.14625034373754E-14   3.56497996561264E-22
      1.01194012977069E-08   1.01194627602106E-08  -8.61842620580677E-19  -1.97731248717197E-01  -1.97731248717122E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.57475779322015E-11   0.00000000000000E+00  -7.57475779322015E-11
      4.62264446282535E-18  -5.54063138673871E-01  -5.50899161610488E-01   0.00000000000000E+00   3.75907829549522E-13
     -1.32236051278914E-22  -1.00440910901079E-08  -1.00437151822784E-08  -3.76080184224468E-18
      3.60058924687077E-07
      0.00000000000000E+00  -1.30226652886552E-11   0.00000000000000E+00   7.22526658084374E-14   3.55909464103382E-22
      1.30225605591133E-08   1.30226328117794E-08  -8.31063414649377E-19  -2.15131581715359E-01  -2.15131581715277E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.11758729539170E-11   0.00000000000000E+00  -8.11758729539170E-11
      4.46029271691752E-18  -5.39542826689608E-01  -5.35465965696566E-01   0.00000000000000E+00   4.82638636965383E-13
     -1.29933538843176E-22  -1.29419395774624E-08  -1.29414569388255E-08  -3.62922930226814E-18
      3.62058924687077E-07
      0.00000000000000E+00  -1.63806925704368E-11   0.00000000000000E+00   8.34571378919173E-14   3.50209653150511E-22
      1.63806036600340E-08   1.63806871171723E-08  -8.01416975130174E-19  -2.32177020724867E-01  -2.32177020724781E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.59415189364455E-11   0.00000000000000E+00  -8.59415189364455E-11
      4.28840967904463E-18  -5.18790457414969E-01  -5.13657176085851E-01   0.00000000000000E+00   6.09526808508693E-13
     -1.26950992669908E-22  -1.62953551250442E-08  -1.62947455982358E-08  -3.48699270391445E-18
      3.64058924687077E-07
      0.00000000000000E+00  -2.01977598487816E-11   0.00000000000000E+00   9.47844092091526E-14   3.38386673028393E-22
      2.01976519564098E-08   2.01977467408193E-08  -7.72603522791261E-19  -2.48874926881909E-01  -2.48874926881819E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.02272143900128E-11   0.00000000000000E+00  -9.02272143900128E-11
      4.10795525026460E-18  -4.91026676881266E-01  -4.84692186206760E-01   0.00000000000000E+00   7.36181720150085E-13
     -1.23226977768096E-22  -2.01082557081493E-08  -2.01075195264293E-08  -3.33535172747334E-18
      3.66058924687077E-07
      0.00000000000000E+00  -2.44508140946506E-11   0.00000000000000E+00   1.05566777761229E-13   3.19300666476874E-22
      2.44507283350679E-08   2.44508339018460E-08  -7.44411593299955E-19  -2.65232272124860E-01  -2.65232272124765E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.42296916432193E-11   0.00000000000000E+00  -9.42296916432193E-11
      3.91949586697816E-18  -4.55526112554709E-01  -4.47852912746380E-01   0.00000000000000E+00   8.42845639957808E-13
     -1.18776845793995E-22  -2.43574470558426E-08  -2.43566042102027E-08  -3.17508427367820E-18
      3.68058924687077E-07
      0.00000000000000E+00  -2.90824523472889E-11   0.00000000000000E+00   1.14951339205805E-13   2.93013227558265E-22
      2.90823053291858E-08   2.90824202805253E-08  -7.16681291682063E-19  -2.81256093699640E-01  -2.81256093699543E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79006872702776E-11   0.00000000000000E+00  -9.79006872702776E-11
      3.72369449243761E-18  -4.11682558164445E-01  -4.02551247075645E-01   0.00000000000000E+00   9.22669438908012E-13
     -1.13611458714547E-22  -2.89854422626938E-08  -2.89845195932550E-08  -3.00701320075555E-18
      3.70058924687077E-07
      0.00000000000000E+00  -3.39943088931475E-11   0.00000000000000E+00   1.21930580937780E-13   2.63324002355972E-22
      3.39941791793740E-08   3.39943011099552E-08  -6.89277617121297E-19  -2.96953830383099E-01  -2.96953830382998E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01005701318099E-10   0.00000000000000E+00  -1.01005701318099E-10
      3.52168308980141E-18  -3.59096108748168E-01  -3.48418138640532E-01   0.00000000000000E+00   9.74818245354259E-13
     -1.07625928311241E-22  -3.38942702268823E-08  -3.38932954086371E-08  -2.83240547268011E-18
      3.72058924687077E-07
      0.00000000000000E+00  -3.89408827496704E-11   0.00000000000000E+00   1.22849815548630E-13   2.36804496703237E-22
      3.89408033959234E-08   3.89409262457392E-08  -6.62165413949382E-19  -3.12331516138557E-01  -3.12331516138453E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04217400746026E-10   0.00000000000000E+00  -1.04217400746026E-10
      3.31324828830936E-18  -2.97887791188415E-01  -2.85652185474329E-01   0.00000000000000E+00   9.63917762963520E-13
     -1.00535424784661E-22  -3.88376727627561E-08  -3.88367088449932E-08  -2.65108287435998E-18
      3.74058924687077E-07
      0.00000000000000E+00  -4.32213067272272E-11   0.00000000000000E+00   1.06403815052351E-13   2.11166545536895E-22
      4.32211953903772E-08   4.32213017941925E-08  -6.35573854924212E-19  -3.27389634826679E-01  -3.27389634826569E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10332366063135E-10   0.00000000000000E+00  -1.10332366063135E-10
      3.09258355618309E-18  -2.29549537958036E-01  -2.15967081955839E-01   0.00000000000000E+00   8.29239647931316E-13
     -9.22005219017882E-23  -4.31117986677772E-08  -4.31109694281293E-08  -2.45700970125887E-18
      3.76058924687077E-07
      0.00000000000000E+00  -4.58454945587207E-11   0.00000000000000E+00   6.53924698345642E-14   1.65249595088338E-22
      4.58454579349046E-08   4.58455233273746E-08  -6.09865709837683E-19  -3.42125182972839E-01  -3.42125182972718E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21143944993605E-10   0.00000000000000E+00  -1.21143944993605E-10
      2.85029566619588E-18  -1.57434720187559E-01  -1.43028703602770E-01   0.00000000000000E+00   6.09607541496717E-13
     -7.72213393655152E-23  -4.57249889899224E-08  -4.57243793823810E-08  -2.24042995635819E-18
      3.78058924687077E-07
      0.00000000000000E+00  -4.51073384057838E-11   0.00000000000000E+00  -1.81724771362438E-14   9.82523999881613E-23
      4.51073588689769E-08   4.51073406964999E-08  -5.84801822087651E-19  -3.56550156232122E-01  -3.56550156231993E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29030092741286E-10   0.00000000000000E+00  -1.29030092741286E-10
      2.59223548071331E-18  -8.81521683958515E-02  -7.39810870167372E-02   0.00000000000000E+00   4.58747249381423E-13
     -7.12038521593409E-23  -4.49787693510079E-08  -4.49783106037586E-08  -2.00743365862565E-18
      3.80058924687077E-07
      0.00000000000000E+00  -3.43891494184026E-11   0.00000000000000E+00  -2.65033486569534E-13   3.99139229858904E-23
      3.43894364129063E-08   3.43891713794198E-08  -5.56604414592748E-19  -3.70720999063647E-01  -3.70720999063536E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11163424621920E-10   0.00000000000000E+00  -1.11163424621920E-10
      2.36990863146946E-18  -4.10895027696988E-02  -3.02896590260012E-02   0.00000000000000E+00   4.87495056332433E-13
     -3.58764140017613E-23  -3.42784954498542E-08  -3.42780079547979E-08  -1.81330421687672E-18
      3.82058924687077E-07
      0.00000000000000E+00  -2.15511838962717E-11   0.00000000000000E+00  -3.16976624065424E-13   1.61220992093651E-23
      2.15514685041353E-08   2.15511515275112E-08  -5.23701769361087E-19  -3.84674526902560E-01  -3.84674526902483E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.70018847651400E-11   0.00000000000000E+00  -7.70018847651400E-11
      2.21590486193918E-18  -1.99343370326314E-02  -1.31685425798227E-02   0.00000000000000E+00   4.11895548528117E-13
     -1.57153031975550E-23  -2.14745615382946E-08  -2.14741496427461E-08  -1.69220309257810E-18
      3.84058924687077E-07
      0.00000000000000E+00  -1.49822646017150E-11   0.00000000000000E+00  -1.61810713963397E-13   8.36202586624942E-24
      1.49824049041216E-08   1.49822430934076E-08  -4.89764220600024E-19  -3.98382203952564E-01  -3.98382203952504E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.95683179849069E-11   0.00000000000000E+00  -5.95683179849069E-11
      2.09676822596937E-18  -1.19710360778701E-02  -7.26938912694191E-03   0.00000000000000E+00   2.13332317292267E-13
     -8.85550650337664E-24  -1.49228881077400E-08  -1.49226747754227E-08  -1.60700400536934E-18
      3.86058924687077E-07
      0.00000000000000E+00  -1.24881289181074E-11   0.00000000000000E+00  -6.12166063261549E-14   6.03191500630817E-24
      1.24882021067340E-08   1.24881408901276E-08  -4.56229860872293E-19  -4.11825738271956E-01  -4.11825738271902E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39241188966838E-11   0.00000000000000E+00  -5.39241188966838E-11
      1.98891998817600E-18  -9.00805285357739E-03  -5.09043435466603E-03   0.00000000000000E+00   9.81297184392120E-14
     -5.56766226584220E-24  -1.24343149009494E-08  -1.24342167712309E-08  -1.53269012730371E-18
      3.88058924687077E-07
      0.00000000000000E+00  -1.16342483962890E-11   0.00000000000000E+00  -2.07763345140483E-14   4.43311004620219E-24
      1.16341878294080E-08   1.16341670530735E-08  -4.23424948091322E-19  -4.25001589817518E-01  -4.25001589817465E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27171672527835E-11   0.00000000000000E+00  -5.27171672527835E-11
      1.88348565367044E-18  -7.75619392451428E-03  -4.10725211080170E-03   0.00000000000000E+00   5.14958584780698E-14
     -5.06607189108065E-24  -1.15815013816792E-08  -1.15814498858207E-08  -1.46006070557911E-18
      3.90058924687077E-07
      0.00000000000000E+00  -1.13383246530064E-11   0.00000000000000E+00  -7.03340883537834E-15   3.75561311362259E-24
      1.13383474475568E-08   1.13383404141480E-08  -3.91462920390020E-19  -4.37912191848950E-01  -4.37912191848897E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29234690358769E-11   0.00000000000000E+00  -5.29234690358769E-11
      1.77763871559868E-18  -7.09785741998908E-03  -3.54218392843929E-03   0.00000000000000E+00   3.41303542962417E-14
     -4.33269228220991E-24  -1.12854510754664E-08  -1.12854169451121E-08  -1.38617579520866E-18
      3.92058924687077E-07
      0.00000000000000E+00  -1.12214063025412E-11   0.00000000000000E+00  -2.64137615009995E-15   3.40130316997886E-24
      1.12214776493068E-08   1.12214750079306E-08  -3.60415901300379E-19  -4.50561893444385E-01  -4.50561893444332E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.35197473748466E-11   0.00000000000000E+00  -5.35197473748466E-11
      1.67059922084899E-18  -6.67521977576383E-03  -3.15655283464512E-03   0.00000000000000E+00   2.70564167122124E-14
     -3.61453239704062E-24  -1.11679823169725E-08  -1.11679552605558E-08  -1.31018331954861E-18
      3.94058924687077E-07
      0.00000000000000E+00  -1.11640951865237E-11   0.00000000000000E+00  -1.19433625677882E-15   2.96892486719057E-24
      1.11640632080936E-08   1.11640620137573E-08  -3.30332034251120E-19  -4.62955527088565E-01  -4.62955527088510E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.41711333384296E-11   0.00000000000000E+00  -5.41711333384296E-11
      1.56225695417213E-18  -6.36951368943936E-03  -2.86913932467398E-03   0.00000000000000E+00   2.34053438518124E-14
     -3.40728335699443E-24  -1.11099142857628E-08  -1.11098908804189E-08  -1.23192491992101E-18
      3.96058924687077E-07
      0.00000000000000E+00  -1.11295615653337E-11   0.00000000000000E+00  -6.46590983983037E-16   2.71251466328003E-24
      1.11295503661663E-08   1.11295497195753E-08  -3.01236449767238E-19  -4.75097859857961E-01  -4.75097859857907E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47620197545431E-11   0.00000000000000E+00  -5.47620197545431E-11
      1.45273291466304E-18  -6.13490222181876E-03  -2.64558625984596E-03   0.00000000000000E+00   2.09782532166906E-14
     -3.08492694881606E-24  -1.10748086780740E-08  -1.10747876998207E-08  -1.15149646489581E-18
      3.98058924687077E-07
      0.00000000000000E+00  -1.11060493126085E-11   0.00000000000000E+00  -3.90124652503699E-16   2.50925333484083E-24
      1.11060525293034E-08   1.11060521391788E-08  -2.73134765263538E-19  -4.86993161002518E-01  -4.86993161002462E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52470851560987E-11   0.00000000000000E+00  -5.52470851560987E-11
      1.34223874435084E-18  -5.94916834271796E-03  -2.46740720128543E-03   0.00000000000000E+00   1.90959797725354E-14
     -2.82212407790652E-24  -1.10508241500024E-08  -1.10508050540226E-08  -1.06910397908731E-18
      4.00058924687077E-07
      0.00000000000000E+00  -1.10889661914879E-11   0.00000000000000E+00  -2.45129796506544E-16   2.34438640113768E-24
      1.10889787525812E-08   1.10889785074514E-08  -2.46019548271908E-19  -4.98644220465069E-01  -4.98644220465013E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56029156251411E-11   0.00000000000000E+00  -5.56029156251411E-11
      1.23103291310056E-18  -5.79916815795715E-03  -2.32289725763883E-03   0.00000000000000E+00   1.75320803002385E-14
     -2.60517165314164E-24  -1.10333931239066E-08  -1.10333755918263E-08  -9.85013364828654E-19
      4.02058924687077E-07
      0.00000000000000E+00  -1.10761079282789E-11   0.00000000000000E+00  -1.54419566462331E-16   2.20825542251341E-24
      1.10760711871756E-08   1.10760710327561E-08  -2.19882744867191E-19  -5.10048703080859E-01  -5.10048703080803E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57995590461119E-11   0.00000000000000E+00  -5.57995590461119E-11
      1.11943379500834E-18  -5.67617166724193E-03  -2.20402833824356E-03   0.00000000000000E+00   1.61885002900684E-14
     -2.42408749823843E-24  -1.10202876622102E-08  -1.10202714737100E-08  -8.99551050141148E-19
      4.04058924687077E-07
      0.00000000000000E+00  -1.10659131624489E-11   0.00000000000000E+00  -9.84874045745512E-17   2.09428742522474E-24
      1.10658784215593E-08   1.10658783230719E-08  -1.94752726766125E-19  -5.21183919893234E-01  -5.21183919893179E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57341062792664E-11   0.00000000000000E+00  -5.57341062792664E-11
      1.00796558244981E-18  -5.57411898701916E-03  -2.10516540480651E-03   0.00000000000000E+00   1.49917112868308E-14
     -2.27166898638464E-24  -1.10101592085039E-08  -1.10101442167926E-08  -8.13212855683681E-19
      4.06058924687077E-07
      0.00000000000000E+00  -1.10570960676769E-11   0.00000000000000E+00  -7.41511509671269E-17   1.99813909942468E-24
      1.10571181690521E-08   1.10571180949009E-08  -1.70778982807526E-19  -5.31968330945927E-01  -5.31968330945871E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50993664241275E-11   0.00000000000000E+00  -5.50993664241275E-11
      8.97766849601552E-19  -5.48887559252661E-03  -2.02248121554576E-03   0.00000000000000E+00   1.38417683411475E-14
     -2.14304771296382E-24  -1.10020325702452E-08  -1.10020187284768E-08  -7.26987866794027E-19
      4.08058924687077E-07
      0.00000000000000E+00  -1.10487381965911E-11   0.00000000000000E+00  -7.75921018625287E-17   1.91704286033013E-24
      1.10486953633027E-08   1.10486952857106E-08  -1.48255957967316E-19  -5.42247676056030E-01  -5.42247676055977E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34927394899332E-11   0.00000000000000E+00  -5.34927394899332E-11
      7.90781370621685E-19  -5.41766658850320E-03  -1.95341914264571E-03   0.00000000000000E+00   1.26416415676434E-14
     -2.03498397524596E-24  -1.09952151878623E-08  -1.09952025462207E-08  -6.42525412654369E-19
      4.10058924687077E-07
      0.00000000000000E+00  -1.10398292570819E-11   0.00000000000000E+00  -1.02390673014158E-16   1.84922233095302E-24
      1.10398040039814E-08   1.10398039015907E-08  -1.27591966934829E-19  -5.51806323064482E-01  -5.51806323064432E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.05507599030928E-11   0.00000000000000E+00  -5.05507599030928E-11
      6.89679850815500E-19  -5.35859868246416E-03  -1.89622512034154E-03   0.00000000000000E+00   1.13249175834333E-14
     -1.94525031454728E-24  -1.09892644666052E-08  -1.09892531416876E-08  -5.62087883880671E-19
      4.12058924687077E-07
      0.00000000000000E+00  -1.10296344912519E-11   0.00000000000000E+00  -1.48578106839072E-16   1.79366092910560E-24
      1.10296447738737E-08   1.10296446252956E-08  -1.09343629452282E-19  -5.60350008495345E-01  -5.60350008495299E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58096315124908E-11   0.00000000000000E+00  -4.58096315124908E-11
      5.98060587790518E-19  -5.31048371146396E-03  -1.84981669629858E-03   0.00000000000000E+00   9.80841762564915E-15
     -1.87258285597139E-24  -1.09838448022008E-08  -1.09838349937831E-08  -4.88716958338236E-19
      4.14058924687077E-07
      0.00000000000000E+00  -1.10173272964661E-11   0.00000000000000E+00  -2.22345754987922E-16   1.75008028211192E-24
      1.10172838254975E-08   1.10172836031518E-08  -9.42747862418070E-20  -5.67477620607634E-01  -5.67477620607596E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.86493623545326E-11   0.00000000000000E+00  -3.86493623545326E-11
      5.20761863081453E-19  -5.27280814701287E-03  -1.81377927656639E-03   0.00000000000000E+00   7.98955043373001E-15
     -1.81673709601956E-24  -1.09786422303477E-08  -1.09786342407972E-08  -4.26487076839645E-19
      4.16058924687077E-07
      0.00000000000000E+00  -1.10017136911408E-11   0.00000000000000E+00  -3.25735464777003E-16   1.71892857747638E-24
      1.10016816527176E-08   1.10016813269821E-08  -8.33758244764518E-20  -5.72673492344507E-01  -5.72673492344479E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84147794079612E-11   0.00000000000000E+00  -2.84147794079612E-11
      4.63932304265531E-19  -5.24569965143706E-03  -1.78836166236676E-03   0.00000000000000E+00   5.75032254275480E-15
     -1.77848879101989E-24  -1.09732722978967E-08  -1.09732665475741E-08  -3.80556479789079E-19
      4.18058924687077E-07
      0.00000000000000E+00  -1.09818752279040E-11   0.00000000000000E+00  -4.57586864708976E-16   1.70142714950737E-24
      1.09819182506752E-08   1.09819177930883E-08  -7.78409812588956E-20  -5.75324621742452E-01  -5.75324621742438E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45788117959510E-11   0.00000000000000E+00  -1.45788117959510E-11
      4.34774680673629E-19  -5.23000686654890E-03  -1.77453631065560E-03   0.00000000000000E+00   2.97871578523650E-15
     -1.75974676217902E-24  -1.09673419600081E-08  -1.09673389812924E-08  -3.56933699414732E-19
      4.20058924687077E-07
      0.00000000000000E+00  -1.09572608383324E-11   0.00000000000000E+00  -6.14494737985895E-16   1.69975024232550E-24
      1.09572572905525E-08   1.09572566760578E-08  -7.90322711255236E-20  -5.74751670136686E-01  -5.74751670136690E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14085278776954E-12   0.00000000000000E+00   3.14085278776954E-12
      4.41056386249168E-19  -5.22746862536232E-03  -1.77418513730866E-03   0.00000000000000E+00  -4.35445901608938E-16
     -1.76394038439329E-24  -1.09603970933996E-08  -1.09603975288455E-08  -3.62024115123644E-19
      4.22058924687077E-07
      0.00000000000000E+00  -1.09270439197911E-11   0.00000000000000E+00  -5.76195859929017E-16   1.71750739113078E-24
      1.09270080018910E-08   1.09270074256952E-08  -8.84679325336630E-20  -5.70237155138562E-01  -5.70237155138587E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47460164309585E-11   0.00000000000000E+00   2.47460164309585E-11
      4.90548419111085E-19  -5.24114883261506E-03  -1.79058916174016E-03   0.00000000000000E+00  -4.84555406165706E-15
     -1.79699813402221E-24  -1.09517485965720E-08  -1.09517534421261E-08  -4.02080486577422E-19
      4.24058924687077E-07
      0.00000000000000E+00  -1.08902141801709E-11   0.00000000000000E+00  -1.01375299763523E-15   1.76081407481197E-24
      1.08901872857942E-08   1.08901862720412E-08  -1.07864982673685E-19  -5.61038969090862E-01  -5.61038969090912E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99691475228201E-11   0.00000000000000E+00   4.99691475228201E-11
      5.90486714156725E-19  -5.27650076192890E-03  -1.82959576661894E-03   0.00000000000000E+00  -9.79419692709353E-15
     -1.86957570849858E-24  -1.09401456253671E-08  -1.09401554195640E-08  -4.82621731483041E-19
      4.26058924687077E-07
      0.00000000000000E+00  -1.08448428799903E-11   0.00000000000000E+00  -1.29571702227363E-15   1.84052705247149E-24
      1.08448376641270E-08   1.08448363684099E-08  -1.39241905013619E-19  -5.46391461939264E-01  -5.46391461939342E-01
      0.00000000000000E+00   0.00000000000000E+00   7.82267867439489E-11   0.00000000000000E+00   7.82267867439489E-11
      7.46940287644623E-19  -5.34383875132416E-03  -1.90231990870917E-03   0.00000000000000E+00  -1.62918153256709E-14
     -2.00221456730635E-24  -1.09230468633386E-08  -1.09230631551539E-08  -6.07698382631004E-19
      4.28058924687077E-07
      0.00000000000000E+00  -1.07864296271264E-11   0.00000000000000E+00  -3.10520422685532E-14   1.97699633849876E-24
      1.07864195025367E-08   1.07863884504944E-08  -1.85063936422651E-19  -5.25508556707974E-01  -5.25508556708082E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08406348307456E-10   0.00000000000000E+00   1.08406348307456E-10
      9.63752984259535E-19  -5.46432115055736E-03  -2.03170090441522E-03   0.00000000000000E+00   4.59725826508226E-15
     -2.23860366333177E-24  -1.08947993960601E-08  -1.08947947988019E-08  -7.78689047836883E-19
      4.30058924687077E-07
      0.00000000000000E+00  -1.07029427610047E-11   0.00000000000000E+00  -2.73038989111108E-15   2.21039195405974E-24
      1.07030091473317E-08   1.07030064169418E-08  -2.48371954606035E-19  -4.97606888488558E-01  -4.97606888488697E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38441520733032E-10   0.00000000000000E+00   1.38441520733032E-10
      1.24063602572560E-18  -5.68602796846864E-03  -2.27022740114876E-03   0.00000000000000E+00  -3.59860427423592E-14
     -2.68568435014420E-24  -1.08414119516321E-08  -1.08414479376749E-08  -9.92264071119563E-19
      4.32058924687077E-07
      0.00000000000000E+00  -1.05582872999029E-11   0.00000000000000E+00  -4.14532923146953E-15   2.62045761539189E-24
      1.05582845920395E-08   1.05582804467103E-08  -3.32673223359402E-19  -4.61958778493992E-01  -4.61958778494157E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64860910739570E-10   0.00000000000000E+00   1.64860910739570E-10
      1.57035784720474E-18  -6.13384812364992E-03  -2.75532628007769E-03   0.00000000000000E+00  -5.28694167862231E-14
     -3.66263459666169E-24  -1.07230884880330E-08  -1.07231413574498E-08  -1.23768462384534E-18
      4.34058924687077E-07
      0.00000000000000E+00  -1.02235132327814E-11   0.00000000000000E+00  -7.71913120185036E-14   3.32094717057449E-24
      1.02234785246410E-08   1.02234013333289E-08  -4.40821579557026E-19  -4.17960761541297E-01  -4.17960761541481E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83377322666917E-10   0.00000000000000E+00   1.83377322666917E-10
      1.93711249253857E-18  -7.19018842368728E-03  -3.91132711091846E-03   0.00000000000000E+00  -9.88015940340352E-15
     -6.37773961452024E-24  -1.04067687758364E-08  -1.04067786559958E-08  -1.49629091298155E-18
      4.36058924687077E-07
      0.00000000000000E+00  -9.21009840243358E-12   0.00000000000000E+00  -2.63066616065045E-14   3.93306040961716E-24
      9.21013234499842E-09   9.21010603833681E-09  -5.71134220693311E-19  -3.65213172927485E-01  -3.65213172927679E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94082471047530E-10   0.00000000000000E+00   1.94082471047530E-10
      2.32527743463363E-18  -1.01841178609616E-02  -7.22117098540035E-03   0.00000000000000E+00  -1.14851977651825E-13
     -1.59987952133765E-23  -9.40407365740667E-09  -9.40418850938434E-09  -1.75414321394032E-18
      4.38058924687077E-07
      0.00000000000000E+00  -6.32185695146848E-12   0.00000000000000E+00  -7.31856399008582E-14  -3.53946488184686E-25
      6.32191461228301E-09   6.32184142664311E-09  -7.12453593900781E-19  -3.03800621154440E-01  -3.03800621154653E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12076431983350E-10   0.00000000000000E+00   2.12076431983350E-10
      2.74943029860033E-18  -1.87261282155327E-02  -1.66675185693835E-02   0.00000000000000E+00  -1.66481379481458E-13
     -4.47845766009830E-23  -6.53375137724694E-09  -6.53391785862647E-09  -2.03697670469955E-18
      4.40058924687077E-07
      0.00000000000000E+00  -2.41615950171841E-12   0.00000000000000E+00  -1.00958492794764E-13  -1.82322331179640E-23
      2.41630846104162E-09   2.41620750254881E-09  -8.55342056419838E-19  -2.35122268658339E-01  -2.35122268658577E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38279802586221E-10   0.00000000000000E+00   2.38279802586221E-10
      3.22598990377278E-18  -3.46767325962938E-02  -3.38404017757573E-02   0.00000000000000E+00  -2.85340381636733E-13
     -7.67528585814961E-23  -2.65420196475331E-09  -2.65448730513503E-09  -2.37064784735294E-18
      4.42058924687077E-07
      0.00000000000000E+00  -5.14606062573772E-13   0.00000000000000E+00  -5.05398572755355E-14  -3.61785097229077E-23
      5.14661499436438E-10   5.14610959579127E-10  -1.00166832320072E-18  -1.62491591407304E-01  -1.62491591407547E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43616136007787E-10   0.00000000000000E+00   2.43616136007787E-10
      3.71322217578835E-18  -5.40130537537099E-02  -5.37741665236920E-02   0.00000000000000E+00  -5.13059933830582E-13
     -8.78849930242549E-23  -7.57714035652995E-10  -7.58227095586914E-10  -2.71155385258763E-18
      4.44058924687077E-07
      0.00000000000000E+00  -3.13190553877666E-14   0.00000000000000E+00  -1.63788707614056E-14  -4.38120621950438E-23
      3.13759496722984E-11   3.13595708014932E-11  -1.14469646723716E-18  -9.21130465555144E-02  -9.21130465557368E-02
      0.00000000000000E+00   0.00000000000000E+00   2.22361486514983E-10   0.00000000000000E+00   2.22361486514983E-10
      4.15794514881832E-18  -7.39487312834623E-02  -7.38687941307999E-02   0.00000000000000E+00  -7.45651116877110E-13
     -9.49594355659457E-23  -2.52975406199503E-10  -2.53721057316475E-10  -3.01324868158115E-18
      4.46058924687077E-07
      0.00000000000000E+00   2.76452658994656E-14   0.00000000000000E+00  -4.98710618293439E-15  -4.56764249471040E-23
     -2.75995445378892E-11  -2.76045316441178E-11  -1.24522059310920E-18  -4.30442088054515E-02  -4.30442088056141E-02
      0.00000000000000E+00   0.00000000000000E+00   1.62604700815028E-10   0.00000000000000E+00   1.62604700815028E-10
      4.48315455044837E-18  -9.37178607389924E-02  -9.36753277561214E-02   0.00000000000000E+00  -7.24727931723060E-13
     -1.00895967860654E-22  -1.34275441239087E-10  -1.35000169170911E-10  -3.23793395733918E-18
      4.48058924687077E-07
      0.00000000000000E+00   9.46000793237526E-15   0.00000000000000E+00  -8.96761631322323E-16  -4.60146265876771E-23
     -9.43526460933893E-12  -9.43616137101627E-12  -1.29333084694677E-18  -2.06675931081974E-02  -2.06675931082965E-02
      0.00000000000000E+00   0.00000000000000E+00   9.91162056742507E-11   0.00000000000000E+00   9.91162056742507E-11
      4.68138696179687E-18  -1.13179044182833E-01  -1.13150789903947E-01   0.00000000000000E+00  -4.78439545141702E-13
     -1.04242140553661E-22  -8.92016047579880E-11  -8.96800443032340E-11  -3.38805611485010E-18
      4.50058924687077E-07
      0.00000000000000E+00  -8.90893950913009E-15   0.00000000000000E+00   2.99306671321556E-16  -4.57146879494619E-23
      8.91305783564846E-12   8.91335714227407E-12  -1.31284639258574E-18  -1.22235269832807E-02  -1.22235269833431E-02
      0.00000000000000E+00   0.00000000000000E+00   6.23825719642795E-11   0.00000000000000E+00   6.23825719642795E-11
      4.80615210572543E-18  -1.32283921877036E-01  -1.32261459818164E-01   0.00000000000000E+00  -3.25820158162813E-13
     -1.06318608515778E-22  -7.09701089482840E-11  -7.12959291065532E-11  -3.49330571313970E-18
      4.52058924687077E-07
      0.00000000000000E+00  -2.13998237693537E-14   0.00000000000000E+00   4.81835738213502E-16  -4.47609419247822E-23
      2.14176267877627E-11   2.14181086234561E-11  -1.31997166210142E-18  -9.09908986833066E-03  -9.09908986837434E-03
      0.00000000000000E+00   0.00000000000000E+00   4.36856101194886E-11   0.00000000000000E+00   4.36856101194886E-11
      4.89352332596441E-18  -1.51014137887420E-01  -1.50993626836120E-01   0.00000000000000E+00  -2.76813101421779E-13
     -1.07990541378572E-22  -6.48269056414156E-11  -6.51037187429453E-11  -3.57355166386299E-18
      4.54058924687077E-07
      0.00000000000000E+00  -3.02169185412763E-14   0.00000000000000E+00   4.45012519569399E-16  -4.28482683819460E-23
      3.02495100763692E-11   3.02499550888459E-11  -1.32194885671760E-18  -7.79547551414246E-03  -7.79547551417607E-03
      0.00000000000000E+00   0.00000000000000E+00   3.36041676685320E-11   0.00000000000000E+00   3.36041676685320E-11
      4.96073166130147E-18  -1.69366703938829E-01  -1.69346586690716E-01   0.00000000000000E+00  -2.71333397131903E-13
     -1.09565717821427E-22  -6.35827893601354E-11  -6.38541227573769E-11  -3.63878280458387E-18
      4.56058924687077E-07
      0.00000000000000E+00  -3.70134290946333E-14   0.00000000000000E+00   3.50068051941426E-16  -3.95708305357223E-23
      3.69899671639833E-11   3.69903172319957E-11  -1.32174993445807E-18  -7.11954032359970E-03  -7.11954032362727E-03
      0.00000000000000E+00   0.00000000000000E+00   2.75663671274005E-11   0.00000000000000E+00   2.75663671274005E-11
      5.01586439555627E-18  -1.87345544701286E-01  -1.87325206214645E-01   0.00000000000000E+00  -2.77911034270302E-13
     -1.11125718704195E-22  -6.42787733250162E-11  -6.45566843593977E-11  -3.69411446109820E-18
      4.58058924687077E-07
      0.00000000000000E+00  -4.25241133270849E-14   0.00000000000000E+00   2.74149441589166E-16  -3.45011497948500E-23
      4.24973873762854E-11   4.24976615256925E-11  -1.32061798355980E-18  -6.68971858414269E-03  -6.68971858416632E-03
      0.00000000000000E+00   0.00000000000000E+00   2.36222126728375E-11   0.00000000000000E+00   2.36222126728375E-11
      5.06310882090195E-18  -2.04957400227483E-01  -2.04936569367267E-01   0.00000000000000E+00  -2.85726529340581E-13
     -1.12682892483747E-22  -6.58341476690761E-11  -6.61198741985294E-11  -3.74249083734214E-18
      4.60058924687077E-07
      0.00000000000000E+00  -4.73000396618763E-14   0.00000000000000E+00   2.22480243515759E-16  -2.72630162530032E-23
      4.72591420928427E-11   4.72593645730590E-11  -1.31910213425128E-18  -6.38025797343683E-03  -6.38025797345773E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08997218100524E-11   0.00000000000000E+00   2.08997218100524E-11
      5.10490826452205E-18  -2.22209910742433E-01  -2.22188437548081E-01   0.00000000000000E+00  -2.92001608683860E-13
     -1.14233378735700E-22  -6.78670847743141E-11  -6.81590863831122E-11  -3.78580613027077E-18
      4.62058924687077E-07
      0.00000000000000E+00  -5.15248975734225E-14   0.00000000000000E+00   1.89256939129461E-16  -1.76427219895371E-23
      5.15679330734789E-11   5.15681223304004E-11  -1.31745537291433E-18  -6.14326381128659E-03  -6.14326381130554E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89533304674030E-11   0.00000000000000E+00   1.89533304674030E-11
      5.14281492545686E-18  -2.39110658992126E-01  -2.39088441665960E-01   0.00000000000000E+00  -2.96492408932677E-13
     -1.15771820568507E-22  -7.02249603887541E-11  -7.05214527978026E-11  -3.82535955254253E-18
      4.64058924687076E-07
      0.00000000000000E+00  -5.55660660105537E-14   0.00000000000000E+00   1.68220385929429E-16  -5.71663079975554E-24
      5.56002916132464E-11   5.56004598336266E-11  -1.31579424730424E-18  -5.95584921294874E-03  -5.95584921296627E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75220662890535E-11   0.00000000000000E+00   1.75220662890535E-11
      5.17785905803497E-18  -2.55666769866532E-01  -2.55643733216748E-01   0.00000000000000E+00  -2.99609676541563E-13
     -1.17294612486284E-22  -7.28229164460217E-11  -7.31225261226805E-11  -3.86206481073072E-18
      4.66058924687076E-07
      0.00000000000000E+00  -5.94235449732698E-14   0.00000000000000E+00   1.54792454740910E-16   7.93370396234737E-24
      5.94607740712174E-11   5.94609288636801E-11  -1.31416928173380E-18  -5.80460021466605E-03  -5.80460021468249E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64389611470884E-11   0.00000000000000E+00   1.64389611470884E-11
      5.21073698032914E-18  -2.71885066778456E-01  -2.71861155277423E-01   0.00000000000000E+00  -3.01864170454031E-13
     -1.18800337788032E-22  -7.55980258401954E-11  -7.58998900107682E-11  -3.89656769859534E-18
      4.68058924687076E-07
      0.00000000000000E+00  -6.31891791987784E-14   0.00000000000000E+00   1.46064532593384E-16   2.20343005312864E-23
      6.32126413706414E-11   6.32127874351961E-11  -1.31259883053231E-18  -5.68064423790362E-03  -5.68064423791921E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55927657690886E-11   0.00000000000000E+00   1.55927657690886E-11
      5.24192251186732E-18  -2.87772719670344E-01  -2.87747892909282E-01   0.00000000000000E+00  -3.03725173027251E-13
     -1.20289321162796E-22  -7.85018280311369E-11  -7.88055532042844E-11  -3.92932368133502E-18
      4.70058924687076E-07
      0.00000000000000E+00  -6.68629686870795E-14   0.00000000000000E+00   1.40283874309941E-16   3.58140970292941E-23
      6.68965586081723E-11   6.68966988920824E-11  -1.31108609202622E-18  -5.57782008480458E-03  -5.57782008481949E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49075716530303E-11   0.00000000000000E+00   1.49075716530303E-11
      5.27173765517338E-18  -3.03337126968096E-01  -3.03311355641411E-01   0.00000000000000E+00  -3.05570592246147E-13
     -1.21763260191815E-22  -8.14986999527451E-11  -8.18042705451130E-11  -3.96065156314716E-18
      4.72058924687076E-07
      0.00000000000000E+00  -7.05367581753806E-14   0.00000000000000E+00   1.36379038637245E-16   4.86751806264091E-23
      7.05394183186051E-11   7.05395546976924E-11  -1.30962772667318E-18  -5.49190763811452E-03  -5.49190763812885E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43285853008050E-11   0.00000000000000E+00   1.43285853008050E-11
      5.30039482577499E-18  -3.18582801406821E-01  -3.18556064999044E-01   0.00000000000000E+00  -3.07611948805994E-13
     -1.23224520252486E-22  -8.45605280495685E-11  -8.48681399984977E-11  -3.99076709910181E-18
      4.74058924687076E-07
      0.00000000000000E+00  -7.41187029264741E-14   0.00000000000000E+00   1.33629596704765E-16   6.02022413618014E-23
      7.41577107763917E-11   7.41578444060486E-11  -1.30821844319818E-18  -5.42007903615687E-03  -5.42007903617068E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38143743825023E-11   0.00000000000000E+00   1.38143743825023E-11
      5.32802357454000E-18  -3.33507636019448E-01  -3.33479921873110E-01   0.00000000000000E+00  -3.09881245962711E-13
     -1.24675132234771E-22  -8.76623375424631E-11  -8.79722187885504E-11  -4.01980513134181E-18
      4.76058924687076E-07
      0.00000000000000E+00  -7.77924924147752E-14   0.00000000000000E+00   1.31472509155952E-16   7.01979163562496E-23
      7.77618976473614E-11   7.77620291199407E-11  -1.30685265578946E-18  -5.36040440131070E-03  -5.36040440132404E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33421119159132E-11   0.00000000000000E+00   1.33421119159132E-11
      5.35470779837182E-18  -3.48111893412996E-01  -3.48083192766465E-01   0.00000000000000E+00  -3.12574380626653E-13
     -1.26117764253611E-22  -9.07915666551013E-11  -9.11041410358540E-11  -4.04785514258236E-18
      4.78058924687076E-07
      0.00000000000000E+00  -8.13744371658687E-14   0.00000000000000E+00   1.30286798759090E-16   7.86620919160260E-23
      8.13640600777769E-11   8.13641903646543E-11  -1.30552354397965E-18  -5.31165634332146E-03  -5.31165634333437E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29143637969078E-11   0.00000000000000E+00   1.29143637969078E-11
      5.38053652596563E-18  -3.62420617323552E-01  -3.62390916800986E-01   0.00000000000000E+00  -3.16466318159047E-13
     -1.27558311897309E-22  -9.39620878432755E-11  -9.42785541615622E-11  -4.07501298198599E-18
      4.80058924687077E-07
      0.00000000000000E+00  -8.49563819169622E-14   0.00000000000000E+00   1.29860460908250E-16   8.57360587372291E-23
      8.49833854571542E-11   8.49835153177009E-11  -1.30422151839001E-18  -5.27327638574359E-03  -5.27327638575614E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25530104671142E-11   0.00000000000000E+00   1.25530104671142E-11
      5.40564254689987E-18  -3.76501804262243E-01  -3.76471077550297E-01   0.00000000000000E+00  -3.22897734543016E-13
     -1.29008186083485E-22  -9.72136280501429E-11  -9.75365257848149E-11  -4.10142102850986E-18
      4.82058924687077E-07
      0.00000000000000E+00  -8.86301714052633E-14   0.00000000000000E+00   1.29686870694269E-16   9.16146627507045E-23
      8.86230229812358E-11   8.86231526681981E-11  -1.30294143815439E-18  -5.24534122619710E-03  -5.24534122620929E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22000854304031E-11   0.00000000000000E+00   1.22000854304031E-11
      5.43004271776067E-18  -3.90356838815411E-01  -3.90325076872939E-01   0.00000000000000E+00  -3.29976802894549E-13
     -1.30469581125617E-22  -1.00493261295577E-10  -1.00823238098602E-10  -4.12710127960629E-18
      4.84058924687077E-07
      0.00000000000000E+00  -9.23039608935644E-14   0.00000000000000E+00   1.29456421362716E-16   9.65038340623376E-23
      9.22774037250426E-11   9.22775331815605E-11  -1.30168028563452E-18  -5.22863154366576E-03  -5.22863154367758E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18253770169320E-11   0.00000000000000E+00   1.18253770169320E-11
      5.45369347179454E-18  -4.03956558719894E-01  -4.03923763779073E-01   0.00000000000000E+00  -3.36794989761167E-13
     -1.31940415242675E-22  -1.03766115208599E-10  -1.04102910198492E-10  -4.15201318616001E-18
      4.86058924687077E-07
      0.00000000000000E+00  -9.59777503818655E-14   0.00000000000000E+00   1.29431692245156E-16   1.00600903456952E-22
      9.59471446373460E-11   9.59472740691388E-11  -1.30043319220393E-18  -5.22478865839807E-03  -5.22478865840951E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14369900360045E-11   0.00000000000000E+00   1.14369900360045E-11
      5.47656745186655E-18  -4.17289668938411E-01  -4.17255840483710E-01   0.00000000000000E+00  -3.43865898355511E-13
     -1.33420691599413E-22  -1.07040398206654E-10  -1.07384264105143E-10  -4.17613425966261E-18
      4.88058924687077E-07
      0.00000000000000E+00  -9.96515398701665E-14   0.00000000000000E+00   1.29867928258334E-16   1.04079780927877E-22
      9.96388700188655E-11   9.96389998868978E-11  -1.29919240300854E-18  -5.23670745331363E-03  -5.23670745332467E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10397643555663E-11   0.00000000000000E+00   1.10397643555663E-11
      5.49864698057768E-18  -4.30355750115007E-01  -4.30320884019653E-01   0.00000000000000E+00  -3.51412475217855E-13
     -1.34911074010344E-22  -1.10327351767112E-10  -1.10678764242465E-10  -4.19945457756913E-18
      4.90058924687077E-07
      0.00000000000000E+00  -1.03325329358468E-13   0.00000000000000E+00   1.31180305134106E-16   1.07088302836882E-22
      1.03368301339391E-10   1.03368432519803E-10  -1.29794523773728E-18  -5.26951023332596E-03  -5.26951023333660E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06328013030004E-11   0.00000000000000E+00   1.06328013030004E-11
      5.51991258318368E-18  -4.43158278940238E-01  -4.43122366408583E-01   0.00000000000000E+00  -3.59370681726721E-13
     -1.36411594535920E-22  -1.13641863140939E-10  -1.14001233822803E-10  -4.22196734544640E-18
      4.92058924687077E-07
      0.00000000000000E+00  -1.07182808321184E-13   0.00000000000000E+00   1.34275163258936E-16   1.09755729329576E-22
      1.07169512925169E-10   1.07169647200442E-10  -1.29666906769531E-18  -5.33280900317115E-03  -5.33280900318136E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02095696362918E-11   0.00000000000000E+00   1.02095696362918E-11
      5.54033172245627E-18  -4.55701899350936E-01  -4.55664922911463E-01   0.00000000000000E+00  -3.67481583555506E-13
     -1.37920860054675E-22  -1.17011735253041E-10  -1.17379216836734E-10  -4.24366265476095E-18
      4.94058924687077E-07
      0.00000000000000E+00  -1.11132132021107E-13   0.00000000000000E+00   1.40927814593134E-16   1.12211646266632E-22
      1.11117995828255E-10   1.11118136756182E-10  -1.29531920798910E-18  -5.44614366867303E-03  -5.44614366868278E-03
      0.00000000000000E+00   0.00000000000000E+00   9.75308728420664E-12   0.00000000000000E+00   9.75308728420664E-12
      5.55983789702468E-18  -4.67991475247155E-01  -4.67953398997768E-01   0.00000000000000E+00  -3.75217095867872E-13
     -1.39435077489983E-22  -1.20496006944382E-10  -1.20871224040389E-10  -4.26451868903558E-18
      4.96058924687077E-07
      0.00000000000000E+00  -1.15356989932654E-13   0.00000000000000E+00   1.56847378814113E-16   1.14630457967088E-22
      1.15393306478364E-10   1.15393463325857E-10  -1.29379701841877E-18  -5.65339339154718E-03  -5.65339339155640E-03
      0.00000000000000E+00   0.00000000000000E+00   9.21961167944586E-12   0.00000000000000E+00   9.21961167944586E-12
      5.57827712038357E-18  -4.80031661591980E-01  -4.79992406847852E-01   0.00000000000000E+00  -3.81424208682143E-13
     -1.40945829530997E-22  -1.24231650796480E-10  -1.24613075005303E-10  -4.28448010196480E-18
      4.98058924687077E-07
      0.00000000000000E+00  -1.20500295216275E-13   0.00000000000000E+00   1.93619451949630E-16   1.17361311898937E-22
      1.20477645432482E-10   1.20477839052051E-10  -1.29185272718392E-18  -6.06690861299412E-03  -6.06690861300260E-03
      0.00000000000000E+00   0.00000000000000E+00   8.48386218208430E-12   0.00000000000000E+00   8.48386218208430E-12
      5.59524484474774E-18  -4.91826386309112E-01  -4.91785761951242E-01   0.00000000000000E+00  -3.83050750311042E-13
     -1.42433345775992E-22  -1.28578650483681E-10  -1.28961701234135E-10  -4.30339211756382E-18
      5.00058924687077E-07
      0.00000000000000E+00  -1.27847874192877E-13   0.00000000000000E+00   3.04490018397868E-16   1.21397099237163E-22
      1.27902905304540E-10   1.27903209794680E-10  -1.28873956083428E-18  -7.02490207924634E-03  -7.02490207925347E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13042247273028E-12   0.00000000000000E+00   7.13042247273028E-12
      5.60950568969319E-18  -5.03377352670005E-01  -5.03334815874702E-01   0.00000000000000E+00  -3.70309842618152E-13
     -1.43842360375746E-22  -1.34663322424648E-10  -1.35033632267411E-10  -4.32076612885892E-18
      5.02058924687077E-07
      0.00000000000000E+00  -1.43461479518157E-13   0.00000000000000E+00   6.51103779888360E-16   1.30255160003145E-22
      1.43459194218163E-10   1.43459845322073E-10  -1.28187184249450E-18  -9.69816626820124E-03  -9.69816626820486E-03
      0.00000000000000E+00   0.00000000000000E+00   3.61898215503540E-12   0.00000000000000E+00   3.61898215503540E-12
      5.61674365400327E-18  -5.14677981975105E-01  -5.14631651176352E-01   0.00000000000000E+00  -3.07072931530093E-13
     -1.44988681569257E-22  -1.46771754545434E-10  -1.47078827477109E-10  -4.33487181150877E-18
      5.04058924687077E-07
      0.00000000000000E+00  -1.87822487589392E-13   0.00000000000000E+00   1.80424687923078E-15   1.54500305881410E-22
      1.87888919491707E-10   1.87890723738740E-10  -1.26359259242651E-18  -1.74752125344145E-02  -1.74752125344082E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.31370590885175E-12   0.00000000000000E+00  -6.31370590885175E-12
      5.60411624218556E-18  -5.25689829492099E-01  -5.25632631970858E-01   0.00000000000000E+00  -9.79863181744786E-14
     -1.45348948671230E-22  -1.81479031511569E-10  -1.81577017829889E-10  -4.34052364975906E-18
      5.06058924687077E-07
      0.00000000000000E+00  -2.97209569603557E-13   0.00000000000000E+00   3.96931841867514E-15   1.99625176958144E-22
      2.97219328292075E-10   2.97223297610693E-10  -1.22726857913791E-18  -3.28242060288727E-02  -3.28242060288507E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.20351505301806E-11   0.00000000000000E+00  -2.20351505301806E-11
      5.56004594112520E-18  -5.36304055116016E-01  -5.36217369851388E-01   0.00000000000000E+00   2.09220242319633E-13
     -1.44569045058428E-22  -2.75397367322687E-10  -2.75188147080512E-10  -4.33277736198730E-18
      5.08058924687077E-07
      0.00000000000000E+00  -4.96512649343890E-13   0.00000000000000E+00   6.32579117029655E-15   2.43771045280941E-22
      4.96462677837195E-10   4.96469003628609E-10  -1.18006730751946E-18  -5.19952285116862E-02  -5.19952285116534E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.27506103324985E-11   0.00000000000000E+00  -3.27506103324985E-11
      5.49454472046021E-18  -5.46344496572482E-01  -5.46198422788452E-01   0.00000000000000E+00   3.40626356260882E-13
     -1.43276030501373E-22  -4.64059019652229E-10  -4.63718393296111E-10  -4.31447741294074E-18
      5.10058924687077E-07
      0.00000000000000E+00  -8.20449037474836E-13   0.00000000000000E+00   9.29113767502346E-15   2.74382259115177E-22
      8.20393433275435E-10   8.20402724413385E-10  -1.12998544245265E-18  -7.19260692100722E-02  -7.19260692100337E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.84967442735567E-11   0.00000000000000E+00  -3.84967442735567E-11
      5.41755123191309E-18  -5.55571078174601E-01  -5.55324771900417E-01   0.00000000000000E+00   3.41467598773876E-13
     -1.41948591866839E-22  -7.82247447738460E-10  -7.81905980139828E-10  -4.28756578946044E-18
      5.12058924687077E-07
      0.00000000000000E+00  -1.32100285525586E-12   0.00000000000000E+00   1.35150112209397E-14   2.95665073136392E-22
      1.32100904762225E-09   1.32102256263377E-09  -1.08100775601389E-18  -9.17220292780749E-02  -9.17220292780321E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.28190169680302E-11   0.00000000000000E+00  -4.28190169680302E-11
      5.33191319797703E-18  -5.63654451935556E-01  -5.63251805702567E-01   0.00000000000000E+00   3.12686339399494E-13
     -1.40701925838864E-22  -1.27851623200500E-09  -1.27820354566574E-09  -4.25090544196314E-18
      5.14058924687077E-07
      0.00000000000000E+00  -2.06154697136015E-12   0.00000000000000E+00   1.93177173263812E-14   3.12924350089889E-22
      2.06150931735084E-09   2.06152863506847E-09  -1.03488502435308E-18  -1.11217488420796E-01  -1.11217488420749E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74319422945864E-11   0.00000000000000E+00  -4.74319422945864E-11
      5.23704931338786E-18  -5.70152446770842E-01  -5.69517983749533E-01   0.00000000000000E+00   2.85553611934640E-13
     -1.39531862386656E-22  -2.01438224638568E-09  -2.01409669277389E-09  -4.20216428903478E-18
      5.16058924687077E-07
      0.00000000000000E+00  -3.10407658340278E-12   0.00000000000000E+00   2.66659140196955E-14   3.27976216437710E-22
      3.10400670071375E-09   3.10403336662809E-09  -9.92286851485092E-19  -1.30359809280432E-01  -1.30359809280379E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28350767272681E-11   0.00000000000000E+00  -5.28350767272681E-11
      5.13137915993332E-18  -5.74511982505929E-01  -5.73550816041167E-01   0.00000000000000E+00   2.66531510697699E-13
     -1.38406859959367E-22  -3.05146482141138E-09  -3.05119828990082E-09  -4.13909230844823E-18
      5.18058924687077E-07
      0.00000000000000E+00  -4.49892260737349E-12   0.00000000000000E+00   3.52658422627331E-14   3.40774891810897E-22
      4.49891350982873E-09   4.49894877567133E-09  -9.53172394112511E-19  -1.49128409348456E-01  -1.49128409348397E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.89967119942898E-11   0.00000000000000E+00  -5.89967119942898E-11
      5.01338573594474E-18  -5.76092797818935E-01  -5.74694149302579E-01   0.00000000000000E+00   2.62339709007302E-13
     -1.37265911278481E-22  -4.44021440338591E-09  -4.43995206367704E-09  -4.06021334183223E-18
      5.20058924687077E-07
      0.00000000000000E+00  -6.28061866446230E-12   0.00000000000000E+00   4.47255913610793E-14   3.50733820687240E-22
      6.28059495170087E-09   6.28063967729258E-09  -9.17095601975982E-19  -1.67519236415491E-01  -1.67519236415425E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55361328289541E-11   0.00000000000000E+00  -6.55361328289541E-11
      4.88231347028684E-18  -5.74199417310382E-01  -5.72241560390353E-01   0.00000000000000E+00   2.81982299646377E-13
     -1.36007089978999E-22  -6.21538552676314E-09  -6.21510354446363E-09  -3.96521786831086E-18
      5.22058924687077E-07
      0.00000000000000E+00  -8.47148302581064E-12   0.00000000000000E+00   5.47428193078952E-14   3.57243343707884E-22
      8.47146765593404E-09   8.47152239875371E-09  -8.83465615704449E-19  -1.85535761145200E-01  -1.85535761145128E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19468098554432E-11   0.00000000000000E+00  -7.19468098554432E-11
      4.73841985057595E-18  -5.68104872503244E-01  -5.65458855721848E-01   0.00000000000000E+00   3.34133815827760E-13
     -1.34484523085123E-22  -8.39990972271396E-09  -8.39957558889827E-09  -3.85495423487150E-18
      5.24058924687078E-07
      0.00000000000000E+00  -1.10900683283344E-11   0.00000000000000E+00   6.52534097356593E-14   3.59760698361708E-22
      1.10899706989084E-08   1.10900359523185E-08  -8.51709944373884E-19  -2.03184551878137E-01  -2.03184551878060E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.78252265136275E-11   0.00000000000000E+00  -7.78252265136275E-11
      4.58276939754869E-18  -5.57058785999030E-01  -5.53589715726615E-01   0.00000000000000E+00   4.22691213979449E-13
     -1.32522036929383E-22  -1.10126334170187E-08  -1.10122107258048E-08  -3.73105945317481E-18
      5.26058924687078E-07
      0.00000000000000E+00  -1.41549272089496E-11   0.00000000000000E+00   7.62339472547431E-14   3.57717252542267E-22
      1.41548038231579E-08   1.41548800571055E-08  -8.21347544936851E-19  -2.20473213437704E-01  -2.20473213437621E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.30029730575694E-11   0.00000000000000E+00  -8.30029730575694E-11
      4.41676345143355E-18  -5.40287061117247E-01  -5.35854090568675E-01   0.00000000000000E+00   5.42251969673863E-13
     -1.29947254952688E-22  -1.40724193360175E-08  -1.40718770840479E-08  -3.59541590649671E-18
      5.28058924687078E-07
      0.00000000000000E+00  -1.76803874466605E-11   0.00000000000000E+00   8.75878634176341E-14   3.50329886138417E-22
      1.76802893531564E-08   1.76803769410202E-08  -7.92008339805296E-19  -2.37409361213638E-01  -2.37409361213550E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75641918372839E-11   0.00000000000000E+00  -8.75641918372839E-11
      4.24163506775899E-18  -5.17000139636319E-01  -5.11457925104725E-01   0.00000000000000E+00   6.76093190044085E-13
     -1.26641005622364E-22  -1.75934888423728E-08  -1.75928127491829E-08  -3.44962672795369E-18
      5.30058924687078E-07
      0.00000000000000E+00  -2.16628670967161E-11   0.00000000000000E+00   9.88741410113404E-14   3.36442922426328E-22
      2.16628046753468E-08   2.16629035494882E-08  -7.63427053248080E-19  -2.54000169138807E-01  -2.54000169138716E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.17459469955751E-11   0.00000000000000E+00  -9.17459469955751E-11
      4.05814317376783E-18  -4.86426563470144E-01  -4.79630965099998E-01   0.00000000000000E+00   8.00532091041768E-13
     -1.22577077671312E-22  -2.15719581345835E-08  -2.15711576024926E-08  -3.29471612051976E-18
      5.32058924687078E-07
      0.00000000000000E+00  -2.60656282642333E-11   0.00000000000000E+00   1.09274362010942E-13   3.14894355894078E-22
      2.60655381126647E-08   2.60656473870270E-08  -7.35418830221623E-19  -2.70252463995047E-01  -2.70252463994952E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.57175288206538E-11   0.00000000000000E+00  -9.57175288206538E-11
      3.86670811612653E-18  -4.47874752650992E-01  -4.39693270116301E-01   0.00000000000000E+00   8.97223027242144E-13
     -1.17801379272260E-22  -2.59708270812335E-08  -2.59699298582064E-08  -3.13128928590491E-18
      5.34058924687078E-07
      0.00000000000000E+00  -3.08158380726066E-11   0.00000000000000E+00   1.17899613223332E-13   2.86399493340709E-22
      3.08157154769603E-08   3.08158333765739E-08  -7.07836208478199E-19  -2.86173353364227E-01  -2.86173353364128E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93168645747468E-11   0.00000000000000E+00  -9.93168645747468E-11
      3.66807438697704E-18  -4.00801626614194E-01  -3.91124625262011E-01   0.00000000000000E+00   9.64802181034312E-13
     -1.12317138344419E-22  -3.07174813141800E-08  -3.07165165119991E-08  -2.96023817849884E-18
      5.36058924687078E-07
      0.00000000000000E+00  -3.57909756424011E-11   0.00000000000000E+00   1.23518324625335E-13   2.56156670212339E-22
      3.57909020409408E-08   3.57910255592656E-08  -6.80555646162177E-19  -3.01770295423169E-01  -3.01770295423066E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02330421301270E-10   0.00000000000000E+00  -1.02330421301270E-10
      3.46341354437449E-18  -3.44923087955437E-01  -3.33679429446133E-01   0.00000000000000E+00   1.00082551582884E-12
     -1.05973866832638E-22  -3.56896959634801E-08  -3.56886951379643E-08  -2.78285789821232E-18
      5.38058924687078E-07
      0.00000000000000E+00  -4.06527768064815E-11   0.00000000000000E+00   1.20770945329852E-13   2.30373049009525E-22
      4.06526377825958E-08   4.06527585535414E-08  -6.53596064316924E-19  -3.17048323102529E-01  -3.17048323102423E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05948831883521E-10   0.00000000000000E+00  -1.05948831883521E-10
      3.25151588060745E-18  -2.80660634951241E-01  -2.67886195157447E-01   0.00000000000000E+00   9.56455460986542E-13
     -9.84329379527013E-23  -4.05477661771187E-08  -4.05468097216578E-08  -2.59791981629053E-18
      5.40058924687078E-07
      0.00000000000000E+00  -4.45326658850763E-11   0.00000000000000E+00   9.64978542223610E-14   2.01337855242568E-22
      4.45326028925078E-08   4.45326993903623E-08  -6.27267098556223E-19  -3.32005977168162E-01  -3.32005977168049E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13458083968294E-10   0.00000000000000E+00  -1.13458083968294E-10
      3.02459971267086E-18  -2.10106494885780E-01  -1.96111800466716E-01   0.00000000000000E+00   7.81866089815525E-13
     -8.98509947556741E-23  -4.44200231724837E-08  -4.44192413063940E-08  -2.39733261411464E-18
      5.42058924687078E-07
      0.00000000000000E+00  -4.64907956823408E-11   0.00000000000000E+00   4.88763772581786E-14   1.48535279905702E-22
      4.64907874023098E-08   4.64908362786872E-08  -6.01856437398543E-19  -3.46642263502374E-01  -3.46642263502249E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24650142309428E-10   0.00000000000000E+00  -1.24650142309428E-10
      2.77529942805201E-18  -1.37111247487715E-01  -1.22502980193573E-01   0.00000000000000E+00   5.60140695709337E-13
     -8.22618367639777E-23  -4.63667462770733E-08  -4.63661861363777E-08  -2.17344299065347E-18
      5.44058924687078E-07
      0.00000000000000E+00  -4.34350294307091E-11   0.00000000000000E+00  -6.86762174464039E-14   7.75501734213847E-23
      4.34351037719118E-08   4.34350350956944E-08  -5.76562606774865E-19  -3.60978121362167E-01  -3.60978121362039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28337694277163E-10   0.00000000000000E+00  -1.28337694277163E-10
      2.51862403949768E-18  -7.14803450295647E-02  -5.78359080360280E-02   0.00000000000000E+00   4.46666142367423E-13
     -6.14469480709889E-23  -4.33071440675595E-08  -4.33066974014172E-08  -1.94206143272282E-18
      5.46058924687078E-07
      0.00000000000000E+00  -3.02438290492781E-11   0.00000000000000E+00  -3.26121308891004E-13   3.01062981656988E-23
      3.02442072341600E-08   3.02438811128511E-08  -5.46673812532902E-19  -3.75080756574572E-01  -3.75080756574471E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00672497867713E-10   0.00000000000000E+00  -1.00672497867713E-10
      2.31727904376226E-18  -3.28133790875729E-02  -2.33162634141627E-02   0.00000000000000E+00   4.99140226856761E-13
     -2.77211337095815E-23  -3.01437077552103E-08  -3.01432086149834E-08  -1.77060523122936E-18
      5.48058924687078E-07
      0.00000000000000E+00  -1.90361076125808E-11   0.00000000000000E+00  -2.48761695689118E-13   1.28505790456804E-23
      1.90364027353140E-08   1.90361539736183E-08  -5.13167914037648E-19  -3.88960334522029E-01  -3.88960334521959E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.01184471263048E-11   0.00000000000000E+00  -7.01184471263048E-11
      2.17704214950965E-18  -1.67140046792280E-02  -1.07384412283208E-02   0.00000000000000E+00   3.24315294251177E-13
     -1.28367858693023E-23  -1.89663598417862E-08  -1.89660355264920E-08  -1.66387423547200E-18
      5.50058924687078E-07
      0.00000000000000E+00  -1.39709622003229E-11   0.00000000000000E+00  -1.24657598924780E-13   7.24749886391418E-24
      1.39711201210473E-08   1.39709954634484E-08  -4.79284131815857E-19  -4.02586785028270E-01  -4.02586785028213E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71375053855211E-11   0.00000000000000E+00  -5.71375053855211E-11
      2.06276713873861E-18  -1.07795255949559E-02  -6.39572260054893E-03   0.00000000000000E+00   1.70217580484875E-13
     -7.84501372444203E-24  -1.39140281756433E-08  -1.39138579580629E-08  -1.58348300692275E-18
      5.52058924687078E-07
      0.00000000000000E+00  -1.21350777482817E-11   0.00000000000000E+00  -4.49571427400658E-14   5.17342313168047E-24
      1.21350957048296E-08   1.21350507476869E-08  -4.45956366112415E-19  -4.15947111820145E-01  -4.15947111820091E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33154614725506E-11   0.00000000000000E+00  -5.33154614725506E-11
      1.95613621579350E-18  -8.52457952645746E-03  -4.71801566500217E-03   0.00000000000000E+00   7.95150378986323E-14
     -5.83083708895776E-24  -1.20818148012522E-08  -1.20817352862143E-08  -1.51017984968109E-18
      5.54058924687078E-07
      0.00000000000000E+00  -1.15131051879123E-11   0.00000000000000E+00  -1.50607560976354E-14   4.18852538767570E-24
      1.15131198464576E-08   1.15131047857016E-08  -4.13402953873493E-19  -4.29040202052511E-01  -4.29040202052458E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27102841592015E-11   0.00000000000000E+00  -5.27102841592015E-11
      1.85071564747510E-18  -7.51582708474108E-03  -3.90502522500734E-03   0.00000000000000E+00   4.45085618262387E-14
     -4.80830991064377E-24  -1.14604390101042E-08  -1.14603945015424E-08  -1.43731269360161E-18
      5.56058924687078E-07
      0.00000000000000E+00  -1.12924941291398E-11   0.00000000000000E+00  -5.18569407663762E-15   3.59764199587123E-24
      1.12924817043214E-08   1.12924765186273E-08  -3.81718148928351E-19  -4.41869308470100E-01  -4.41869308470047E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30925285565280E-11   0.00000000000000E+00  -5.30925285565280E-11
      1.74453059036204E-18  -6.95008495992042E-03  -3.40891437221966E-03   0.00000000000000E+00   3.13840939577195E-14
     -4.15521685090533E-24  -1.12394153741648E-08  -1.12393839900708E-08  -1.36281244143369E-18
      5.58058924687078E-07
      0.00000000000000E+00  -1.12001901682463E-11   0.00000000000000E+00  -2.04117257664925E-15   3.18810212176171E-24
      1.12001976260894E-08   1.12001955849168E-08  -3.50966014142907E-19  -4.54439015670255E-01  -4.54439015670201E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37247974742289E-11   0.00000000000000E+00  -5.37247974742289E-11
      1.63708099541359E-18  -6.57085510444733E-03  -3.05895670033008E-03   0.00000000000000E+00   2.57311005274558E-14
     -3.67534952060870E-24  -1.11464965185431E-08  -1.11464707874426E-08  -1.28611498127068E-18
      5.60058924687078E-07
      0.00000000000000E+00  -1.11518798364751E-11   0.00000000000000E+00  -9.76709527790691E-16   2.88234552406634E-24
      1.11518353727190E-08   1.11518343960095E-08  -3.21187201969689E-19  -4.66754188005549E-01  -4.66754188005495E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43646379263589E-11   0.00000000000000E+00  -5.43646379263589E-11
      1.52835171956087E-18  -6.29040819075000E-03  -2.79394684627573E-03   0.00000000000000E+00   2.25735762838982E-14
     -3.29988004495096E-24  -1.10974923316594E-08  -1.10974697580831E-08  -1.20716451759118E-18
      5.62058924687078E-07
      0.00000000000000E+00  -1.11214792284594E-11   0.00000000000000E+00  -5.49990948398871E-16   2.64452436696697E-24
      1.11214384860191E-08   1.11214379360281E-08  -2.92400156319473E-19  -4.78819519947101E-01  -4.78819519947046E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49260800138203E-11   0.00000000000000E+00  -5.49260800138203E-11
      1.41849955953323E-18  -6.07274355747312E-03  -2.58603461755023E-03   0.00000000000000E+00   2.03521894261167E-14
     -2.99765264549072E-24  -1.10665322082038E-08  -1.10665118560143E-08  -1.12609940321376E-18
      5.64058924687078E-07
      0.00000000000000E+00  -1.11002630941645E-11   0.00000000000000E+00  -3.37608788477198E-16   2.45445926680363E-24
      1.11002454349175E-08   1.11002450973088E-08  -2.64605424371093E-19  -4.90639054195816E-01  -4.90639054195760E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53738024661561E-11   0.00000000000000E+00  -5.53738024661561E-11
      1.30775195460092E-18  -5.89924104468089E-03  -2.41934904850193E-03   0.00000000000000E+00   1.85828794433406E-14
     -2.75035180947810E-24  -1.10448898777220E-08  -1.10448712948426E-08  -1.04314653022982E-18
      5.66058924687078E-07
      0.00000000000000E+00  -1.10846494888392E-11   0.00000000000000E+00  -2.12643187636898E-16   2.29937659072254E-24
      1.10846426723219E-08   1.10846424596788E-08  -2.37792985526909E-19  -5.02214866946098E-01  -5.02214866946042E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56865605918041E-11   0.00000000000000E+00  -5.56865605918041E-11
      1.19637883341731E-18  -5.75840568034380E-03  -2.28352692908952E-03   0.00000000000000E+00   1.70955088760614E-14
     -2.54545419448424E-24  -1.10289729945958E-08  -1.10289558990870E-08  -9.58585847890399E-19
      5.68058924687078E-07
      0.00000000000000E+00  -1.10727096730022E-11   0.00000000000000E+00  -1.33589956405034E-16   2.17070181338425E-24
      1.10727206312549E-08   1.10727204976649E-08  -2.11957956428761E-19  -5.13541855387491E-01  -5.13541855387435E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58261678988133E-11   0.00000000000000E+00  -5.58261678988133E-11
      1.08472649761968E-18  -5.64244685991156E-03  -2.17136722452724E-03   0.00000000000000E+00   1.58075485395984E-14
     -2.37390218173670E-24  -1.10169101373147E-08  -1.10168943297661E-08  -8.72768541190920E-19
      5.70058924687079E-07
      0.00000000000000E+00  -1.10631578203326E-11   0.00000000000000E+00  -8.67371942495821E-17   2.06260464456244E-24
      1.10631382961795E-08   1.10631382094423E-08  -1.87149646618966E-19  -5.24586796344919E-01  -5.24586796344863E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56499086897164E-11   0.00000000000000E+00  -5.56499086897164E-11
      9.73426680240249E-19  -5.54594463443534E-03  -2.07782755127698E-03   0.00000000000000E+00   1.46425712556193E-14
     -2.22922564062073E-24  -1.10075029433238E-08  -1.10074883007526E-08  -7.86277033621283E-19
      5.72058924687079E-07
      0.00000000000000E+00  -1.10546162597723E-11   0.00000000000000E+00  -7.08292734949940E-17   1.97128174306531E-24
      1.10546483711257E-08   1.10546483002965E-08  -1.63556897900434E-19  -5.35248740054323E-01  -5.35248740054268E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47999844855186E-11   0.00000000000000E+00  -5.47999844855186E-11
      8.63826711269212E-19  -5.46523187955350E-03  -1.99952111532372E-03   0.00000000000000E+00   1.34946067634747E-14
     -2.10713154848704E-24  -1.09998618104177E-08  -1.09998483158109E-08  -7.00269813368778E-19
      5.74058924687079E-07
      0.00000000000000E+00  -1.10462583886865E-11   0.00000000000000E+00  -8.05492790270539E-17   1.89431113605158E-24
      1.10462516447639E-08   1.10462515642146E-08  -1.41503487610041E-19  -5.45357700914181E-01  -5.45357700914128E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28863831190316E-11   0.00000000000000E+00  -5.28863831190316E-11
      7.58053945031148E-19  -5.39783650269455E-03  -1.93416776970152E-03   0.00000000000000E+00   1.22793849243753E-14
     -2.00471993733622E-24  -1.09933774604805E-08  -1.09933651810956E-08  -6.16550457421107E-19
      5.76058924687079E-07
      0.00000000000000E+00  -1.10371657597029E-11   0.00000000000000E+00  -1.10909185129573E-16   1.83015240363696E-24
      1.10371781663630E-08   1.10371780554538E-08  -1.21428981133106E-19  -5.54681028983755E-01  -5.54681028983706E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95359217969160E-11   0.00000000000000E+00  -4.95359217969160E-11
      6.58982101437317E-19  -5.34208514814275E-03  -1.88021897548741E-03   0.00000000000000E+00   1.09264409310396E-14
     -1.92004227975849E-24  -1.09876530600978E-08  -1.09876421336569E-08  -5.37553120304209E-19
      5.78058924687079E-07
      0.00000000000000E+00  -1.10266036149240E-11   0.00000000000000E+00  -1.64045863031823E-16   1.77799850894941E-24
      1.10266063705789E-08   1.10266062065331E-08  -1.03936813515441E-19  -5.62899954541343E-01  -5.62899954541298E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.42430821472658E-11   0.00000000000000E+00  -4.42430821472658E-11
      5.70495937142785E-19  -5.29698411848900E-03  -1.83678067567876E-03   0.00000000000000E+00   9.35186926268715E-15
     -1.85211519872202E-24  -1.09823724762551E-08  -1.09823631243858E-08  -4.66559123627343E-19
      5.80058924687079E-07
      0.00000000000000E+00  -1.10135616622406E-11   0.00000000000000E+00  -2.44755284364510E-16   1.73777039062672E-24
      1.10135663604321E-08   1.10135661156768E-08  -8.98474702535625E-20  -5.69584256465122E-01  -5.69584256465085E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.63627116384099E-11   0.00000000000000E+00  -3.63627116384099E-11
      4.97770513865965E-19  -5.26219886055868E-03  -1.80362067561619E-03   0.00000000000000E+00   7.44380732747298E-15
     -1.80096919341478E-24  -1.09772108478457E-08  -1.09772034040384E-08  -4.07923043612403E-19
      5.82058924687079E-07
      0.00000000000000E+00  -1.09970296095432E-11   0.00000000000000E+00  -3.55730035957461E-16   1.71011146267643E-24
      1.09970301075292E-08   1.09970297517992E-08  -8.02052789238975E-20  -5.74191433309161E-01  -5.74191433309135E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52570606791368E-11   0.00000000000000E+00  -2.52570606791368E-11
      4.47256392507691E-19  -5.23803697227898E-03  -1.78116956033320E-03   0.00000000000000E+00   5.08705896051953E-15
     -1.76765575510305E-24  -1.09717777781790E-08  -1.09717726911200E-08  -3.67051113583794E-19
      5.84058924687079E-07
      0.00000000000000E+00  -1.09760890094599E-11   0.00000000000000E+00  -4.94135971722672E-16   1.69646028303481E-24
      1.09761301258798E-08   1.09761296317438E-08  -7.62491952379273E-20  -5.76088701033694E-01  -5.76088701033683E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04518628913096E-11   0.00000000000000E+00  -1.04518628913096E-11
      4.26352666725072E-19  -5.22555379887206E-03  -1.77060659462524E-03   0.00000000000000E+00   2.17098591500534E-15
     -1.75441317015760E-24  -1.09656799398384E-08  -1.09656777688525E-08  -3.50103471487146E-19
      5.86058924687079E-07
      0.00000000000000E+00  -1.09501887935674E-11   0.00000000000000E+00  -6.57055469081821E-16   1.69928458593081E-24
      1.09501647601994E-08   1.09501641031439E-08  -7.93791700211097E-20  -5.74584910854214E-01  -5.74584910854223E-01
      0.00000000000000E+00   0.00000000000000E+00   8.26562068868955E-12   0.00000000000000E+00   8.26562068868955E-12
      4.42883908102451E-19  -5.22675931099633E-03  -1.77409582625339E-03   0.00000000000000E+00  -1.41666724372145E-15
     -1.76515884485794E-24  -1.09584283071653E-08  -1.09584297238326E-08  -3.63504738081341E-19
      5.88058924687079E-07
      0.00000000000000E+00  -1.09184105144936E-11   0.00000000000000E+00  -9.33308819540297E-16   1.72267467069242E-24
      1.09184169771185E-08   1.09184160438097E-08  -9.11561205564518E-20  -5.68955702046107E-01  -5.68955702046138E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08296568284061E-11   0.00000000000000E+00   3.08296568284061E-11
      5.04543221759263E-19  -5.24516415136316E-03  -1.79539457109694E-03   0.00000000000000E+00  -5.73396152191090E-15
     -1.80668899889954E-24  -1.09492399666766E-08  -1.09492457006381E-08  -4.13387101202812E-19
      5.90058924687079E-07
      0.00000000000000E+00  -1.08797438801292E-11   0.00000000000000E+00  -1.07538601821079E-15   1.77362500581913E-24
      1.08797543184100E-08   1.08797532430240E-08  -1.13359882990188E-19  -5.58453087741386E-01  -5.58453087741443E-01
      0.00000000000000E+00   0.00000000000000E+00   5.69042548923438E-11   0.00000000000000E+00   5.69042548923438E-11
      6.18351731543951E-19  -5.28708422830029E-03  -1.84128147517115E-03   0.00000000000000E+00  -1.12727829873581E-14
     -1.89138995134937E-24  -1.09366462251333E-08  -1.09366574979163E-08  -5.04991848553763E-19
      5.92058924687079E-07
      0.00000000000000E+00  -1.08318009273069E-11   0.00000000000000E+00  -6.92130508272531E-15   1.86471060639390E-24
      1.08318081289328E-08   1.08318012076277E-08  -1.48105237188024E-19  -5.42305321662437E-01  -5.42305321662523E-01
      0.00000000000000E+00   0.00000000000000E+00   8.58041795270566E-11   0.00000000000000E+00   8.58041795270566E-11
      7.89960090598064E-19  -5.36468158084220E-03  -1.92488080720405E-03   0.00000000000000E+00  -1.26340980592524E-14
     -2.04363680224962E-24  -1.09175927530567E-08  -1.09176053871547E-08  -6.41854853410042E-19
      5.94058924687079E-07
      0.00000000000000E+00  -1.07688872823197E-11   0.00000000000000E+00  -1.88472193851433E-15   2.01982362919097E-24
      1.07689211991116E-08   1.07689193143897E-08  -1.97991966631002E-19  -5.19723408924883E-01  -5.19723408924999E-01
      0.00000000000000E+00   0.00000000000000E+00   1.16228374327789E-10   0.00000000000000E+00   1.16228374327789E-10
      1.02241683925364E-18  -5.50347776927552E-03  -2.07390676342100E-03   0.00000000000000E+00  -2.72103290333533E-14
     -2.31681995538425E-24  -1.08851204783884E-08  -1.08851476887175E-08  -8.24424872622639E-19
      5.96058924687079E-07
      0.00000000000000E+00  -1.06757567187913E-11   0.00000000000000E+00  -2.72616010530499E-15   2.28658341976542E-24
      1.06757131686688E-08   1.06757104425087E-08  -2.66208546225312E-19  -4.89931549807853E-01  -4.89931549807998E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45792419328689E-10   0.00000000000000E+00   1.45792419328689E-10
      1.31400167791102E-18  -5.76320574709953E-03  -2.35369012286789E-03   0.00000000000000E+00  -3.97807517236062E-14
     -2.84735511390859E-24  -1.08214630810856E-08  -1.08215028618373E-08  -1.04779313168571E-18
      5.98058924687079E-07
      0.00000000000000E+00  -1.05034559917900E-11   0.00000000000000E+00  -1.36031095820375E-14   2.75745767240235E-24
      1.05034526750196E-08   1.05034390719100E-08  -3.56283148097893E-19  -4.52226720673892E-01  -4.52226720674062E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70668684437804E-10   0.00000000000000E+00   1.70668684437804E-10
      1.65533904678663E-18  -6.30512057677958E-03  -2.94204615033392E-03   0.00000000000000E+00  -4.93700188487818E-14
     -4.06627688619828E-24  -1.06740583863289E-08  -1.06741077563478E-08  -1.29905589868873E-18
      6.00058924687079E-07
      0.00000000000000E+00  -1.00738063111332E-11   0.00000000000000E+00  -1.15484081865541E-14   3.52627586923749E-24
      1.00737627026419E-08   1.00737511542337E-08  -4.70476533678163E-19  -4.06047410388720E-01  -4.06047410388907E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86832140954813E-10   0.00000000000000E+00   1.86832140954813E-10
      2.02900332869625E-18  -7.64369765674322E-03  -4.41092120249819E-03   0.00000000000000E+00  -8.58773603929071E-14
     -7.69463793607826E-24  -1.02604974178281E-08  -1.02605832951885E-08  -1.55852679501809E-18
      6.02058924687079E-07
      0.00000000000000E+00  -8.72791353209406E-12   0.00000000000000E+00  -3.46502704468542E-14   3.73364956935101E-24
      8.72795614321524E-09   8.72792149294479E-09  -6.05028518698609E-19  -3.51071784094443E-01  -3.51071784094641E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97239409821992E-10   0.00000000000000E+00   1.97239409821992E-10
      2.42348214834024E-18  -1.15644547164011E-02  -8.75243637936626E-03   0.00000000000000E+00  -1.25744110434823E-13
     -2.08448310298027E-23  -8.92503515865632E-09  -8.92516090276678E-09  -1.81845362964163E-18
      6.04058924687079E-07
      0.00000000000000E+00  -5.30926872375550E-12   0.00000000000000E+00  -8.64380366713203E-14  -3.53423045953569E-24
      5.30934937185715E-09   5.30926293382047E-09  -7.47203970962667E-19  -2.87609932725580E-01  -2.87609932725799E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19204210376318E-10   0.00000000000000E+00   2.19204210376318E-10
      2.86189056909288E-18  -2.20432924476072E-02  -2.03014680483229E-02   0.00000000000000E+00  -1.85690929285171E-13
     -5.40662472080813E-23  -5.52828145326745E-09  -5.52846714419679E-09  -2.11468659813021E-18
      6.06058924687079E-07
      0.00000000000000E+00  -1.74036592534542E-12   0.00000000000000E+00  -9.09437398335741E-14  -2.34078587052915E-23
      1.74045768664782E-09   1.74036674290796E-09  -8.90782382481455E-19  -2.17543777034140E-01  -2.17543777034382E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42160956566981E-10   0.00000000000000E+00   2.42160956566981E-10
      3.34621248222684E-18  -3.92403378154087E-02  -3.86157183540572E-02   0.00000000000000E+00  -3.35983018754424E-13
     -8.05546806603924E-23  -1.98219171645611E-09  -1.98252769947494E-09  -2.45543009974538E-18
      6.07058924687079E-07
      0.00000000000000E+00  -8.10989029542461E-13   0.00000000000000E+00  -4.96465265328703E-14  -3.24924260975600E-23
      8.11082058729840E-10   8.11032412203274E-10  -9.62993222815983E-19  -1.81441053606364E-01  -1.81441053606606E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41931091922218E-10   0.00000000000000E+00   2.41931091922218E-10
      3.58814357414905E-18  -4.86689322286629E-02  -4.83371845358754E-02   0.00000000000000E+00  -5.06437179858279E-13
     -8.59170384009635E-23  -1.05245706694555E-09  -1.05296350412549E-09  -2.62515035133307E-18
      6.08408924687079E-07
      0.00000000000000E+00  -2.17488337707423E-13   0.00000000000000E+00  -2.59046601611816E-14  -4.04513438458463E-23
      2.17519939977325E-10   2.17494035317123E-10  -1.06252255158466E-18  -1.32085902980046E-01  -1.32085902980283E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37021386334826E-10   0.00000000000000E+00   2.37021386334826E-10
      3.90812244570107E-18  -6.20189464320401E-02  -6.18757469822350E-02   0.00000000000000E+00  -6.57708457086261E-13
     -9.07832427700387E-23  -4.53857713194773E-10  -4.54515421651950E-10  -2.84559989411641E-18
      6.10231424687079E-07
      0.00000000000000E+00   9.73554214399784E-15   0.00000000000000E+00  -1.07398249777059E-14  -4.47580890279851E-23
     -9.75184313726123E-12  -9.76258296228370E-12  -1.18481190923597E-18  -7.20837476571684E-02  -7.20837476573747E-02
      0.00000000000000E+00   0.00000000000000E+00   2.06343318306849E-10   0.00000000000000E+00   2.06343318306849E-10
      4.28418314331530E-18  -8.01730474876441E-02  -8.01111128760914E-02   0.00000000000000E+00  -7.92298538815549E-13
     -9.72358592788270E-23  -1.95788436805652E-10  -1.96580735344565E-10  -3.09937123407933E-18
      6.12231424687079E-07
      0.00000000000000E+00   2.33285632507118E-14   0.00000000000000E+00  -3.09513071804300E-15  -4.58805557162746E-23
     -2.33301766691133E-11  -2.33332717998773E-11  -1.26580176453811E-18  -3.30926165054431E-02  -3.30926165055817E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38579059528647E-10   0.00000000000000E+00   1.38579059528647E-10
      4.56134126237259E-18  -9.98558259737839E-02  -9.98195168482148E-02   0.00000000000000E+00  -6.43051097304102E-13
     -1.02215272016928E-22  -1.14602736631363E-10  -1.15245787728770E-10  -3.29553949783448E-18
      6.14231424687079E-07
      0.00000000000000E+00   2.57165264181075E-15   0.00000000000000E+00  -2.94344345165835E-16  -4.59693486561283E-23
     -2.52640754818709E-12  -2.52670189257822E-12  -1.30183611449215E-18  -1.68192862544774E-02  -1.68192862545612E-02
      0.00000000000000E+00   0.00000000000000E+00   8.38566295335077E-11   0.00000000000000E+00   8.38566295335077E-11
      4.72905452143961E-18  -1.19209635786565E-01  -1.19184012337807E-01   0.00000000000000E+00  -4.10887611677338E-13
     -1.04986160937329E-22  -8.09190400291465E-11  -8.13299276409288E-11  -3.42721840694746E-18
      6.16231424687079E-07
      0.00000000000000E+00  -1.36848658439215E-14   0.00000000000000E+00   4.29388079466892E-16  -4.54602410384282E-23
      1.36765804419612E-11   1.36770098299952E-11  -1.31600650534049E-18  -1.08180367180117E-02  -1.08180367180663E-02
      0.00000000000000E+00   0.00000000000000E+00   5.45986583803089E-11   0.00000000000000E+00   5.45986583803089E-11
      4.83825183820023E-18  -1.38198352134718E-01  -1.38176841670537E-01   0.00000000000000E+00  -3.00713281918566E-13
     -1.06865934615858E-22  -6.79749549282790E-11  -6.82756682103044E-11  -3.52224533285974E-18
      6.18231424687079E-07
      0.00000000000000E+00  -2.47062343088247E-14   0.00000000000000E+00   4.97431458364958E-16  -4.42048912779865E-23
      2.46940477476738E-11   2.46945451790880E-11  -1.32093472560433E-18  -8.54029018920486E-03  -8.54029018924446E-03
      0.00000000000000E+00   0.00000000000000E+00   3.95956768938827E-11   0.00000000000000E+00   3.95956768938827E-11
      4.91744319198799E-18  -1.56810089567783E-01  -1.56789834853333E-01   0.00000000000000E+00  -2.72049376793567E-13
     -1.08487662492463E-22  -6.40181726960692E-11  -6.42902220729713E-11  -3.59650846638366E-18
      6.20231424687080E-07
      0.00000000000000E+00  -3.26967264458795E-14   0.00000000000000E+00   4.12915986973449E-16  -4.18490640525099E-23
      3.26785407522216E-11   3.26789536681667E-11  -1.32200390347661E-18  -7.52376714960231E-03  -7.52376714963353E-03
      0.00000000000000E+00   0.00000000000000E+00   3.12224907365070E-11   0.00000000000000E+00   3.12224907365070E-11
      4.97988817346101E-18  -1.75044843867057E-01  -1.75024711742672E-01   0.00000000000000E+00  -2.72853176014894E-13
     -1.10054540936783E-22  -6.36285912285484E-11  -6.39014444046733E-11  -3.65788426998440E-18
      6.22231424687080E-07
      0.00000000000000E+00  -3.89421685759913E-14   0.00000000000000E+00   3.21716620687649E-16  -3.79726487923964E-23
      3.89210325373981E-11   3.89213542539808E-11  -1.32142395850499E-18  -6.95504383681162E-03  -6.95504383683767E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60408500313714E-11   0.00000000000000E+00   2.60408500313714E-11
      5.03196987352375E-18  -1.92907781936611E-01  -1.92887315724269E-01   0.00000000000000E+00  -2.80533755843934E-13
     -1.11614211003673E-22  -6.46816705293969E-11  -6.49622042853524E-11  -3.71054591501876E-18
      6.24231424687080E-07
      0.00000000000000E+00  -4.40854738596128E-14   0.00000000000000E+00   2.54350876201814E-16  -3.21571103094176E-23
      4.41251162775278E-11   4.41253706283718E-11  -1.32013721295031E-18  -6.57439204957867E-03  -6.57439204960125E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25821612323297E-11   0.00000000000000E+00   2.25821612323297E-11
      5.07713419598841E-18  -2.10406090186603E-01  -2.10385074221170E-01   0.00000000000000E+00  -2.87987404510933E-13
     -1.13170370626733E-22  -6.64195444560774E-11  -6.67075318607015E-11  -3.75699698303810E-18
      6.26231424687080E-07
      0.00000000000000E+00  -4.86777107199892E-14   0.00000000000000E+00   2.09432129635220E-16  -2.40711729959816E-23
      4.86998184860976E-11   4.87000279182032E-11  -1.31856836896799E-18  -6.29310421969878E-03  -6.29310421971895E-03
      0.00000000000000E+00   0.00000000000000E+00   2.01632358041733E-11   0.00000000000000E+00   2.01632358041733E-11
      5.11746066759676E-18  -2.27547468753567E-01  -2.27525773748075E-01   0.00000000000000E+00  -2.93661553976877E-13
     -1.14717867100634E-22  -6.85696021682846E-11  -6.88632637223762E-11  -3.79889229862876E-18
      6.28231424687080E-07
      0.00000000000000E+00  -5.29025686315354E-14   0.00000000000000E+00   1.80930745319808E-16  -1.35927849698338E-23
      5.28926823995646E-11   5.28928633302963E-11  -1.31691478573003E-18  -6.07486959725008E-03  -6.07486959726849E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84172516889031E-11   0.00000000000000E+00   1.84172516889031E-11
      5.15429517097456E-18  -2.44339375776719E-01  -2.44316910026442E-01   0.00000000000000E+00  -2.97649215030020E-13
     -1.16251794957033E-22  -7.10124658040540E-11  -7.13101150192003E-11  -3.83738038524454E-18
      6.30231424687080E-07
      0.00000000000000E+00  -5.68518923314591E-14   0.00000000000000E+00   1.62892631718643E-16  -9.30593662583826E-25
      5.68519673649416E-11   5.68521302575724E-11  -1.31526663354510E-18  -5.90095300486710E-03  -5.90095300488422E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71214755790741E-11   0.00000000000000E+00   1.71214755790741E-11
      5.18853812213271E-18  -2.60788790261084E-01  -2.60765485526597E-01   0.00000000000000E+00  -3.00426690280557E-13
     -1.17769290506318E-22  -7.36731791462469E-11  -7.39736058366452E-11  -3.87327148858761E-18
      6.32231424687080E-07
      0.00000000000000E+00  -6.07093712941752E-14   0.00000000000000E+00   1.51326783157850E-16   1.30024343857642E-23
      6.06653838234683E-11   6.06655351502644E-11  -1.31366173044652E-18  -5.75980520437673E-03  -5.75980520439286E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61308195342576E-11   0.00000000000000E+00   1.61308195342576E-11
      5.22079976120123E-18  -2.76902562379249E-01  -2.76878368498820E-01   0.00000000000000E+00  -3.02498976634072E-13
     -1.19269601357593E-22  -7.64938557077691E-11  -7.67963546845225E-11  -3.90713803075471E-18
      6.34231424687080E-07
      0.00000000000000E+00  -6.43831607824763E-14   0.00000000000000E+00   1.43769817378392E-16   2.70554643411030E-23
      6.43868390186094E-11   6.43869827884539E-11  -1.31211249436172E-18  -5.64360241055709E-03  -5.64360241057244E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53478983824556E-11   0.00000000000000E+00   1.53478983824556E-11
      5.25149555796614E-18  -2.92688048569338E-01  -2.92662929078857E-01   0.00000000000000E+00  -3.04311804360214E-13
     -1.20753540554064E-22  -7.94305693664278E-11  -7.97348811709087E-11  -3.93938306360442E-18
      6.36231424687080E-07
      0.00000000000000E+00  -6.80569502707773E-14   0.00000000000000E+00   1.38738708647640E-16   4.05539219969874E-23
      6.80515125806393E-11   6.80516513193884E-11  -1.31061957517404E-18  -5.54689671855181E-03  -5.54689671856652E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47054393751154E-11   0.00000000000000E+00   1.47054393751154E-11
      5.28090643671637E-18  -3.08152250093333E-01  -3.08126178639404E-01   0.00000000000000E+00  -3.06199777541094E-13
     -1.22223159646675E-22  -8.24508909168406E-11  -8.27570906945039E-11  -3.97028686154233E-18
      6.38231424687080E-07
      0.00000000000000E+00  -7.16388950218709E-14   0.00000000000000E+00   1.35308223832789E-16   5.29591620485179E-23
      7.16823859150792E-11   7.16825212233560E-11  -1.30917882240921E-18  -5.46599741681711E-03  -5.46599741683127E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41536932596498E-11   0.00000000000000E+00   1.41536932596498E-11
      5.30921382323567E-18  -3.23297819410344E-01  -3.23270778072734E-01   0.00000000000000E+00  -3.08309823446224E-13
     -1.23680790898118E-22  -8.55279046594362E-11  -8.58362144830061E-11  -4.00003500082646E-18
      6.40231424687080E-07
      0.00000000000000E+00  -7.53126845101719E-14   0.00000000000000E+00   1.32848578956523E-16   6.39347702383567E-23
      7.52930200224127E-11   7.52931528710556E-11  -1.30778499198392E-18  -5.39841906511365E-03  -5.39841906512730E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36560338932652E-11   0.00000000000000E+00   1.36560338932652E-11
      5.33652589102220E-18  -3.38121292013813E-01  -3.38093270139025E-01   0.00000000000000E+00  -3.10661610330937E-13
     -1.25128438983740E-22  -8.86385251538654E-11  -8.89491867643215E-11  -4.02874089903828E-18
      6.42231424687080E-07
      0.00000000000000E+00  -7.88946292612655E-14   0.00000000000000E+00   1.31057741617099E-16   7.33599941200379E-23
      7.88933029399664E-11   7.88934339977814E-11  -1.30643241327479E-18  -5.34247754454064E-03  -5.34247754455384E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31977081442554E-11   0.00000000000000E+00   1.31977081442554E-11
      5.36292130731071E-18  -3.52628005012847E-01  -3.52598993480307E-01   0.00000000000000E+00  -3.13606699869779E-13
     -1.26569459419869E-22  -9.17775354420405E-11  -9.20911421420369E-11  -4.05648889403592E-18
      6.44231424687080E-07
      0.00000000000000E+00  -8.24765740123590E-14   0.00000000000000E+00   1.30021338029866E-16   8.12939169730895E-23
      8.24976214008766E-11   8.24977514222959E-11  -1.30511338795536E-18  -5.29716581877618E-03  -5.29716581878897E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27915794243743E-11   0.00000000000000E+00   1.27915794243743E-11
      5.38850446615946E-18  -3.66858677946367E-01  -3.66828659050780E-01   0.00000000000000E+00  -3.18224023301072E-13
     -1.28011749194307E-22  -9.49711068232413E-11  -9.52893308466704E-11  -4.08339107820410E-18
      6.46231424687080E-07
      0.00000000000000E+00  -8.61503635006601E-14   0.00000000000000E+00   1.29785344966142E-16   8.79074008460646E-23
      8.61231836311322E-11   8.61233134165651E-11  -1.30381899729506E-18  -5.26213427797129E-03  -5.26213427798373E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24421060535989E-11   0.00000000000000E+00   1.24421060535989E-11
      5.41338867826666E-18  -3.80872373637194E-01  -3.80841322848559E-01   0.00000000000000E+00  -3.25159008597385E-13
     -1.29465477836081E-22  -9.82402604614373E-11  -9.85654194701641E-11  -4.10956968097160E-18
      6.48231424687080E-07
      0.00000000000000E+00  -8.97323082517536E-14   0.00000000000000E+00   1.29586733074136E-16   9.34017204876238E-23
      8.97669919878798E-11   8.97671215747063E-11  -1.30254558287777E-18  -5.23767135287506E-03  -5.23767135288714E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20829017161126E-11   0.00000000000000E+00   1.20829017161126E-11
      5.43755448169888E-18  -3.94649629535317E-01  -3.94617544184858E-01   0.00000000000000E+00  -3.32120124776829E-13
     -1.30929927494847E-22  -1.01517903165910E-10  -1.01850023290818E-10  -4.13500889882112E-18
      6.50231424687080E-07
      0.00000000000000E+00  -9.34060977400547E-14   0.00000000000000E+00   1.29355151292408E-16   9.79815242654138E-23
      9.34252095894146E-11   9.34253389446639E-11  -1.30128976774321E-18  -5.22480627956709E-03  -5.22480627957879E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17034899168065E-11   0.00000000000000E+00   1.17034899168065E-11
      5.46096146153250E-18  -4.08166241342577E-01  -4.08133123271207E-01   0.00000000000000E+00  -3.38970130670545E-13
     -1.32403655995645E-22  -1.04789858730668E-10  -1.05128828861471E-10  -4.15967169378928E-18
      6.52231424687080E-07
      0.00000000000000E+00  -9.70798872283558E-14   0.00000000000000E+00   1.29478855689493E-16   1.01836176867351E-22
      9.71001985297629E-11   9.71003280087204E-11  -1.30004594152602E-18  -5.22550885862208E-03  -5.22550885863339E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13125129141611E-11   0.00000000000000E+00   1.13125129141611E-11
      5.48358648736082E-18  -4.21415395241372E-01  -4.21381242823263E-01   0.00000000000000E+00  -3.46183753216251E-13
     -1.33887041567399E-22  -1.08066657169532E-10  -1.08412840922882E-10  -4.18354054583480E-18
      6.54231424687080E-07
      0.00000000000000E+00  -1.00845521453864E-13   0.00000000000000E+00   1.30133511806944E-16   1.05129316037890E-22
      1.00800793373749E-10   1.00800923507366E-10  -1.29880517314842E-18  -5.24321672313928E-03  -5.24321672315019E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09128918506007E-11   0.00000000000000E+00   1.09128918506007E-11
      5.50541227106202E-18  -4.34398380038278E-01  -4.34363187944680E-01   0.00000000000000E+00  -3.53877102178372E-13
     -1.35380662912211E-22  -1.11359938255653E-10  -1.11713815357967E-10  -4.20660709791359E-18
      6.56231424687080E-07
      0.00000000000000E+00  -1.04519310942165E-13   0.00000000000000E+00   1.31170203882569E-16   1.07999931544130E-22
      1.04546933106744E-10   1.04547064277056E-10  -1.29755249008773E-18  -5.28409861689180E-03  -5.28409861690231E-03
      0.00000000000000E+00   0.00000000000000E+00   1.05021751491402E-11   0.00000000000000E+00   1.05021751491402E-11
      5.52641662136030E-18  -4.47119208481885E-01  -4.47082965875827E-01   0.00000000000000E+00  -3.61921320549243E-13
     -1.36884184171822E-22  -1.14687318105510E-10  -1.15049239426196E-10  -4.22886413127257E-18
      6.58231424687080E-07
      0.00000000000000E+00  -1.08376789904882E-13   0.00000000000000E+00   1.22632570734781E-16   1.10573122733282E-22
      1.08381909022329E-10   1.08382031655011E-10  -1.29626032230706E-18  -5.35999822774720E-03  -5.35999822775727E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00714730718032E-11   0.00000000000000E+00   1.00714730718032E-11
      5.54655956750390E-18  -4.59582655649995E-01  -4.59545340858118E-01   0.00000000000000E+00  -3.69968145645405E-13
     -1.38395570637161E-22  -1.18083536581030E-10  -1.18453504726814E-10  -4.25029924519685E-18
      6.60231424687080E-07
      0.00000000000000E+00  -1.12417958342013E-13   0.00000000000000E+00   1.44292332952900E-16   1.12983903763654E-22
      1.12403274881997E-10   1.12403419174443E-10  -1.29487239636017E-18  -5.49568061089680E-03  -5.49568061090640E-03
      0.00000000000000E+00   0.00000000000000E+00   9.59823422823308E-12   0.00000000000000E+00   9.59823422823308E-12
      5.56575603596037E-18  -4.71793561246667E-01  -4.71755128969389E-01   0.00000000000000E+00  -3.77434043646898E-13
     -1.39910050384254E-22  -1.21624219358888E-10  -1.22001653402675E-10  -4.27088363960020E-18
      6.62231424687080E-07
      0.00000000000000E+00  -1.16826505727974E-13   0.00000000000000E+00   1.63957612759433E-16   1.15438515448453E-22
      1.16850770117455E-10   1.16850934075183E-10  -1.29325950823522E-18  -5.74885032043288E-03  -5.74885032044190E-03
      0.00000000000000E+00   0.00000000000000E+00   9.02281282373988E-12   0.00000000000000E+00   9.02281282373988E-12
      5.58380166160785E-18  -4.83756430901345E-01  -4.83716779107584E-01   0.00000000000000E+00  -3.82712919174940E-13
     -1.41416704564212E-22  -1.25491033979606E-10  -1.25873746898923E-10  -4.29054215337263E-18
      6.64231424687081E-07
      0.00000000000000E+00  -1.22429034697633E-13   0.00000000000000E+00   2.15256371176470E-16   1.18402393637267E-22
      1.22399299582294E-10   1.22399514838784E-10  -1.29107820963515E-18  -6.27439575460889E-03  -6.27439575461705E-03
      0.00000000000000E+00   0.00000000000000E+00   8.16698054808491E-12   0.00000000000000E+00   8.16698054808491E-12
      5.60013562270402E-18  -4.95474759778638E-01  -4.95433629977917E-01   0.00000000000000E+00  -3.81558953893624E-13
     -1.42889015306965E-22  -1.30184936432833E-10  -1.30566495386869E-10  -4.30905741306887E-18
      6.66231424687081E-07
      0.00000000000000E+00  -1.31337974206763E-13   0.00000000000000E+00   3.64863451758610E-16   1.23321026837387E-22
      1.31322583831884E-10   1.31322948695459E-10  -1.28724469306341E-18  -7.56368428198061E-03  -7.56368428198702E-03
      0.00000000000000E+00   0.00000000000000E+00   6.41129483572379E-12   0.00000000000000E+00   6.41129483572379E-12
      5.61295821237547E-18  -5.06948775798052E-01  -5.06905388380525E-01   0.00000000000000E+00  -3.59374720619396E-13
     -1.44247907645257E-22  -1.37374868810420E-10  -1.37734243531184E-10  -4.32571351931206E-18
      6.68231424687081E-07
      0.00000000000000E+00  -1.52462263764494E-13   0.00000000000000E+00   8.84520310215531E-16   1.35396468701512E-22
      1.52459050231628E-10   1.52459934752074E-10  -1.27797131700508E-18  -1.13263067413672E-02  -1.13263067413687E-02
      0.00000000000000E+00   0.00000000000000E+00   1.49008852404125E-12   0.00000000000000E+00   1.49008852404125E-12
      5.61593838942355E-18  -5.18165940854079E-01  -5.18117445703813E-01   0.00000000000000E+00  -2.63389505976791E-13
     -1.45226122871671E-22  -1.53686633769992E-10  -1.53950023276114E-10  -4.33796707241847E-18
      6.70231424687081E-07
      0.00000000000000E+00  -2.13447169270292E-13   0.00000000000000E+00   2.40428762520915E-15   1.66895463649025E-22
      2.13408121669100E-10   2.13410525956892E-10  -1.25416279765403E-18  -2.15084082712831E-02  -2.15084082712720E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.10839159535686E-11   0.00000000000000E+00  -1.10839159535686E-11
      5.59377055751641E-18  -5.29069094022646E-01  -5.29005360392848E-01   0.00000000000000E+00   1.39054157364173E-15
     -1.45218838724570E-22  -2.02328000544751E-10  -2.02326610003323E-10  -4.33960775986238E-18
      6.72231424687081E-07
      0.00000000000000E+00  -3.47999709279319E-13   0.00000000000000E+00   4.68325153613865E-15   2.14460808448932E-22
      3.47964635269662E-10   3.47969318521413E-10  -1.21338385729625E-18  -3.85396795190480E-02  -3.85396795190218E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.61127033616526E-11   0.00000000000000E+00  -2.61127033616526E-11
      5.54154515079311E-18  -5.39526529581610E-01  -5.39425143457544E-01   0.00000000000000E+00   2.72446883089270E-13
     -1.44199055886809E-22  -3.22129062042707E-10  -3.21856615159761E-10  -4.32816129349686E-18
      6.74231424687081E-07
      0.00000000000000E+00  -5.81193497049229E-13   0.00000000000000E+00   7.14222575071859E-15   2.54653636461410E-22
      5.81170777632064E-10   5.81177919858070E-10  -1.16464974841279E-18  -5.81400182213319E-02  -5.81400182212970E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.48623546708999E-11   0.00000000000000E+00  -3.48623546708999E-11
      5.47182044145131E-18  -5.49343616725933E-01  -5.49171524024016E-01   0.00000000000000E+00   3.48549614922065E-13
     -1.42866628245708E-22  -5.46664114801948E-10  -5.46315565187169E-10  -4.30717069303852E-18
      6.76231424687081E-07
      0.00000000000000E+00  -9.53440216951335E-13   0.00000000000000E+00   1.04408144599528E-14   2.81649420669195E-22
      9.53457206244120E-10   9.53467647058862E-10  -1.11462379003841E-18  -7.80685811106913E-02  -7.80685811106514E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.98700471397543E-11   0.00000000000000E+00  -3.98700471397543E-11
      5.39208034717180E-18  -5.58256050192116E-01  -5.57968259498943E-01   0.00000000000000E+00   3.33385244733167E-13
     -1.41560788912344E-22  -9.13930985163698E-10  -9.13597599919107E-10  -4.27745655713338E-18
      6.78231424687081E-07
      0.00000000000000E+00  -1.52131622710547E-12   0.00000000000000E+00   1.51357422048502E-14   3.01299785495231E-22
      1.52128875197376E-09   1.52130388771626E-09  -1.06640167128381E-18  -9.77804372848767E-02  -9.77804372848324E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.41777009077397E-11   0.00000000000000E+00  -4.41777009077397E-11
      5.30372494535632E-18  -5.65901080518248E-01  -5.65435770962327E-01   0.00000000000000E+00   3.03820569473160E-13
     -1.40339627124419E-22  -1.47743000737786E-09  -1.47712618680853E-09  -4.23732327407251E-18
      6.80231424687081E-07
      0.00000000000000E+00  -2.34892915408250E-12   0.00000000000000E+00   2.14338636976733E-14   3.17806835735688E-22
      2.34889510135998E-09   2.34891653522400E-09  -1.02133546947483E-18  -1.17170598242324E-01  -1.17170598242275E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.90111981909862E-11   0.00000000000000E+00  -4.90111981909862E-11
      5.20570254897435E-18  -5.71800833717254E-01  -5.71076336639895E-01   0.00000000000000E+00   2.78635011920257E-13
     -1.39187740266611E-22  -2.30018397204480E-09  -2.29990533703302E-09  -4.18436707949952E-18
      6.82231424687081E-07
      0.00000000000000E+00  -3.49570254285568E-12   0.00000000000000E+00   2.92087707254209E-14   3.32209918359655E-22
      3.49570330909155E-09   3.49573251786261E-09  -9.79843009636823E-19  -1.36198668537072E-01  -1.36198668537018E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46718638066181E-11   0.00000000000000E+00  -5.46718638066181E-11
      5.09635882136111E-18  -5.75372024454084E-01  -5.74288044750024E-01   0.00000000000000E+00   2.63334821884243E-13
     -1.38065845036898E-22  -3.44132398887774E-09  -3.44106065405599E-09  -4.11651581172429E-18
      6.84231424687081E-07
      0.00000000000000E+00  -5.00728322781715E-12   0.00000000000000E+00   3.78975116034411E-14   3.44200064975253E-22
      5.00722226966266E-09   5.00726016717461E-09  -9.41726008785269E-19  -1.54850518400164E-01  -1.54850518400102E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.10018786329928E-11   0.00000000000000E+00  -6.10018786329928E-11
      4.97435506409513E-18  -5.75953995164863E-01  -5.74395850471005E-01   0.00000000000000E+00   2.65696000154532E-13
     -1.36901292218121E-22  -4.94652398454164E-09  -4.94625828854162E-09  -4.03262905530986E-18
      6.86231424687081E-07
      0.00000000000000E+00  -6.91342890382216E-12   0.00000000000000E+00   4.77734234829244E-14   3.53154786265436E-22
      6.91335823321425E-09   6.91340600663808E-09  -9.06469898306420E-19  -1.73125132300713E-01  -1.73125132300646E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.75547874793488E-11   0.00000000000000E+00  -6.75547874793488E-11
      4.83924548913643E-18  -5.72839717172374E-01  -5.70683160877806E-01   0.00000000000000E+00   2.94367118444109E-13
     -1.35578230535255E-22  -6.84614558627704E-09  -6.84585121915874E-09  -3.93277559083001E-18
      6.88231424687081E-07
      0.00000000000000E+00  -9.23452910253078E-12   0.00000000000000E+00   5.79493217709217E-14   3.58487312491713E-22
      9.23448119422233E-09   9.23453914354446E-09  -8.73476834182513E-19  -1.91027266877090E-01  -1.91027266877016E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.38345443549493E-11   0.00000000000000E+00  -7.38345443549493E-11
      4.69157640042653E-18  -5.65294767314549E-01  -5.62408975028042E-01   0.00000000000000E+00   3.57711450746209E-13
     -1.33939015675513E-22  -9.16106231064013E-09  -9.16070459918952E-09  -3.81809956624401E-18
      6.90231424687081E-07
      0.00000000000000E+00  -1.19891364608589E-11   0.00000000000000E+00   6.85976049887443E-14   3.59662169775583E-22
      1.19890102831596E-08   1.19890788807650E-08  -8.42198035430020E-19  -2.08563967248970E-01  -2.08563967248890E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.95018970601137E-11   0.00000000000000E+00  -7.95018970601137E-11
      4.53257260630630E-18  -5.52561437390319E-01  -5.48809668177788E-01   0.00000000000000E+00   4.56989509778987E-13
     -1.31803987729770E-22  -1.19100339732145E-08  -1.19095769837049E-08  -3.69037457087628E-18
      6.92231424687081E-07
      0.00000000000000E+00  -1.51953443920365E-11   0.00000000000000E+00   7.97170610803943E-14   3.56067218288049E-22
      1.51952551457764E-08   1.51953348628379E-08  -8.12186233922955E-19  -2.25742920967866E-01  -2.25742920967781E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.44699768981392E-11   0.00000000000000E+00  -8.44699768981392E-11
      4.36363265251002E-18  -5.33859052393891E-01  -5.29098759904881E-01   0.00000000000000E+00   5.83253332276438E-13
     -1.29011695598098E-22  -1.51114481392719E-08  -1.51108648859397E-08  -3.55144641858707E-18
      6.94231424687081E-07
      0.00000000000000E+00  -1.88638068855795E-11   0.00000000000000E+00   9.11174052435386E-14   3.46812830425871E-22
      1.88637627678579E-08   1.88638538852635E-08  -7.83105185091835E-19  -2.42571632316595E-01  -2.42571632316506E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.88859635323402E-11   0.00000000000000E+00  -8.88859635323402E-11
      4.18586072544534E-18  -5.08398553446819E-01  -5.02483903177189E-01   0.00000000000000E+00   7.16801746627279E-13
     -1.25468930032526E-22  -1.87756847234776E-08  -1.87749679217311E-08  -3.40275554035351E-18
      6.96231424687081E-07
      0.00000000000000E+00  -2.29820330572278E-11   0.00000000000000E+00   1.02229374949414E-13   3.30651260518790E-22
      2.29819582071093E-08   2.29820604364846E-08  -7.54718096248172E-19  -2.59057128253342E-01  -2.59057128253249E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.29962358015668E-11   0.00000000000000E+00  -9.29962358015668E-11
      3.99986825384221E-18  -4.75425670439172E-01  -4.68214855217203E-01   0.00000000000000E+00   8.33955148733777E-13
     -1.21178602220000E-22  -2.28898981558317E-08  -2.28890642006831E-08  -3.24515015759404E-18
      6.98231424687081E-07
      0.00000000000000E+00  -2.75015288857358E-11   0.00000000000000E+00   1.12169152295102E-13   3.06708709107589E-22
      2.75014393042066E-08   2.75015514733592E-08  -7.26856648465406E-19  -2.75206242884339E-01  -2.75206242884243E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68881413328571E-11   0.00000000000000E+00  -9.68881413328571E-11
      3.80609197117650E-18  -4.34287645816326E-01  -4.25654124102476E-01   0.00000000000000E+00   9.21029208991280E-13
     -1.16188955484458E-22  -2.74055843612352E-08  -2.74046633320264E-08  -3.07923532271109E-18
      7.00231424687081E-07
      0.00000000000000E+00  -3.23387156602446E-11   0.00000000000000E+00   1.20065750501022E-13   2.76890716368584E-22
      3.23386079518531E-08   3.23387280176038E-08  -6.99377992608834E-19  -2.91026272197678E-01  -2.91026272197577E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00302878761466E-10   0.00000000000000E+00  -1.00302878761466E-10
      3.60548621365356E-18  -3.84502902343639E-01  -3.74346377807375E-01   0.00000000000000E+00   9.80479866459469E-13
     -1.10463614698192E-22  -3.22394056187087E-08  -3.22384251388424E-08  -2.90610822104473E-18
      7.02231424687081E-07
      0.00000000000000E+00  -3.73346101406480E-11   0.00000000000000E+00   1.24049101209257E-13   2.47633594639800E-22
      3.73344811314756E-08   3.73346051805771E-08  -6.72182466452868E-19  -3.06524391626261E-01  -3.06524391626158E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03262127304225E-10   0.00000000000000E+00  -1.03262127304225E-10
      3.39896195904511E-18  -3.25929794533869E-01  -3.14200058324074E-01   0.00000000000000E+00   9.99418253690201E-13
     -1.03792636815407E-22  -3.72323424715265E-08  -3.72313430532729E-08  -2.72677949259224E-18
      7.04231424687081E-07
      0.00000000000000E+00  -4.20120789171529E-11   0.00000000000000E+00   1.16225378656063E-13   2.22814661188698E-22
      4.20119529195111E-08   4.20120691448900E-08  -6.45372067169627E-19  -3.21703923619749E-01  -3.21703923619641E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07686299379240E-10   0.00000000000000E+00  -1.07686299379240E-10
      3.18358936028663E-18  -2.59394731286625E-01  -2.46192510169338E-01   0.00000000000000E+00   9.16097040236081E-13
     -9.58356331122537E-23  -4.19052989425508E-08  -4.19043828455107E-08  -2.53821729311701E-18
      7.06231424687081E-07
      0.00000000000000E+00  -4.53755250384298E-11   0.00000000000000E+00   8.37049885384577E-14   1.87789907307070E-22
      4.53754112810624E-08   4.53754949860512E-08  -6.19320439049454E-19  -3.36561723748232E-01  -3.36561723748116E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16864150326062E-10   0.00000000000000E+00  -1.16864150326062E-10
      2.94986105963451E-18  -1.87614822559653E-01  -1.73355612400288E-01   0.00000000000000E+00   7.10451053060643E-13
     -8.73152674186949E-23  -4.52593412867781E-08  -4.52586308357251E-08  -2.33054062058505E-18
      7.08231424687081E-07
      0.00000000000000E+00  -4.64563539058879E-11   0.00000000000000E+00   2.71248815987953E-14   1.27573782355077E-22
      4.64563228731324E-08   4.64563499980141E-08  -5.94156794395763E-19  -3.51101223211374E-01  -3.51101223211247E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27481039278184E-10   0.00000000000000E+00  -1.27481039278184E-10
      2.69489898107814E-18  -1.15121298299342E-01  -1.00524747959487E-01   0.00000000000000E+00   5.08104903925236E-13
     -7.91538893234612E-23  -4.63293770636397E-08  -4.63288689587359E-08  -2.10074218668238E-18
      7.10231424687082E-07
      0.00000000000000E+00  -4.01318334570404E-11   0.00000000000000E+00  -1.49624676492643E-13   5.85645489922366E-23
      4.01320159888980E-08   4.01318663642215E-08  -5.67982564458532E-19  -3.65357400385879E-01  -3.65357400385756E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23390909043632E-10   0.00000000000000E+00  -1.23390909043632E-10
      2.44811716299087E-18  -5.63511765350918E-02  -4.37458760728971E-02   0.00000000000000E+00   4.57181234380694E-13
     -5.01114533461951E-23  -4.00089326364123E-08  -4.00084754551779E-08  -1.88013459853234E-18
      7.12231424687082E-07
      0.00000000000000E+00  -2.60661793326565E-11   0.00000000000000E+00  -3.47590613635537E-13   2.25991322957671E-23
      2.60665795121676E-08   2.60662319215540E-08  -5.36496168170163E-19  -3.79394253404632E-01  -3.79394253404542E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94133773005026E-11   0.00000000000000E+00  -8.94133773005026E-11
      2.26929040838987E-18  -2.61112910070613E-02  -1.79268598784155E-02   0.00000000000000E+00   4.79455493930695E-13
     -2.13336934468410E-23  -2.59772979997474E-08  -2.59768185442534E-08  -1.73279424021971E-18
      7.14231424687082E-07
      0.00000000000000E+00  -1.69427823621469E-11   0.00000000000000E+00  -2.05667091745466E-13   1.04337619098190E-23
      1.69429334715071E-08   1.69427278044154E-08  -5.02668970978404E-19  -3.93198168972094E-01  -3.93198168972029E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45574138863001E-11   0.00000000000000E+00  -6.45574138863001E-11
      2.14017558061727E-18  -1.42152943226308E-02  -8.89754336224954E-03   0.00000000000000E+00   2.68285893367987E-13
     -1.07354375501941E-23  -1.68784386764224E-08  -1.68781703905291E-08  -1.63750660963887E-18
      7.16231424687082E-07
      0.00000000000000E+00  -1.31855060077242E-11   0.00000000000000E+00  -7.36277781685128E-14   6.40303517096918E-24
      1.31855950560414E-08   1.31855214282633E-08  -4.68913164272760E-19  -4.06743020589125E-01  -4.06743020589070E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53618305968716E-11   0.00000000000000E+00  -5.53618305968716E-11
      2.02945191942353E-18  -9.85543940479998E-03  -5.71855913077529E-03   0.00000000000000E+00   1.13934773507295E-13
     -7.04031837933617E-24  -1.31302735324399E-08  -1.31301595976664E-08  -1.56053875515077E-18
      7.18231424687082E-07
      0.00000000000000E+00  -1.18679932524822E-11   0.00000000000000E+00  -3.21993549970226E-14   4.80197017988489E-24
      1.18680635084389E-08   1.18680313090839E-08  -4.35811210293348E-19  -4.20020604146866E-01  -4.20020604146813E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29369319163160E-11   0.00000000000000E+00  -5.29369319163160E-11
      1.92357805559090E-18  -8.13544592995723E-03  -4.41289119034471E-03   0.00000000000000E+00   6.48378379982132E-14
     -5.45228545092343E-24  -1.18151592150056E-08  -1.18150943771676E-08  -1.48776684529755E-18
      7.20231424687082E-07
      0.00000000000000E+00  -1.14210767612304E-11   0.00000000000000E+00  -1.07530817095185E-14   3.97841863446849E-24
      1.14210437320299E-08   1.14210329789482E-08  -4.03517871029084E-19  -4.33031694841994E-01  -4.33031694841941E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27736997081600E-11   0.00000000000000E+00  -5.27736997081600E-11
      1.81803065617457E-18  -7.31137285300227E-03  -3.72959917713990E-03   0.00000000000000E+00   3.90783841058270E-14
     -4.58057794179997E-24  -1.13682983576241E-08  -1.13682592792400E-08  -1.41451278514549E-18
      7.22231424687082E-07
      0.00000000000000E+00  -1.12562154579429E-11   0.00000000000000E+00  -3.81693182241365E-15   3.45671404418207E-24
      1.12561810765693E-08   1.12561772596375E-08  -3.72115452056006E-19  -4.45780146754935E-01  -4.45780146754881E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.32776436011516E-11   0.00000000000000E+00  -5.32776436011516E-11
      1.71147536897227E-18  -6.81881164316808E-03  -3.28913553409312E-03   0.00000000000000E+00   2.91837793302336E-14
     -3.99293197478055E-24  -1.12029287998156E-08  -1.12028996160363E-08  -1.33935991691627E-18
      7.24231424687082E-07
      0.00000000000000E+00  -1.11823722892280E-11   0.00000000000000E+00  -1.59177911856921E-15   3.08469293448330E-24
      1.11823617868341E-08   1.11823601950550E-08  -3.41660767512744E-19  -4.58270698245681E-01  -4.58270698245627E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39273157177973E-11   0.00000000000000E+00  -5.39273157177973E-11
      1.60362073753668E-18  -6.47588761695137E-03  -2.96967186862295E-03   0.00000000000000E+00   2.45980741956833E-14
     -3.55004938898684E-24  -1.11284574774114E-08  -1.11284328793372E-08  -1.26195997002393E-18
      7.26231424687082E-07
      0.00000000000000E+00  -1.11411340022218E-11   0.00000000000000E+00  -8.06742922221494E-16   2.80275922470395E-24
      1.11411060302115E-08   1.11411052234686E-08  -3.12187331345112E-19  -4.70508200715533E-01  -4.70508200715478E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.45486560926853E-11   0.00000000000000E+00  -5.45486560926853E-11
      1.49452342535131E-18  -6.21752985066701E-03  -2.72450644313915E-03   0.00000000000000E+00   2.18206843539272E-14
     -3.19969867312700E-24  -1.10865783880603E-08  -1.10865565673759E-08  -1.18233609400619E-18
      7.28231424687082E-07
      0.00000000000000E+00  -1.11141316494828E-11   0.00000000000000E+00  -4.70300822124414E-16   2.58140752027539E-24
      1.11141309904949E-08   1.11141305201941E-08  -2.83707467153273E-19  -4.82497214947379E-01  -4.82497214947324E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50775994602120E-11   0.00000000000000E+00  -5.50775994602120E-11
      1.38436822643088E-18  -6.01505759224813E-03  -2.53069830793996E-03   0.00000000000000E+00   1.97683068891416E-14
     -2.91605372109841E-24  -1.10590726890408E-08  -1.10590529207339E-08  -1.10066075927761E-18
      7.30231424687082E-07
      0.00000000000000E+00  -1.10949360994064E-11   0.00000000000000E+00  -2.92480800505108E-16   2.40327690995253E-24
      1.10949368021441E-08   1.10949365096633E-08  -2.56217489155734E-19  -4.94241396901139E-01  -4.94241396901084E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54858863447320E-11   0.00000000000000E+00  -5.54858863447320E-11
      1.27339645374142E-18  -5.85266224477611E-03  -2.37447774935660E-03   0.00000000000000E+00   1.80979230691085E-14
     -2.68300127243217E-24  -1.10394687212417E-08  -1.10394506233186E-08  -1.01717896458568E-18
      7.32231424687082E-07
      0.00000000000000E+00  -1.10806083204021E-11   0.00000000000000E+00  -1.84213813451940E-16   2.25712133015438E-24
      1.10806340001133E-08   1.10806338158995E-08  -2.29706496740570E-19  -5.05741534671718E-01  -5.05741534671663E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57514373837740E-11   0.00000000000000E+00  -5.57514373837740E-11
      1.16189357897387E-18  -5.72021724447745E-03  -2.24662158187589E-03   0.00000000000000E+00   1.66793510291888E-14
     -2.48924247068822E-24  -1.10248990578667E-08  -1.10248823785157E-08  -9.32187082233300E-19
      7.34231424687082E-07
      0.00000000000000E+00  -1.10695869519372E-11   0.00000000000000E+00  -1.15846214910786E-16   2.13532047762569E-24
      1.10695695039224E-08   1.10695693880762E-08  -2.04178379167315E-19  -5.16987367128278E-01  -5.16987367128222E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58179635415462E-11   0.00000000000000E+00  -5.58179635415462E-11
      1.05025765189078E-18  -5.61075642492335E-03  -2.14066670276354E-03   0.00000000000000E+00   1.54388346412234E-14
     -2.32657338180249E-24  -1.10137668633693E-08  -1.10137514245346E-08  -8.46079272723463E-19
      7.36231424687082E-07
      0.00000000000000E+00  -1.10604943229536E-11   0.00000000000000E+00  -7.85838488011002E-17   2.03273378930744E-24
      1.10604533397650E-08   1.10604532611812E-08  -1.79717946910166E-19  -5.27928460777689E-01  -5.27928460777633E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54794329439913E-11   0.00000000000000E+00  -5.54794329439913E-11
      9.39298786002795E-19  -5.51945651482877E-03  -2.05213137669125E-03   0.00000000000000E+00   1.42914323278709E-14
     -2.18924878578794E-24  -1.10049881196695E-08  -1.10049738282372E-08  -7.59580839092629E-19
      7.38231424687082E-07
      0.00000000000000E+00  -1.10520446071305E-11   0.00000000000000E+00  -7.14717447320253E-17   1.94605547367868E-24
      1.10520826130311E-08   1.10520825415594E-08  -1.56560896105378E-19  -5.38440561949279E-01  -5.38440561949225E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43391829227622E-11   0.00000000000000E+00  -5.43391829227622E-11
      8.30620420157271E-19  -5.44307989272026E-03  -1.97803214525839E-03   0.00000000000000E+00   1.31289514360969E-14
     -2.07349799136479E-24  -1.09977564875881E-08  -1.09977433586366E-08  -6.74059524051893E-19
      7.40231424687082E-07
      0.00000000000000E+00  -1.10435948913074E-11   0.00000000000000E+00  -8.77090486768662E-17   1.87317159651291E-24
      1.10435581117718E-08   1.10435580240628E-08  -1.35065165926683E-19  -5.48335231820484E-01  -5.48335231820432E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.20258383746502E-11   0.00000000000000E+00  -5.20258383746502E-11
      7.26568743407970E-19  -5.37942714002065E-03  -1.91633573915176E-03   0.00000000000000E+00   1.18801144936620E-14
     -1.97672786097088E-24  -1.09915440658026E-08  -1.09915321856881E-08  -5.91503577481288E-19
      7.42231424687082E-07
      0.00000000000000E+00  -1.10341348833751E-11   0.00000000000000E+00  -1.24667745369279E-16   1.81277200264566E-24
      1.10341165133700E-08   1.10341163887023E-08  -1.15713943510046E-19  -5.57356583194701E-01  -5.57356583194653E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.81381585386442E-11   0.00000000000000E+00  -4.81381585386442E-11
      6.30292426330682E-19  -5.32703905525642E-03  -1.86569695943795E-03   0.00000000000000E+00   1.04689776680115E-14
     -1.89728034117183E-24  -1.09859886991413E-08  -1.09859782301636E-08  -5.14578482820635E-19
      7.44231424687082E-07
      0.00000000000000E+00  -1.10229298254357E-11   0.00000000000000E+00  -1.85778119792572E-16   1.76427554988693E-24
      1.10228941613626E-08   1.10228939755845E-08  -9.91737635465501E-20  -5.65153254718567E-01  -5.65153254718525E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.21187348697387E-11   0.00000000000000E+00  -4.21187348697387E-11
      5.46054956591205E-19  -5.28513019012068E-03  -1.82542689862605E-03   0.00000000000000E+00   8.80382024183312E-15
     -1.83448480016218E-24  -1.09807840445350E-08  -1.09807752407147E-08  -4.46881193044656E-19
      7.46231424687082E-07
      0.00000000000000E+00  -1.10088775806430E-11   0.00000000000000E+00  -2.75835230976262E-16   1.72782423721489E-24
      1.10088804079203E-08   1.10088801320851E-08  -8.63356302982911E-20  -5.71259224442726E-01  -5.71259224442693E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.33062691466827E-11   0.00000000000000E+00  -3.33062691466827E-11
      4.79442418297839E-19  -5.25355934838969E-03  -1.79549448047273E-03   0.00000000000000E+00   6.76954165939763E-15
     -1.78868136177248E-24  -1.09755806324801E-08  -1.09755738629384E-08  -3.93106787999548E-19
      7.48231424687082E-07
      0.00000000000000E+00  -1.09910597016247E-11   0.00000000000000E+00  -3.95708425739132E-16   1.70429434625687E-24
      1.09910809370607E-08   1.09910805413522E-08  -7.83079798508197E-20  -5.75101004993507E-01  -5.75101004993486E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10986091436180E-11   0.00000000000000E+00  -2.10986091436180E-11
      4.37245200010602E-19  -5.23285107798868E-03  -1.77654782415915E-03   0.00000000000000E+00   4.25183796888410E-15
     -1.76125970395627E-24  -1.09699861840466E-08  -1.09699819322086E-08  -3.58937220159783E-19
      7.50231424687082E-07
      0.00000000000000E+00  -1.09686495857461E-11   0.00000000000000E+00  -5.41841503908978E-16   1.69540498322696E-24
      1.09686884896911E-08   1.09686879478496E-08  -7.63821812022756E-20  -5.76024401842483E-01  -5.76024401842478E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.09559763026070E-12   0.00000000000000E+00  -5.09559763026070E-12
      4.27054004750081E-19  -5.22432344727315E-03  -1.77003329670921E-03   0.00000000000000E+00   1.14121757485993E-15
     -1.75490054472277E-24  -1.09635934914370E-08  -1.09635923502194E-08  -3.50671823547805E-19
      7.52231424687082E-07
      0.00000000000000E+00  -1.09410043198466E-11   0.00000000000000E+00  -5.32889445876422E-16   1.70403754013638E-24
      1.09410245554932E-08   1.09410240226037E-08  -8.20054117162312E-20  -5.73326017528963E-01  -5.73326017528977E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48283131158317E-11   0.00000000000000E+00   1.48283131158317E-11
      4.56710630981745E-19  -5.23036671809312E-03  -1.77851541856073E-03   0.00000000000000E+00  -2.85957740268588E-15
     -1.77423334531015E-24  -1.09558494761421E-08  -1.09558523357196E-08  -3.74705219265513E-19
      7.54231424687083E-07
      0.00000000000000E+00  -1.09072973012915E-11   0.00000000000000E+00  -9.11693333667953E-16   1.73499612845324E-24
      1.09072996736224E-08   1.09072987619291E-08  -9.67970513031165E-20  -5.66273867569152E-01  -5.66273867569190E-01
      0.00000000000000E+00   0.00000000000000E+00   3.85248652204458E-11   0.00000000000000E+00   3.85248652204458E-11
      5.33760361422637E-19  -5.25516475175920E-03  -1.80647354787948E-03   0.00000000000000E+00  -7.37706400176621E-15
     -1.82738211902040E-24  -1.09458162500855E-08  -1.09458236271495E-08  -4.36963310119520E-19
      7.56231424687083E-07
      0.00000000000000E+00  -1.08661508590225E-11   0.00000000000000E+00  -1.15869098888536E-15   1.79661496360652E-24
      1.08661189440095E-08   1.08661177853185E-08  -1.22625588030156E-19  -5.54112717687093E-01  -5.54112717687158E-01
      0.00000000000000E+00   0.00000000000000E+00   6.55658509989841E-11   0.00000000000000E+00   6.55658509989841E-11
      6.64892063420605E-19  -5.30638559260723E-03  -1.86215021827658E-03   0.00000000000000E+00  -1.32223678633478E-14
     -1.92946774818265E-24  -1.09316704139496E-08  -1.09316836363175E-08  -5.42266475390449E-19
      7.58231424687083E-07
      0.00000000000000E+00  -1.08144422719747E-11   0.00000000000000E+00  -1.22987049969653E-14   1.90413135758426E-24
      1.08144224168392E-08   1.08144101181342E-08  -1.61739076168825E-19  -5.36063987353407E-01  -5.36063987353502E-01
      0.00000000000000E+00   0.00000000000000E+00   9.51148996651941E-11   0.00000000000000E+00   9.51148996651941E-11
      8.55121862750993E-19  -5.39916265582915E-03  -1.96190646932408E-03   0.00000000000000E+00  -9.89908093994526E-15
     -2.11112735809280E-24  -1.09095151187184E-08  -1.09095250177994E-08  -6.93382786582167E-19
      7.60231424687083E-07
      0.00000000000000E+00  -1.07446402716969E-11   0.00000000000000E+00  -2.14002517898136E-15   2.08698620057884E-24
      1.07446230073056E-08   1.07446208672804E-08  -2.16914600920232E-19  -5.11338047171770E-01  -5.11338047171895E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25593036088764E-10   0.00000000000000E+00   1.25593036088764E-10
      1.10630793492852E-18  -5.56624419403261E-03  -2.14137909932208E-03   0.00000000000000E+00  -3.05770764504428E-14
     -2.44232218688402E-24  -1.08701833262927E-08  -1.08702139033692E-08  -8.89393334008290E-19
      7.62231424687083E-07
      0.00000000000000E+00  -1.06351613449456E-11   0.00000000000000E+00  -3.18126344383967E-15   2.40424407240759E-24
      1.06351366369697E-08   1.06351334557063E-08  -2.91505525106759E-19  -4.79174177168788E-01  -4.79174177168942E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54182040268981E-10   0.00000000000000E+00   1.54182040268981E-10
      1.41467201546648E-18  -5.88741662429798E-03  -2.48804338612041E-03   0.00000000000000E+00  -4.46663698845734E-14
     -3.11274155725729E-24  -1.07892708296054E-08  -1.07893154959753E-08  -1.12316649035973E-18
      7.64231424687083E-07
      0.00000000000000E+00  -1.04142747519615E-11   0.00000000000000E+00  -2.67687881116417E-14   2.96360536605602E-24
      1.04142096343584E-08   1.04141828655703E-08  -3.88931975168770E-19  -4.38905930864319E-01  -4.38905930864495E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76702395739117E-10   0.00000000000000E+00   1.76702395739117E-10
      1.76807680694472E-18  -6.58926422470603E-03  -3.25240862395879E-03   0.00000000000000E+00  -4.48573671815388E-14
     -4.76817467523547E-24  -1.05908404039422E-08  -1.05908852613094E-08  -1.37914483177595E-18
      7.66231424687083E-07
      0.00000000000000E+00  -9.81113036271963E-12   0.00000000000000E+00  -1.59536958810482E-14   3.77437826266480E-24
      9.81123287039643E-09   9.81121691670055E-09  -5.10274573938878E-19  -3.90030040725638E-01  -3.90030040725828E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90077497745600E-10   0.00000000000000E+00   1.90077497745600E-10
      2.14823180243592E-18  -8.42865939024022E-03  -5.27757928128710E-03   0.00000000000000E+00  -9.69056065751857E-14
     -1.01275160363181E-23  -1.00011975088396E-08  -1.00012944144462E-08  -1.63795722849704E-18
      7.68231424687083E-07
      0.00000000000000E+00  -7.91416916043537E-12   0.00000000000000E+00  -4.84399870054549E-14   2.89883439154560E-24
      7.91421755256117E-09   7.91416911257416E-09  -6.48704178329049E-19  -3.32351773968026E-01  -3.32351773968228E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02061789468996E-10   0.00000000000000E+00   2.02061789468996E-10
      2.55235538137391E-18  -1.39142142415171E-02  -1.13570663772127E-02   0.00000000000000E+00  -1.40551138012776E-13
     -2.91008277046212E-23  -8.11609035090511E-09  -8.11623090204315E-09  -1.90365120304486E-18
      7.70231424687083E-07
      0.00000000000000E+00  -4.02142181863156E-12   0.00000000000000E+00  -9.83591458925555E-14  -8.91234874422611E-24
      4.02146821434923E-09   4.02136985520333E-09  -7.91234931369602E-19  -2.66550355989311E-01  -2.66550355989539E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28039829474484E-10   0.00000000000000E+00   2.28039829474484E-10
      3.00843504032288E-18  -2.68450306295619E-02  -2.55061949593272E-02   0.00000000000000E+00  -2.18319681319557E-13
     -6.48658411920839E-23  -4.24919136499642E-09  -4.24940968467781E-09  -2.21720010895328E-18
      7.72231424687083E-07
      0.00000000000000E+00  -1.10029995174617E-12   0.00000000000000E+00  -7.52511709455927E-14  -2.93461385708590E-23
      1.10039485315672E-09   1.10031960198575E-09  -9.35833657752864E-19  -1.95139147772850E-01  -1.95139147773095E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44563832526647E-10   0.00000000000000E+00   2.44563832526647E-10
      3.49756270537617E-18  -4.51917880314917E-02  -4.47680672443342E-02   0.00000000000000E+00  -4.04943101488307E-13
     -8.42303089997952E-23  -1.34447849141082E-09  -1.34488343451240E-09  -2.56172904762331E-18
      7.74231424687083E-07
      0.00000000000000E+00  -1.55125761143513E-13   0.00000000000000E+00  -2.74802880369328E-14  -4.15373945503504E-23
      1.55146163993749E-10   1.55118683705670E-10  -1.08313250259370E-18  -1.22371021019006E-01  -1.22371021019242E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35752280590555E-10   0.00000000000000E+00   2.35752280590555E-10
      3.96906726655728E-18  -6.50357015258132E-02  -6.49125539591264E-02   0.00000000000000E+00  -6.51060718309010E-13
     -9.17464528034139E-23  -3.90219903577824E-10  -3.90870964296225E-10  -2.88593476396358E-18
      7.76231424687083E-07
      0.00000000000000E+00   2.20427369298064E-14   0.00000000000000E+00  -8.61424723026439E-15  -4.51701382156242E-23
     -2.20110436467821E-11  -2.20196578940575E-11  -1.20800255968657E-18  -6.10598880844897E-02  -6.10598880846834E-02
      0.00000000000000E+00   0.00000000000000E+00   1.93704756243935E-10   0.00000000000000E+00   1.93704756243935E-10
      4.35647677904515E-18  -8.49114178029533E-02  -8.48573268528372E-02   0.00000000000000E+00  -7.84403707449766E-13
     -9.86097139370926E-23  -1.70900694642329E-10  -1.71685098349877E-10  -3.14847421935858E-18
      7.78231424687083E-07
      0.00000000000000E+00   1.91037053391656E-14   0.00000000000000E+00  -2.19042947601550E-15  -4.59620354588854E-23
     -1.90722939454338E-11  -1.90744843749558E-11  -1.27687454248556E-18  -2.81348392536276E-02  -2.81348392537520E-02
      0.00000000000000E+00   0.00000000000000E+00   1.24334297490811E-10   0.00000000000000E+00   1.24334297490811E-10
      4.60514537402677E-18  -1.04518997019419E-01  -1.04485834110333E-01   0.00000000000000E+00  -5.87319591665625E-13
     -1.02988683194607E-22  -1.04672493524087E-10  -1.05259813115856E-10  -3.32827083154121E-18
      7.80231424687083E-07
      0.00000000000000E+00  -1.56136053252795E-15   0.00000000000000E+00  -3.36795657277093E-17  -4.59193697690319E-23
      1.53151163732510E-12   1.53147795771345E-12  -1.30640075068088E-18  -1.49634211965696E-02  -1.49634211966454E-02
      0.00000000000000E+00   0.00000000000000E+00   7.57690893863997E-11   0.00000000000000E+00   7.57690893863997E-11
      4.75668355279957E-18  -1.23786913545731E-01  -1.23762559616268E-01   0.00000000000000E+00  -3.77055209145045E-13
     -1.05475577493643E-22  -7.69235121348623E-11  -7.73005673441129E-11  -3.45028280211869E-18
      7.82231424687083E-07
      0.00000000000000E+00  -1.64402079601473E-14   0.00000000000000E+00   4.71965329309443E-16  -4.52841308887767E-23
      1.64213683285148E-11   1.64218402937988E-11  -1.31773697303454E-18  -1.01341634107775E-02  -1.01341634108280E-02
      0.00000000000000E+00   0.00000000000000E+00   5.05245308152863E-11   0.00000000000000E+00   5.05245308152863E-11
      4.85773261443014E-18  -1.42685705030586E-01  -1.42664613397909E-01   0.00000000000000E+00  -2.90150815211300E-13
     -1.07265615679297E-22  -6.66562202937668E-11  -6.69463711090853E-11  -3.53999564139560E-18
      7.84231424687083E-07
      0.00000000000000E+00  -2.66349737901828E-14   0.00000000000000E+00   4.82469792529138E-16  -4.38464667106388E-23
      2.66367196616654E-11   2.66372021314141E-11  -1.32146599000078E-18  -8.25534021425051E-03  -8.25534021428793E-03
      0.00000000000000E+00   0.00000000000000E+00   3.74136609538688E-11   0.00000000000000E+00   3.74136609538688E-11
      4.93255993633788E-18  -1.61206932660968E-01  -1.61186753382368E-01   0.00000000000000E+00  -2.71042871443960E-13
     -1.08865615932917E-22  -6.37798202137308E-11  -6.40508630852836E-11  -3.61109394633710E-18
      7.86231424687083E-07
      0.00000000000000E+00  -3.41662422412000E-14   0.00000000000000E+00   3.91517503374443E-16  -4.12316532108167E-23
      3.41708294233871E-11   3.41712209408492E-11  -1.32201319548965E-18  -7.37594827432178E-03  -7.37594827435171E-03
      0.00000000000000E+00   0.00000000000000E+00   2.99217339082122E-11   0.00000000000000E+00   2.99217339082122E-11
      4.99240340415431E-18  -1.79352151631694E-01  -1.79331959196503E-01   0.00000000000000E+00  -2.74443600000096E-13
     -1.10428630655375E-22  -6.38185112489507E-11  -6.40929548490612E-11  -3.67039020866465E-18
      7.88231424687083E-07
      0.00000000000000E+00  -4.01361501596892E-14   0.00000000000000E+00   3.04878428212100E-16  -3.70144329665773E-23
      4.01517185071566E-11   4.01520233855478E-11  -1.32119981367309E-18  -6.86098286404485E-03  -6.86098286407004E-03
      0.00000000000000E+00   0.00000000000000E+00   2.51936694648510E-11   0.00000000000000E+00   2.51936694648510E-11
      5.04279074308401E-18  -1.97127175253554E-01  -1.97106588249152E-01   0.00000000000000E+00  -2.82347996140138E-13
     -1.11987133798549E-22  -6.50633448541459E-11  -6.53456928503980E-11  -3.72159092941092E-18
      7.90231424687083E-07
      0.00000000000000E+00  -4.51876107061032E-14   0.00000000000000E+00   2.42861963027456E-16  -3.07842855020165E-23
      4.52008440425567E-11   4.52010869044890E-11  -1.31981030251409E-18  -6.50665981650587E-03  -6.50665981652787E-03
      0.00000000000000E+00   0.00000000000000E+00   2.19982725116447E-11   0.00000000000000E+00   2.19982725116447E-11
      5.08678728810730E-18  -2.14539402684707E-01  -2.14518231797410E-01   0.00000000000000E+00  -2.89427106742083E-13
     -1.13541314927600E-22  -6.69099323092783E-11  -6.71993594161339E-11  -3.76697698559321E-18
      7.92231424687083E-07
      0.00000000000000E+00  -4.96880028292720E-14   0.00000000000000E+00   2.02244298191813E-16  -2.22390182735746E-23
      4.96842085678805E-11   4.96844108121564E-11  -1.31820076769100E-18  -6.24124482212020E-03  -6.24124482213994E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97457645183603E-11   0.00000000000000E+00   1.97457645183603E-11
      5.12627881714402E-18  -2.31596522357159E-01  -2.31574648777488E-01   0.00000000000000E+00  -2.94683559487500E-13
     -1.15085712356146E-22  -6.91354917709139E-11  -6.94301753305164E-11  -3.80807804945302E-18
      7.94231424687083E-07
      0.00000000000000E+00  -5.38210160036107E-14   0.00000000000000E+00   1.76445057578984E-16  -1.13106287008473E-23
      5.38235265304471E-11   5.38237029754934E-11  -1.31653629633282E-18  -6.03387523075258E-03  -6.03387523077069E-03
      0.00000000000000E+00   0.00000000000000E+00   1.81096345416565E-11   0.00000000000000E+00   1.81096345416565E-11
      5.16249808622733E-18  -2.48305880527245E-01  -2.48283218465106E-01   0.00000000000000E+00  -2.98352313222585E-13
     -1.16615802644164E-22  -7.16349852038110E-11  -7.19333375171502E-11  -3.84596178989451E-18
      7.96231424687083E-07
      0.00000000000000E+00  -5.77703397035343E-14   0.00000000000000E+00   1.60069081910312E-16   1.71230083054036E-24
      5.77509875720130E-11   5.77511476410966E-11  -1.31489108310423E-18  -5.86788357050341E-03  -5.86788357052030E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68876364920353E-11   0.00000000000000E+00   1.68876364920353E-11
      5.19627335921140E-18  -2.64674373358341E-01  -2.64650859096863E-01   0.00000000000000E+00  -3.00930770026560E-13
     -1.18129195257360E-22  -7.43378533629880E-11  -7.46387841331327E-11  -3.88138227610717E-18
      7.98231424687083E-07
      0.00000000000000E+00  -6.15359739290429E-14   0.00000000000000E+00   1.49515963300075E-16   1.57331665206947E-23
      6.15452455326584E-11   6.15453950486374E-11  -1.31329494204525E-18  -5.73271451942921E-03  -5.73271451944515E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59468235572425E-11   0.00000000000000E+00   1.59468235572425E-11
      5.22816700632589E-18  -2.80708932016503E-01  -2.80684518944444E-01   0.00000000000000E+00  -3.02914220941765E-13
     -1.19625535065300E-22  -7.71893043848181E-11  -7.74922186058795E-11  -3.91487206428063E-18
      8.00231424687084E-07
      0.00000000000000E+00  -6.52097634173440E-14   0.00000000000000E+00   1.42582987490542E-16   2.97383120914936E-23
      6.52554602954143E-11   6.52556028784315E-11  -1.31175636134629E-18  -5.62113817400693E-03  -5.62113817402212E-03
      0.00000000000000E+00   0.00000000000000E+00   1.51975263214366E-11   0.00000000000000E+00   1.51975263214366E-11
      5.25856205896876E-18  -2.96417019799701E-01  -2.96391674068143E-01   0.00000000000000E+00  -3.04728399776010E-13
     -1.21105921079050E-22  -8.01484007999710E-11  -8.04531291998681E-11  -3.94680569762247E-18
      8.02231424687084E-07
      0.00000000000000E+00  -6.88835529056451E-14   0.00000000000000E+00   1.37945759401830E-16   4.30735972465527E-23
      6.89140351025653E-11   6.89141730483677E-11  -1.31027415736545E-18  -5.52813743685684E-03  -5.52813743687141E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45770050470199E-11   0.00000000000000E+00   1.45770050470199E-11
      5.28771606906280E-18  -3.11805033824545E-01  -3.11778731141911E-01   0.00000000000000E+00  -3.06669624014632E-13
     -1.22572565264536E-22  -8.31845084712504E-11  -8.34911780953876E-11  -3.97744191169734E-18
      8.04231424687084E-07
      0.00000000000000E+00  -7.25573423939461E-14   0.00000000000000E+00   1.34752744612400E-16   5.52341731195250E-23
      7.25418196359224E-11   7.25419543887223E-11  -1.30884349194708E-18  -5.45033774969577E-03  -5.45033774970981E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40381803559370E-11   0.00000000000000E+00   1.40381803559370E-11
      5.31579242977467E-18  -3.26873959915812E-01  -3.26846684254166E-01   0.00000000000000E+00  -3.08838018485673E-13
     -1.24027700292814E-22  -8.62712967260491E-11  -8.65801347446588E-11  -4.00694893782759E-18
      8.06231424687084E-07
      0.00000000000000E+00  -7.61392871450397E-14   0.00000000000000E+00   1.32436514430030E-16   6.59247628808258E-23
      7.61510566107927E-11   7.61511890473731E-11  -1.30745891860344E-18  -5.38545248632720E-03  -5.38545248634075E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35482810636316E-11   0.00000000000000E+00   1.35482810636316E-11
      5.34288899190194E-18  -3.41620389334888E-01  -3.41592131133885E-01   0.00000000000000E+00  -3.11280509646404E-13
     -1.25473414545712E-22  -8.93881896012334E-11  -8.96994701110052E-11  -4.03543007329849E-18
      8.08231424687084E-07
      0.00000000000000E+00  -7.97212318961332E-14   0.00000000000000E+00   1.30781099365827E-16   7.50624462674653E-23
      7.97520309607080E-11   7.97521617418824E-11  -1.30611440666016E-18  -5.33195147410062E-03  -5.33195147411371E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30982317187573E-11   0.00000000000000E+00   1.30982317187573E-11
      5.36908545533945E-18  -3.56054808870700E-01  -3.56025558189164E-01   0.00000000000000E+00  -3.14478036432484E-13
     -1.26913741013522E-22  -9.25359154240800E-11  -9.28503934606394E-11  -4.06297104867929E-18
      8.10231424687084E-07
      0.00000000000000E+00  -8.33950213844343E-14   0.00000000000000E+00   1.29835202621450E-16   8.27347481940256E-23
      8.33616790736348E-11   8.33618089089202E-11  -1.30480128430424E-18  -5.28898004638734E-03  -5.28898004640005E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27083635770426E-11   0.00000000000000E+00   1.27083635770426E-11
      5.39450218249354E-18  -3.70231316993647E-01  -3.70201052149786E-01   0.00000000000000E+00  -3.19755716967493E-13
     -1.28358301162069E-22  -9.57504167688667E-11  -9.60701724859625E-11  -4.08970089818930E-18
      8.12231424687084E-07
      0.00000000000000E+00  -8.69769661355278E-14   0.00000000000000E+00   1.29780847313369E-16   8.91221977617825E-23
      8.69931771463628E-11   8.69933069272993E-11  -1.30351170621097E-18  -5.25633262844013E-03  -5.25633262845249E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23605424304757E-11   0.00000000000000E+00   1.23605424304757E-11
      5.41922326735449E-18  -3.84191667951031E-01  -3.84160368826746E-01   0.00000000000000E+00  -3.26862493001984E-13
     -1.29814883361286E-22  -9.90269868646432E-11  -9.93538493577750E-11  -4.11571156114351E-18
      8.14231424687084E-07
      0.00000000000000E+00  -9.06507556238289E-14   0.00000000000000E+00   1.29508688198293E-16   9.44280149378713E-23
      9.06412127788618E-11   9.06413422876444E-11  -1.30224254875854E-18  -5.23446013851728E-03  -5.23446013852927E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19951145446789E-11   0.00000000000000E+00   1.19951145446789E-11
      5.44321349644384E-18  -3.97907980457839E-01  -3.97875647404065E-01   0.00000000000000E+00  -3.33743102790299E-13
     -1.31281601282857E-22  -1.02302713729401E-10  -1.02636456832323E-10  -4.14097094768530E-18
      8.16231424687084E-07
      0.00000000000000E+00  -9.43245451121300E-14   0.00000000000000E+00   1.29404525785740E-16   9.88558625912573E-23
      9.43035981908616E-11   9.43037275954863E-11  -1.30098993902086E-18  -5.22459069082344E-03  -5.22459069083505E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16118702497763E-11   0.00000000000000E+00   1.16118702497763E-11
      5.46643723694340E-18  -4.11360775461217E-01  -4.11327409584295E-01   0.00000000000000E+00  -3.40650431897296E-13
     -1.32757579524436E-22  -1.05574947413233E-10  -1.05915597845263E-10  -4.16544729792254E-18
      8.18231424687084E-07
      0.00000000000000E+00  -9.79983346004310E-14   0.00000000000000E+00   1.29589549418672E-16   1.02591135504981E-22
      9.79841501490900E-11   9.79842797387420E-11  -1.29974756214566E-18  -5.22898143190949E-03  -5.22898143192071E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12184311363980E-11   0.00000000000000E+00   1.12184311363980E-11
      5.48887409921619E-18  -4.24545966324256E-01  -4.24511565127190E-01   0.00000000000000E+00  -3.47979185697906E-13
     -1.34243380352734E-22  -1.08854731689308E-10  -1.09202710875140E-10  -4.18912653707053E-18
      8.20231424687084E-07
      0.00000000000000E+00  -1.01672124088732E-13   0.00000000000000E+00   1.30437700749076E-16   1.05792940332392E-22
      1.01693813271522E-10   1.01693943709329E-10  -1.29850533874885E-18  -5.25157670964707E-03  -5.25157670965788E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08162808990968E-11   0.00000000000000E+00   1.08162808990968E-11
      5.51050666101439E-18  -4.37465807937654E-01  -4.37430365008734E-01   0.00000000000000E+00  -3.55774444187325E-13
     -1.35739442063266E-22  -1.12154450164102E-10  -1.12510224608425E-10  -4.21200132226553E-18
      8.22231424687084E-07
      0.00000000000000E+00  -1.05437758314241E-13   0.00000000000000E+00   1.32585078765324E-16   1.08597277259301E-22
      1.05456690058011E-10   1.05456822643198E-10  -1.29724603045929E-18  -5.29955898159879E-03  -5.29955898160920E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04016463133724E-11   0.00000000000000E+00   1.04016463133724E-11
      5.53130995364114E-18  -4.50124602451690E-01  -4.50088104975777E-01   0.00000000000000E+00  -3.63862988654982E-13
     -1.37245100048761E-22  -1.15494605967779E-10  -1.15858468956572E-10  -4.23406392318184E-18
      8.24231424687084E-07
      0.00000000000000E+00  -1.09295237276957E-13   0.00000000000000E+00   1.37264984676071E-16   1.11130154570501E-22
      1.09325291152000E-10   1.09325428417096E-10  -1.29593713274463E-18  -5.38698565628219E-03  -5.38698565629215E-03
      0.00000000000000E+00   0.00000000000000E+00   9.96330470748552E-12   0.00000000000000E+00   9.96330470748552E-12
      5.55123656305610E-18  -4.62527182008336E-01  -4.62489604164588E-01   0.00000000000000E+00  -3.71859267279070E-13
     -1.38757801261080E-22  -1.18916873857163E-10  -1.19288733124581E-10  -4.25529943031148E-18
      8.26231424687084E-07
      0.00000000000000E+00  -1.13428250451296E-13   0.00000000000000E+00   1.48063600285860E-16   1.13537283613158E-22
      1.13419902407637E-10   1.13420050471351E-10  -1.29451053588783E-18  -5.54395276320041E-03  -5.54395276320988E-03
      0.00000000000000E+00   0.00000000000000E+00   9.47289958305904E-12   0.00000000000000E+00   9.47289958305904E-12
      5.57018236222222E-18  -4.74678341911390E-01  -4.74639628920476E-01   0.00000000000000E+00  -3.78967135530372E-13
     -1.40271637841942E-22  -1.22513982918739E-10  -1.22892950054410E-10  -4.27567182633439E-18
      8.28231424687084E-07
      0.00000000000000E+00  -1.18020487311672E-13   0.00000000000000E+00   1.72269516249200E-16   1.16062122820607E-22
      1.18044526946319E-10   1.18044699215952E-10  -1.29280469324765E-18  -5.84280438280720E-03  -5.84280438281605E-03
      0.00000000000000E+00   0.00000000000000E+00   8.85356773109935E-12   0.00000000000000E+00   8.85356773109935E-12
      5.58788949768442E-18  -4.86582430152633E-01  -4.86542455683528E-01   0.00000000000000E+00  -3.83259755726231E-13
     -1.41773349242198E-22  -1.26515007191183E-10  -1.26898266947051E-10  -4.29508480443677E-18
      8.30231424687084E-07
      0.00000000000000E+00  -1.24082239967369E-13   0.00000000000000E+00   2.37051440765959E-16   1.19303451790450E-22
      1.24090155496951E-10   1.24090392548511E-10  -1.29037264620240E-18  -6.48545978168617E-03  -6.48545978169404E-03
      0.00000000000000E+00   0.00000000000000E+00   7.86736073982843E-12   0.00000000000000E+00   7.86736073982843E-12
      5.60362421916408E-18  -4.98242474661963E-01  -4.98200906666866E-01   0.00000000000000E+00  -3.79073771707859E-13
     -1.43228971478473E-22  -1.31578679516488E-10  -1.31957753288339E-10  -4.31325157296168E-18
      8.32231424687084E-07
      0.00000000000000E+00  -1.34736229483442E-13   0.00000000000000E+00   4.38485002132920E-16   1.25228491287541E-22
      1.34694738300716E-10   1.34695176785844E-10  -1.28574811553637E-18  -8.13683405681410E-03  -8.13683405681976E-03
      0.00000000000000E+00   0.00000000000000E+00   5.66097793255624E-12   0.00000000000000E+00   5.66097793255624E-12
      5.61494617502919E-18  -5.09657017054919E-01  -5.09612803791307E-01   0.00000000000000E+00  -3.46348433313505E-13
     -1.44532526457507E-22  -1.40009806284941E-10  -1.40356154718399E-10  -4.32919805949282E-18
      8.34231424687084E-07
      0.00000000000000E+00  -1.62014116434077E-13   0.00000000000000E+00   1.13776398879875E-15   1.40761315458570E-22
      1.62046887761991E-10   1.62048025526121E-10  -1.27391843636303E-18  -1.30493935325230E-02  -1.30493935325223E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.38911972758137E-13   0.00000000000000E+00  -7.38911972758137E-13
      5.61346835108368E-18  -5.20806734295046E-01  -5.20755921085297E-01   0.00000000000000E+00  -2.16365652773715E-13
     -1.45333370732152E-22  -1.61092747900445E-10  -1.61309113553364E-10  -4.33954991472064E-18
      8.36231424687084E-07
      0.00000000000000E+00  -2.38428937790739E-13   0.00000000000000E+00   2.93561630470370E-15   1.77902133538601E-22
      2.38455413109411E-10   2.38458348725893E-10  -1.24552255525837E-18  -2.51794696255734E-02  -2.51794696255584E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.50563519175099E-11   0.00000000000000E+00  -1.50563519175099E-11
      5.58335564724866E-18  -5.31617194368733E-01  -5.31546821956384E-01   0.00000000000000E+00   8.10798726651572E-14
     -1.45031160300035E-22  -2.23483076680904E-10  -2.23401996808383E-10  -4.33783309199029E-18
      8.38231424687084E-07
      0.00000000000000E+00  -3.94197612094705E-13   0.00000000000000E+00   5.24413448328702E-15   2.25476960282200E-22
      3.94232687589291E-10   3.94237931724000E-10  -1.20195655971190E-18  -4.31913216768735E-02  -4.31913216768447E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.88038712370385E-11   0.00000000000000E+00  -2.88038712370385E-11
      5.52574790477458E-18  -5.41940143760455E-01  -5.41825030408632E-01   0.00000000000000E+00   3.06498494511039E-13
     -1.43878761493634E-22  -3.65740558981328E-10  -3.65434060486961E-10  -4.32379134506269E-18
      8.40231424687084E-07
      0.00000000000000E+00  -6.56781715771024E-13   0.00000000000000E+00   7.83696346715610E-15   2.62227480889615E-22
      6.56775197588593E-10   6.56783034552322E-10  -1.15246896749217E-18  -6.29825268921397E-02  -6.29825268921035E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.62680761868318E-11   0.00000000000000E+00  -3.62680761868318E-11
      5.45321175240091E-18  -5.51566024692184E-01  -5.51370558399070E-01   0.00000000000000E+00   3.48787052916831E-13
     -1.42537600091851E-22  -6.20863745418264E-10  -6.20514958365490E-10  -4.30074278490874E-18
      8.42231424687084E-07
      0.00000000000000E+00  -1.07081779110255E-12   0.00000000000000E+00   1.14366204309784E-14   2.86849997365030E-22
      1.07078220414503E-09   1.07079364076575E-09  -1.10268890161841E-18  -8.28776151035499E-02  -8.28776151035090E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.09060847519025E-11   0.00000000000000E+00  -4.09060847519025E-11
      5.37139958289711E-18  -5.60209399617054E-01  -5.59884976143047E-01   0.00000000000000E+00   3.26169505216087E-13
     -1.41252119810716E-22  -1.03021372551892E-09  -1.02988755601385E-09  -4.26871068127869E-18
      8.44231424687085E-07
      0.00000000000000E+00  -1.69572938306257E-12   0.00000000000000E+00   1.65158662490047E-14   3.05505018450037E-22
      1.69569785007471E-09   1.69571436594127E-09  -1.05514993759420E-18  -1.02517146307269E-01  -1.02517146307223E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.52806013339836E-11   0.00000000000000E+00  -4.52806013339836E-11
      5.28083838022914E-18  -5.67480088088508E-01  -5.66960184204727E-01   0.00000000000000E+00   2.97040740445762E-13
     -1.40050228619926E-22  -1.65073080534759E-09  -1.65043376460728E-09  -4.22568844263494E-18
      8.46231424687085E-07
      0.00000000000000E+00  -2.59571596295912E-12   0.00000000000000E+00   2.31977790058615E-14   3.21483873005306E-22
      2.59566860759074E-09   2.59569180537006E-09  -1.01094102101044E-18  -1.21821851616648E-01  -1.21821851616598E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.03069658681256E-11   0.00000000000000E+00  -5.03069658681256E-11
      5.18022444849289E-18  -5.72872870820596E-01  -5.72071043838808E-01   0.00000000000000E+00   2.73712905370432E-13
     -1.38910435570880E-22  -2.54565855240717E-09  -2.54538483950194E-09  -4.16928342748245E-18
      8.48231424687085E-07
      0.00000000000000E+00  -3.82744573364926E-12   0.00000000000000E+00   3.12802610218567E-14   3.35352509786403E-22
      3.82737141104237E-09   3.82740269130373E-09  -9.70302427458233E-19  -1.40759247623979E-01  -1.40759247623923E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.61589709717865E-11   0.00000000000000E+00  -5.61589709717865E-11
      5.06790650654932E-18  -5.75782714837896E-01  -5.74594721664210E-01   0.00000000000000E+00   2.61861324487293E-13
     -1.37786538947491E-22  -3.77150558165629E-09  -3.77124372033194E-09  -4.09760407909108E-18
      8.50231424687085E-07
      0.00000000000000E+00  -5.43234067161358E-12   0.00000000000000E+00   4.04011289114567E-14   3.46664272002106E-22
      5.43233729808334E-09   5.43237769921260E-09  -9.32933010564030E-19  -1.59319347216500E-01  -1.59319347216437E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25900606312586E-11   0.00000000000000E+00  -6.25900606312586E-11
      4.94272638528680E-18  -5.75535140159369E-01  -5.73843575366203E-01   0.00000000000000E+00   2.69635862170800E-13
     -1.36596031902941E-22  -5.37005727444338E-09  -5.36978763858135E-09  -4.00979337472277E-18
      8.52231424687085E-07
      0.00000000000000E+00  -7.43749497432831E-12   0.00000000000000E+00   5.01976026184915E-14   3.54790824018341E-22
      7.43740877036321E-09   7.43745896796618E-09  -8.98280394664355E-19  -1.77503016414516E-01  -1.77503016414447E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91190216862645E-11   0.00000000000000E+00  -6.91190216862645E-11
      4.80448834191427E-18  -5.71415373063704E-01  -5.69094220748837E-01   0.00000000000000E+00   3.06324000672714E-13
     -1.35212208395345E-22  -7.36864627028045E-09  -7.36833994627992E-09  -3.90620794724992E-18
      8.54231424687085E-07
      0.00000000000000E+00  -9.86192050239539E-12   0.00000000000000E+00   6.04868940457458E-14   3.59163589692183E-22
      9.86189846328722E-09   9.86195895018162E-09  -8.65750154485274E-19  -1.95315788806202E-01  -1.95315788806127E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.52725649132752E-11   0.00000000000000E+00  -7.52725649132752E-11
      4.65394321208772E-18  -5.62683387809959E-01  -5.59600393946260E-01   0.00000000000000E+00   3.78580858549461E-13
     -1.33469505557005E-22  -9.78706496612675E-09  -9.78668638526834E-09  -3.78819305760245E-18
      8.56231424687085E-07
      0.00000000000000E+00  -1.27244454269424E-11   0.00000000000000E+00   7.12527902926697E-14   3.59244384262963E-22
      1.27243680250886E-08   1.27244392778792E-08  -8.34815499545441E-19  -2.12764975132354E-01  -2.12764975132273E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.07681077456842E-11   0.00000000000000E+00  -8.07681077456842E-11
      4.49240699659635E-18  -5.48575650038237E-01  -5.44592616297161E-01   0.00000000000000E+00   4.85665868502578E-13
     -1.31188287164356E-22  -1.26441568360019E-08  -1.26436711701336E-08  -3.65759149705091E-18
      8.58231424687085E-07
      0.00000000000000E+00  -1.60424284033015E-11   0.00000000000000E+00   8.24697396571221E-14   3.54372378764905E-22
      1.60423088709592E-08   1.60423913406993E-08  -8.05056253011396E-19  -2.29858271981816E-01  -2.29858271981730E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55820374004261E-11   0.00000000000000E+00  -8.55820374004261E-11
      4.32124292179550E-18  -5.28307206275026E-01  -5.23280405998359E-01   0.00000000000000E+00   6.15810384319779E-13
     -1.28219246569932E-22  -1.59574251136830E-08  -1.59568093032988E-08  -3.51618666878410E-18
      8.60231424687085E-07
      0.00000000000000E+00  -1.98222985630773E-11   0.00000000000000E+00   9.38682963417857E-14   3.43564885452526E-22
      1.98222291116591E-08   1.98223229799558E-08  -7.76161977487884E-19  -2.46603075294434E-01  -2.46603075294345E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.99020765386745E-11   0.00000000000000E+00  -8.99020765386745E-11
      4.14143876871815E-18  -5.01092278263514E-01  -4.94875981599691E-01   0.00000000000000E+00   7.47428461969244E-13
     -1.24491860134025E-22  -1.97331683318790E-08  -1.97324209034171E-08  -3.36527679123027E-18
      8.62231424687085E-07
      0.00000000000000E+00  -2.40436663746096E-11   0.00000000000000E+00   1.04781684387399E-13   3.25542730390657E-22
      2.40435673863630E-08   2.40436721680477E-08  -7.47916191900912E-19  -2.63006315137365E-01  -2.63006315137271E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.39640325820924E-11   0.00000000000000E+00  -9.39640325820924E-11
      3.95351070355397E-18  -4.66194740442608E-01  -4.58649757855609E-01   0.00000000000000E+00   8.57844053325590E-13
     -1.20028716204229E-22  -2.39505659795188E-08  -2.39497081354656E-08  -3.20559451165305E-18
      8.64231424687085E-07
      0.00000000000000E+00  -2.86491288771438E-11   0.00000000000000E+00   1.14303882404703E-13   2.99826223821902E-22
      2.86490636687163E-08   2.86491779725990E-08  -7.20160257301112E-19  -2.79074884247710E-01  -2.79074884247612E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.77734083446920E-11   0.00000000000000E+00  -9.77734083446920E-11
      3.75796388686458E-18  -4.22996682103117E-01  -4.14001854751314E-01   0.00000000000000E+00   9.37707026484699E-13
     -1.14870059013171E-22  -2.85523422712807E-08  -2.85514045642543E-08  -3.03780362956347E-18
      8.66231424687085E-07
      0.00000000000000E+00  -3.35452799729399E-11   0.00000000000000E+00   1.21537042191191E-13   2.69431964215561E-22
      3.35452015420876E-08   3.35453230791301E-08  -6.92755203243663E-19  -2.94816207581954E-01  -2.94816207581853E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01031688917252E-10   0.00000000000000E+00  -1.01031688917252E-10
      3.55590050903008E-18  -3.71073391418093E-01  -3.60536918003940E-01   0.00000000000000E+00   9.90330824903585E-13
     -1.08942594104985E-22  -3.34452817210377E-08  -3.34442913902129E-08  -2.86314530578642E-18
      8.68231424687085E-07
      0.00000000000000E+00  -3.85284080348714E-11   0.00000000000000E+00   1.23747819771191E-13   2.41329601280420E-22
      3.85282910020290E-08   3.85284147498490E-08  -6.65631792214827E-19  -3.10236971988900E-01  -3.10236971988796E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04072151154232E-10   0.00000000000000E+00  -1.04072151154232E-10
      3.34775620672161E-18  -3.10435330235662E-01  -2.98329683500407E-01   0.00000000000000E+00   9.91251675839043E-13
     -1.01986762632629E-22  -3.84253338503706E-08  -3.84243425986948E-08  -2.68212441450679E-18
      8.70231424687085E-07
      0.00000000000000E+00  -4.29888476973550E-11   0.00000000000000E+00   1.10862842487707E-13   2.16322020837589E-22
      4.29887699913235E-08   4.29888808541662E-08  -6.38965658935144E-19  -3.25338890874156E-01  -3.25338890874047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09390861110002E-10   0.00000000000000E+00  -1.09390861110002E-10
      3.12897448450161E-18  -2.42303264633730E-01  -2.28793775232804E-01   0.00000000000000E+00   8.74998976280900E-13
     -9.37346269303207E-23  -4.28803649920324E-08  -4.28794899930562E-08  -2.49000882556647E-18
      8.72231424687085E-07
      0.00000000000000E+00  -4.59006014010452E-11   0.00000000000000E+00   7.25137814607427E-14   1.75473039592154E-22
      4.59005327269769E-08   4.59006052407586E-08  -6.13143387797758E-19  -3.40118386260238E-01  -3.40118386260118E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19691068204182E-10   0.00000000000000E+00  -1.19691068204182E-10
      2.88959234809324E-18  -1.69833496236024E-01  -1.55409693641705E-01   0.00000000000000E+00   6.54264081362508E-13
     -8.55157692293972E-23  -4.57815684366356E-08  -4.57809141725544E-08  -2.27644896029549E-18
      8.74231424687085E-07
      0.00000000000000E+00  -4.59902418645597E-11   0.00000000000000E+00   2.54744471767428E-15   1.09972506979743E-22
      4.59901744080958E-08   4.59901769555406E-08  -5.88108577790055E-19  -3.54583593664710E-01  -3.54583593664581E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29036101660565E-10   0.00000000000000E+00  -1.29036101660565E-10
      2.63152014477211E-18  -9.85916000308644E-02  -8.41423861527941E-02   0.00000000000000E+00   4.77394610401016E-13
     -7.50789556817939E-23  -4.58616182484903E-08  -4.58611408538800E-08  -2.04341156698206E-18
      8.76231424687085E-07
      0.00000000000000E+00  -3.68394751623622E-11   0.00000000000000E+00  -2.26577883849096E-13   4.64509094297959E-23
      3.68396770288405E-08   3.68394504509567E-08  -5.60803163600326E-19  -3.68782957029237E-01  -3.68782957029120E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16754138503137E-10   0.00000000000000E+00  -1.16754138503137E-10
      2.39801186776584E-18  -4.65548394062217E-02  -3.49847624755553E-02   0.00000000000000E+00   4.81420339788297E-13
     -4.11708204573991E-23  -3.67231777327933E-08  -3.67226963124536E-08  -1.83720870416552E-18
      8.78231424687085E-07
      0.00000000000000E+00  -2.32100835397141E-11   0.00000000000000E+00  -3.36638590155887E-13   1.85152451515543E-23
      2.32103566836828E-08   2.32100200450927E-08  -5.28359556496307E-19  -3.82766508135399E-01  -3.82766508135318E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.15436774491016E-11   0.00000000000000E+00  -8.15436774491016E-11
      2.23492451286764E-18  -2.20650994475001E-02  -1.47780830161105E-02   0.00000000000000E+00   4.44151316284028E-13
     -1.74402573692894E-23  -2.31289205189599E-08  -2.31284763676436E-08  -1.70656495637133E-18
      8.80231424687085E-07
      0.00000000000000E+00  -1.56655894465390E-11   0.00000000000000E+00  -1.85917611396386E-13   9.04941636235907E-24
      1.56657564672011E-08   1.56655705495897E-08  -4.94434710649656E-19  -3.96509174402831E-01  -3.96509174402770E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12759431626188E-11   0.00000000000000E+00  -6.12759431626188E-11
      2.11237262654240E-18  -1.27319502018479E-02  -7.81554781614801E-03   0.00000000000000E+00   2.41339816019305E-13
     -9.51285021553429E-24  -1.56045359462431E-08  -1.56042946064271E-08  -1.61793791589274E-18
      8.82231424687085E-07
      0.00000000000000E+00  -1.27252720295772E-11   0.00000000000000E+00  -7.21167815817876E-14   5.88711297742324E-24
      1.27253125341735E-08   1.27252404173919E-08  -4.60812606008769E-19  -4.09989433991221E-01  -4.09989433991167E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43977222586820E-11   0.00000000000000E+00  -5.43977222586820E-11
      2.00357718202504E-18  -9.29449034696069E-03  -5.30231915070081E-03   0.00000000000000E+00   1.10416001533089E-13
     -6.55001424623095E-24  -1.26709531111347E-08  -1.26708426951332E-08  -1.54276457601627E-18
      8.84231424687085E-07
      0.00000000000000E+00  -1.17127756466015E-11   0.00000000000000E+00  -2.46817503097396E-14   4.55839726532030E-24
      1.17127879940413E-08   1.17127633122910E-08  -4.27897311932708E-19  -4.23202104008124E-01  -4.23202104008071E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27800315011170E-11   0.00000000000000E+00  -5.27800315011170E-11
      1.89801711902280E-18  -7.88558128044760E-03  -4.21189644995546E-03   0.00000000000000E+00   5.60612841383112E-14
     -5.19981546873427E-24  -1.16600393420740E-08  -1.16599832807899E-08  -1.47011980709009E-18
      8.86231424687085E-07
      0.00000000000000E+00  -1.13661536083803E-11   0.00000000000000E+00  -8.28267917010612E-15   3.83255891377016E-24
      1.13661647110168E-08   1.13661564283376E-08  -3.95813682631297E-19  -4.36149056860359E-01  -4.36149056860306E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28643941823012E-11   0.00000000000000E+00  -5.28643941823012E-11
      1.79228833065820E-18  -7.17167847928037E-03  -3.60722271781503E-03   0.00000000000000E+00   3.58103751409377E-14
     -4.41972941951144E-24  -1.13133278445304E-08  -1.13132920341553E-08  -1.39647464802690E-18
      8.88231424687085E-07
      0.00000000000000E+00  -1.12332542736410E-11   0.00000000000000E+00  -3.03289977450483E-15   3.35573519129165E-24
      1.12332992202272E-08   1.12332961873275E-08  -3.64636899907650E-19  -4.48834481448440E-01  -4.48834481448387E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34316204749345E-11   0.00000000000000E+00  -5.34316204749345E-11
      1.68542508970833E-18  -6.72534931314362E-03  -3.20293037265664E-03   0.00000000000000E+00   2.77849365831529E-14
     -3.87495977866262E-24  -1.11798923517891E-08  -1.11798645668525E-08  -1.32078818980068E-18
      8.90231424687086E-07
      0.00000000000000E+00  -1.11704324733910E-11   0.00000000000000E+00  -1.32723893121670E-15   2.98007673102147E-24
      1.11703970429474E-08   1.11703957157084E-08  -3.34418104357028E-19  -4.61263189201593E-01  -4.61263189201539E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40841243315128E-11   0.00000000000000E+00  -5.40841243315128E-11
      1.57725684104531E-18  -6.40685482613245E-03  -2.90445771768607E-03   0.00000000000000E+00   2.38208651858742E-14
     -3.51113560023293E-24  -1.11163354122421E-08  -1.11163115913769E-08  -1.24283873668828E-18
      8.92231424687086E-07
      0.00000000000000E+00  -1.11336027337708E-11   0.00000000000000E+00  -7.00802404323971E-16   2.74424270742871E-24
      1.11335969458429E-08   1.11335962450405E-08  -3.05185342072534E-19  -4.73439996597044E-01  -4.73439996596989E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46868891892851E-11   0.00000000000000E+00  -5.46868891892851E-11
      1.46788306266673E-18  -6.16400095835471E-03  -2.67338659099257E-03   0.00000000000000E+00   2.12753329931609E-14
     -3.12551973992082E-24  -1.10789306311842E-08  -1.10789093558512E-08  -1.16269772059420E-18
      8.94231424687086E-07
      0.00000000000000E+00  -1.11088964994620E-11   0.00000000000000E+00  -4.17648680587701E-16   2.53471777765526E-24
      1.11089016125554E-08   1.11089011949068E-08  -2.76946475992279E-19  -4.85369323119954E-01  -4.85369323119899E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51885136583347E-11   0.00000000000000E+00  -5.51885136583347E-11
      1.35750603535007E-18  -5.97242337809735E-03  -2.48974631391549E-03   0.00000000000000E+00   1.93346191859632E-14
     -2.85534730826909E-24  -1.10537320158676E-08  -1.10537126812484E-08  -1.08055955935779E-18
      8.96231424687086E-07
      0.00000000000000E+00  -1.10910786204437E-11   0.00000000000000E+00  -2.61510177663441E-16   2.36521658498362E-24
      1.10910915574109E-08   1.10910912959008E-08  -2.49695043370410E-19  -4.97054410603094E-01  -4.97054410603038E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55645099839146E-11   0.00000000000000E+00  -5.55645099839146E-11
      1.24637701538224E-18  -5.81807980485452E-03  -2.34113129431764E-03   0.00000000000000E+00   1.77337641552979E-14
     -2.63273686584420E-24  -1.10355445196810E-08  -1.10355267859168E-08  -9.96681972011826E-19
      8.98231424687086E-07
      0.00000000000000E+00  -1.10776692888114E-11   0.00000000000000E+00  -1.64274240107717E-16   2.22556055202579E-24
      1.10777021601993E-08   1.10777019959251E-08  -2.23420719736085E-19  -5.08494583912515E-01  -5.08494583912459E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57898714064640E-11   0.00000000000000E+00  -5.57898714064640E-11
      1.13479727256931E-18  -5.69175974050463E-03  -2.21909964398299E-03   0.00000000000000E+00   1.63643377029789E-14
     -2.44717201771678E-24  -1.10219284888563E-08  -1.10219121245186E-08  -9.11376552833222E-19
      9.00231424687086E-07
      0.00000000000000E+00  -1.10671989887698E-11   0.00000000000000E+00  -1.03943664197363E-16   2.10881412328881E-24
      1.10672268773227E-08   1.10672267733790E-08  -1.98138572924700E-19  -5.19673658758741E-01  -5.19673658758685E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57863516425688E-11   0.00000000000000E+00  -5.57863516425688E-11
      1.02322456928417E-18  -5.58707942363813E-03  -2.11771758331358E-03   0.00000000000000E+00   1.51558844714449E-14
     -2.29109320709047E-24  -1.10114555776209E-08  -1.10114404217364E-08  -8.25085996359469E-19
      9.02231424687086E-07
      0.00000000000000E+00  -1.10583818939978E-11   0.00000000000000E+00  -7.42702792561987E-17   2.01033601212969E-24
      1.10583930006477E-08   1.10583929263774E-08  -1.73967489983603E-19  -5.30524746943178E-01  -5.30524746943123E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52914246888969E-11   0.00000000000000E+00  -5.52914246888969E-11
      9.12641719906377E-19  -5.49965040414504E-03  -2.03291497933873E-03   0.00000000000000E+00   1.40141196211738E-14
     -2.15929502497151E-24  -1.10031155158081E-08  -1.10031015016885E-08  -7.38674229922774E-19
      9.04231424687086E-07
      0.00000000000000E+00  -1.10500240229120E-11   0.00000000000000E+00  -7.35282741371869E-17   1.92716606097169E-24
      1.10500559374376E-08   1.10500558639093E-08  -1.51176813973996E-19  -5.40906469398136E-01  -5.40906469398083E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38984452346772E-11   0.00000000000000E+00  -5.38984452346772E-11
      8.04844829437022E-19  -5.42653343689940E-03  -1.96198521478897E-03   0.00000000000000E+00   1.28362287158068E-14
     -2.04835377052013E-24  -1.09961702549033E-08  -1.09961574186746E-08  -6.53668015463026E-19
      9.06231424687086E-07
      0.00000000000000E+00  -1.10413906176145E-11   0.00000000000000E+00  -1.00101682688504E-16   1.85740500982699E-24
      1.10413807304033E-08   1.10413806303016E-08  -1.30151498014736E-19  -5.50615692075407E-01  -5.50615692075355E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.12445989235346E-11   0.00000000000000E+00  -5.12445989235346E-11
      7.02355631589953E-19  -5.36572307022001E-03  -1.90307141034874E-03   0.00000000000000E+00   1.15610215694661E-14
     -1.95590412313515E-24  -1.09901475923996E-08  -1.09901360313781E-08  -5.72204133575216E-19
      9.08231424687086E-07
      0.00000000000000E+00  -1.10315632307332E-11   0.00000000000000E+00  -1.37055360988807E-16   1.79992024516094E-24
      1.10315912218210E-08   1.10315910847657E-08  -1.11413368596049E-19  -5.59376170061300E-01  -5.59376170061253E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.68967381534052E-11   0.00000000000000E+00  -4.68967381534052E-11
      6.08562155283142E-19  -5.31592512674198E-03  -1.85498741600936E-03   0.00000000000000E+00   1.00921872911779E-14
     -1.88052148646607E-24  -1.09847044387995E-08  -1.09846943466122E-08  -4.97148786687093E-19
      9.10231424687086E-07
      0.00000000000000E+00  -1.10198071043707E-11   0.00000000000000E+00  -2.04842824989375E-16   1.75430795641517E-24
      1.10197879482413E-08   1.10197877433985E-08  -9.56816525048354E-20  -5.66809456716602E-01  -5.66809456716562E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.02602194517758E-11   0.00000000000000E+00  -4.02602194517758E-11
      5.28041716379591E-19  -5.27651554090747E-03  -1.81720526532486E-03   0.00000000000000E+00   8.34811506201734E-15
     -1.82178214348583E-24  -1.09795358720618E-08  -1.09795275239467E-08  -4.32360063874755E-19
      9.12231424687086E-07
      0.00000000000000E+00  -1.10049282569431E-11   0.00000000000000E+00  -3.02326287786221E-16   1.72088433554318E-24
      1.10049394927123E-08   1.10049391903860E-08  -8.39023357265706E-20  -5.72421835641336E-01  -5.72421835641305E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06727468481277E-11   0.00000000000000E+00  -3.06727468481277E-11
      4.66696222683336E-19  -5.24750630862110E-03  -1.78985329858743E-03   0.00000000000000E+00   6.20675228036425E-15
     -1.78027147589724E-24  -1.09742726502902E-08  -1.09742664435379E-08  -3.82793886956765E-19
      9.14231424687086E-07
      0.00000000000000E+00  -1.09861000858155E-11   0.00000000000000E+00  -4.28913635805114E-16   1.70071541573588E-24
      1.09860912809968E-08   1.09860908520832E-08  -7.72318501078115E-20  -5.75617278151168E-01  -5.75617278151150E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75700702987138E-11   0.00000000000000E+00  -1.75700702987138E-11
      4.31556082085908E-19  -5.22960098182087E-03  -1.77375806070312E-03   0.00000000000000E+00   3.55497038083643E-15
     -1.75766007155943E-24  -1.09685243367549E-08  -1.09685207817845E-08  -3.54324231978097E-19
      9.16231424687086E-07
      0.00000000000000E+00  -1.09624959883532E-11   0.00000000000000E+00  -5.80995763608932E-16   1.69576095558004E-24
      1.09624793311675E-08   1.09624787501717E-08  -7.70007689107572E-20  -5.75726942772148E-01  -5.75726942772147E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15440041999350E-13   0.00000000000000E+00  -6.15440041999350E-13
      4.30325202001909E-19  -5.22434118014999E-03  -1.77059581306789E-03   0.00000000000000E+00   2.83505786620600E-16
     -1.75701789772506E-24  -1.09618635936355E-08  -1.09618633101297E-08  -3.53324433091152E-19
      9.18231424687086E-07
      0.00000000000000E+00  -1.09333812066584E-11   0.00000000000000E+00  -7.57739391328885E-16   1.70927630983013E-24
      1.09334278721833E-08   1.09334271144439E-08  -8.46943765376197E-20  -5.72039220393225E-01  -5.72039220393245E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02484827646955E-11   0.00000000000000E+00   2.02484827646955E-11
      4.70822167531300E-19  -5.23446169967796E-03  -1.78329624156514E-03   0.00000000000000E+00  -3.73247732538212E-15
     -1.78363220101042E-24  -1.09536718647313E-08  -1.09536755972086E-08  -3.86127790993681E-19
      9.20231424687086E-07
      0.00000000000000E+00  -1.08981128275707E-11   0.00000000000000E+00  -9.66248444371689E-16   1.74672941005789E-24
      1.08980589385274E-08   1.08980579722789E-08  -1.01983172246042E-19  -5.63816452042060E-01  -5.63816452042105E-01
      0.00000000000000E+00   0.00000000000000E+00   4.48087598802771E-11   0.00000000000000E+00   4.48087598802771E-11
      5.60439687291854E-19  -5.26478202625158E-03  -1.81702260022768E-03   0.00000000000000E+00  -8.67750717162086E-15
     -1.84689025979551E-24  -1.09428580546520E-08  -1.09428667321592E-08  -4.58456515045813E-19
      9.22231424687086E-07
      0.00000000000000E+00  -1.08546702668715E-11   0.00000000000000E+00  -3.38439597007336E-15   1.81772176589099E-24
      1.08547063613847E-08   1.08547029769887E-08  -1.30814291559533E-19  -5.50297578724674E-01  -5.50297578724746E-01
      0.00000000000000E+00   0.00000000000000E+00   7.25568106766918E-11   0.00000000000000E+00   7.25568106766918E-11
      7.05553308645238E-19  -5.32427995706550E-03  -1.88143796610130E-03   0.00000000000000E+00  -1.27088956409386E-14
     -1.96458397846908E-24  -1.09272470787698E-08  -1.09272597876654E-08  -5.74739017085706E-19
      9.24231424687086E-07
      0.00000000000000E+00  -1.07995634245470E-11   0.00000000000000E+00  -1.61830101727586E-15   1.94004535132593E-24
      1.07995966772233E-08   1.07995950589223E-08  -1.73551204093963E-19  -5.30699353488927E-01  -5.30699353489029E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02515048545061E-10   0.00000000000000E+00   1.02515048545061E-10
      9.10583405735360E-19  -5.43104286339917E-03  -1.99612662690907E-03   0.00000000000000E+00  -2.28345082875591E-14
     -2.17368380811185E-24  -1.09020872729591E-08  -1.09021101074674E-08  -7.37032201641397E-19
      9.26231424687086E-07
      0.00000000000000E+00  -1.07230567584532E-11   0.00000000000000E+00  -1.98821451114969E-13   2.14849879733121E-24
      1.07230870899112E-08   1.07228882684601E-08  -2.33115977226571E-19  -5.04234271431729E-01  -5.04234271431862E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32850543833221E-10   0.00000000000000E+00   1.32850543833221E-10
      1.17628449340180E-18  -5.62522766126031E-03  -2.20486199274447E-03   0.00000000000000E+00   1.62956658346057E-13
     -2.56175215338337E-24  -1.08559017689517E-08  -1.08557388122933E-08  -9.43168516175232E-19
      9.28231424687086E-07
      0.00000000000000E+00  -1.05966784000556E-11   0.00000000000000E+00  -6.13255304500742E-15   2.51283517516978E-24
      1.05966737145770E-08   1.05966675820240E-08  -3.12965517659824E-19  -4.70158006911633E-01  -4.70158006911793E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60384599622624E-10   0.00000000000000E+00   1.60384599622624E-10
      1.49705369264705E-18  -6.00810851046697E-03  -2.61890067181948E-03   0.00000000000000E+00  -4.64694762582711E-14
     -3.37849989162653E-24  -1.07570057121703E-08  -1.07570521816466E-08  -1.18408817498723E-18
      9.30231424687086E-07
      0.00000000000000E+00  -1.03221544805423E-11   0.00000000000000E+00  -8.36900419598425E-15   3.14837905012675E-24
      1.03221586746721E-08   1.03221503056679E-08  -4.16290707465820E-19  -4.27837401357323E-01  -4.27837401357504E-01
      0.00000000000000E+00   0.00000000000000E+00   1.80789071499754E-10   0.00000000000000E+00   1.80789071499754E-10
      1.85863183564656E-18  -6.87929361693480E-03  -3.57015480822474E-03   0.00000000000000E+00  -7.11741553656350E-14
     -5.52590882366827E-24  -1.05028682030123E-08  -1.05029393771677E-08  -1.44234112818074E-18
      9.32231424687086E-07
      0.00000000000000E+00  -9.52494216158098E-12   0.00000000000000E+00  -2.08670662258832E-14   3.90976671148531E-24
      9.52494570131077E-09   9.52492483424455E-09  -5.42839630731182E-19  -3.76822442875273E-01  -3.76822442875465E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92387613801372E-10   0.00000000000000E+00   1.92387613801372E-10
      2.24340706324930E-18  -9.26767709481104E-03  -6.20607290139036E-03   0.00000000000000E+00  -1.06409802451352E-13
     -1.28784993942621E-23  -9.71720603824347E-09  -9.71731244804593E-09  -1.70056743251812E-18
      9.34231424687086E-07
      0.00000000000000E+00  -7.10419042300219E-12   0.00000000000000E+00  -8.83548786675903E-14   1.46255014619330E-24
      7.10427360096244E-09   7.10418524608377E-09  -6.83286123325098E-19  -3.17054013044803E-01  -3.17054013045010E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07156368847962E-10   0.00000000000000E+00   2.07156368847962E-10
      2.65771980094523E-18  -1.63090106628442E-02  -1.40054506030526E-02   0.00000000000000E+00  -1.26867423547049E-13
     -3.75033396828639E-23  -7.31121474750814E-09  -7.31134161493173E-09  -1.97443367762013E-18
      9.36231424687087E-07
      0.00000000000000E+00  -3.09314705967509E-12   0.00000000000000E+00  -1.01468436009407E-13  -1.38870794135988E-23
      3.09321246695721E-09   3.09311099852119E-09  -8.26031527831838E-19  -2.49577690527095E-01  -2.49577690527329E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34226989703931E-10   0.00000000000000E+00   2.34226989703931E-10
      3.12617378035309E-18  -3.09934056626688E-02  -2.99450834910140E-02   0.00000000000000E+00  -2.52559893098011E-13
     -7.17990732485972E-23  -3.32708542833194E-09  -3.32733798822511E-09  -2.30014225252125E-18
      9.38231424687087E-07
      0.00000000000000E+00  -7.38707221360138E-13   0.00000000000000E+00  -6.15096750967231E-14  -3.33584717532304E-23
      7.38794322154082E-10   7.38732812478952E-10  -9.71621123986737E-19  -1.77371513092636E-01  -1.77371513092881E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44734327298577E-10   0.00000000000000E+00   2.44734327298577E-10
      3.61564243495024E-18  -4.99633023353949E-02  -4.96534504553737E-02   0.00000000000000E+00  -4.63117868114925E-13
     -8.63632547494042E-23  -9.83004021909328E-10  -9.83467139777530E-10  -2.64402131096351E-18
      9.40231424687087E-07
      0.00000000000000E+00  -7.51289950357569E-14   0.00000000000000E+00  -2.07166276545433E-14  -4.29554750811443E-23
      7.51564778329089E-11   7.51357612052114E-11  -1.11750473146215E-18  -1.05482487201149E-01  -1.05482487201378E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29432076624309E-10   0.00000000000000E+00   2.29432076624309E-10
      4.07450658819886E-18  -6.98805198184243E-02  -6.97845629103238E-02   0.00000000000000E+00  -7.06709963739819E-13
     -9.34924204237456E-23  -3.03861127865687E-10  -3.04567837829520E-10  -2.95700185673672E-18
      9.42231424687087E-07
      0.00000000000000E+00   2.73697316878430E-14   0.00000000000000E+00  -6.45964636916779E-15  -4.54875229262318E-23
     -2.74036224615224E-11  -2.74100821079370E-11  -1.22975569680469E-18  -5.04894367317710E-02  -5.04894367319482E-02
      0.00000000000000E+00   0.00000000000000E+00   1.77223825110739E-10   0.00000000000000E+00   1.77223825110739E-10
      4.42895423842034E-18  -8.97020956850302E-02  -8.96548955192178E-02   0.00000000000000E+00  -7.60844531802237E-13
     -9.99297768987433E-23  -1.49052898470900E-10  -1.49813743002802E-10  -3.19919854161564E-18
      9.44231424687087E-07
      0.00000000000000E+00   1.38685553183365E-14   0.00000000000000E+00  -1.40303677846648E-15  -4.60069522034342E-23
     -1.38403827701464E-11  -1.38417858069709E-11  -1.28665608785043E-18  -2.36650276428334E-02  -2.36650276429433E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09862807238341E-10   0.00000000000000E+00   1.09862807238341E-10
      4.64867985289702E-18  -1.09231570967431E-01  -1.09201318869388E-01   0.00000000000000E+00  -5.25643165332408E-13
     -1.03707500701010E-22  -9.54953782659344E-11  -9.60210214313705E-11  -3.36202376504659E-18
      9.46231424687087E-07
      0.00000000000000E+00  -5.69437370686666E-15   0.00000000000000E+00   1.68161241391303E-16  -4.58227962385616E-23
      5.70983741384213E-12   5.71000557503770E-12  -1.31026772573666E-18  -1.33168417646606E-02  -1.33168417647285E-02
      0.00000000000000E+00   0.00000000000000E+00   6.79718060807516E-11   0.00000000000000E+00   6.79718060807516E-11
      4.78462346505852E-18  -1.28411493844686E-01  -1.28388280065220E-01   0.00000000000000E+00  -3.46102562503822E-13
     -1.05945479540541E-22  -7.33357090931794E-11  -7.36818116557891E-11  -3.47435573932187E-18
      9.48231424687087E-07
      0.00000000000000E+00  -1.91955500763731E-14   0.00000000000000E+00   4.93950784288885E-16  -4.50214989799551E-23
      1.92391521549618E-11   1.92396461057011E-11  -1.31910401099857E-18  -9.51732914010043E-03  -9.51732914014699E-03
      0.00000000000000E+00   0.00000000000000E+00   4.65603942535841E-11   0.00000000000000E+00   4.65603942535841E-11
      4.87774425356569E-18  -1.47218839413429E-01  -1.47198108965635E-01   0.00000000000000E+00  -2.81604512099406E-13
     -1.07662294760655E-22  -6.55184358470784E-11  -6.58000403592855E-11  -3.55864024256713E-18
      9.50231424687087E-07
      0.00000000000000E+00  -2.86555580087483E-14   0.00000000000000E+00   4.62934219495684E-16  -4.33355172334829E-23
      2.86577796780096E-11   2.86582426121858E-11  -1.32179421273148E-18  -7.98640491222944E-03  -7.98640491226467E-03
      0.00000000000000E+00   0.00000000000000E+00   3.52285284327886E-11   0.00000000000000E+00   3.52285284327886E-11
      4.94820131043127E-18  -1.65648373027070E-01  -1.65628245471633E-01   0.00000000000000E+00  -2.70827255909164E-13
     -1.09246336783990E-22  -6.36159437889555E-11  -6.38867710449740E-11  -3.62640709769979E-18
      9.52231424687087E-07
      0.00000000000000E+00  -3.57276027737279E-14   0.00000000000000E+00   3.68538773804589E-16  -4.03712809485051E-23
      3.57365335838725E-11   3.57369021226059E-11  -1.32189952061511E-18  -7.22893457685315E-03  -7.22893457688173E-03
      0.00000000000000E+00   0.00000000000000E+00   2.85829565807052E-11   0.00000000000000E+00   2.85829565807052E-11
      5.00536722359268E-18  -1.83703055352980E-01  -1.83682791456882E-01   0.00000000000000E+00  -2.76278606723135E-13
     -1.10807309536878E-22  -6.40435800964771E-11  -6.43198587033110E-11  -3.68346770297757E-18
      9.54231424687087E-07
      0.00000000000000E+00  -4.14219764805946E-14   0.00000000000000E+00   2.87540508123208E-16  -3.57007581346935E-23
      4.14465802664361E-11   4.14468678069085E-11  -1.32089677129754E-18  -6.76402872370854E-03  -6.76402872373285E-03
      0.00000000000000E+00   0.00000000000000E+00   2.43056778354793E-11   0.00000000000000E+00   2.43056778354793E-11
      5.05397857926364E-18  -2.01389257704378E-01  -2.01368542547927E-01   0.00000000000000E+00  -2.84220234039227E-13
     -1.12365181517884E-22  -6.54683254082368E-11  -6.57525456423884E-11  -3.73308180796610E-18
      9.56231424687087E-07
      0.00000000000000E+00  -4.62897475525935E-14   0.00000000000000E+00   2.31283638275976E-16  -2.89294784214509E-23
      4.63314023328400E-11   4.63316336164493E-11  -1.31943097170615E-18  -6.43556057048990E-03  -6.43556057051128E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13797704303004E-11   0.00000000000000E+00   2.13797704303004E-11
      5.09673812012424E-18  -2.18714537467976E-01  -2.18693205290554E-01   0.00000000000000E+00  -2.90872663071008E-13
     -1.13917502106558E-22  -6.74205313835647E-11  -6.77114040467496E-11  -3.77730714841809E-18
      9.58231424687087E-07
      0.00000000000000E+00  -5.06982949385548E-14   0.00000000000000E+00   1.94854214760415E-16  -1.98000562363952E-23
      5.07149617248570E-11   5.07151565790520E-11  -1.31779756554896E-18  -6.18631374707764E-03  -6.18631374709694E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93008682635630E-11   0.00000000000000E+00   1.93008682635630E-11
      5.13533985665136E-18  -2.35686538384377E-01  -2.35664480265341E-01   0.00000000000000E+00  -2.95703498387854E-13
     -1.15458770118528E-22  -6.97203213441115E-11  -7.00160248426148E-11  -3.81754229110241E-18
      9.60231424687087E-07
      0.00000000000000E+00  -5.48313081128935E-14   0.00000000000000E+00   1.71768638047104E-16  -8.32025563239184E-24
      5.47932318557562E-11   5.47934036243860E-11  -1.31613322636532E-18  -5.99022154068137E-03  -5.99022154069915E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77806893388867E-11   0.00000000000000E+00   1.77806893388867E-11
      5.17090123532914E-18  -2.52312485670240E-01  -2.52289621773747E-01   0.00000000000000E+00  -2.99059640314645E-13
     -1.16984942907851E-22  -7.22750333228411E-11  -7.25740929632727E-11  -3.85476800896382E-18
      9.62231424687087E-07
      0.00000000000000E+00  -5.86887870756096E-14   0.00000000000000E+00   1.57075109523697E-16   5.08025060871593E-24
      5.86825432488829E-11   5.86827003239975E-11  -1.31449830323845E-18  -5.83253292657433E-03  -5.83253292659097E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66372444527494E-11   0.00000000000000E+00   1.66372444527494E-11
      5.20417572423464E-18  -2.68599218453221E-01  -2.68575489630806E-01   0.00000000000000E+00  -3.01449905949935E-13
     -1.18494171060803E-22  -7.50184948706777E-11  -7.53199447767462E-11  -3.88967742099618E-18
      9.64231424687087E-07
      0.00000000000000E+00  -6.24544213011182E-14   0.00000000000000E+00   1.47561774434186E-16   1.91622795740076E-23
      6.24526479729362E-11   6.24527955347298E-11  -1.31291588426988E-18  -5.70366390521871E-03  -5.70366390523446E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57499349686979E-11   0.00000000000000E+00   1.57499349686979E-11
      5.23567559417203E-18  -2.84553785719603E-01  -2.84529148842345E-01   0.00000000000000E+00  -3.03356566106905E-13
     -1.19986475612949E-22  -7.78993739372015E-11  -7.82027305034284E-11  -3.92275970990215E-18
      9.66231424687086E-07
      0.00000000000000E+00  -6.61282107894193E-14   0.00000000000000E+00   1.41285114204035E-16   3.30607007319517E-23
      6.61478282229258E-11   6.61479695080730E-11  -1.31139132873858E-18  -5.59698991927208E-03  -5.59698991928712E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50369551176247E-11   0.00000000000000E+00   1.50369551176247E-11
      5.26574950440728E-18  -3.00183674522690E-01  -3.00158098283226E-01   0.00000000000000E+00  -3.05181149724497E-13
     -1.21463299540445E-22  -8.08797434758511E-11  -8.11849246256971E-11  -3.95435817566869E-18
      9.68231424687086E-07
      0.00000000000000E+00  -6.98020002777203E-14   0.00000000000000E+00   1.37063321545311E-16   4.61497496399617E-23
      6.97973957092009E-11   6.97975327725686E-11  -1.30992214589048E-18  -5.50794192201174E-03  -5.50794192202618E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44401442706696E-11   0.00000000000000E+00   1.44401442706696E-11
      5.29462979294862E-18  -3.15494386688278E-01  -3.15467848867981E-01   0.00000000000000E+00  -3.07175595323059E-13
     -1.22926965224350E-22  -8.39305014477934E-11  -8.42376770432394E-11  -3.98470764705814E-18
      9.70231424687086E-07
      0.00000000000000E+00  -7.33839450288139E-14   0.00000000000000E+00   1.34123209531514E-16   5.79720391618132E-23
      7.34197613383487E-11   7.34198954616162E-11  -1.30850318253787E-18  -5.43345832246096E-03  -5.43345832247488E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39154690339898E-11   0.00000000000000E+00   1.39154690339898E-11
      5.32246073101660E-18  -3.30485167150261E-01  -3.30457653602856E-01   0.00000000000000E+00  -3.09398060281981E-13
     -1.24379593539701E-22  -8.70259664351986E-11  -8.73353644956049E-11  -4.01395754847872E-18
      9.72231424687086E-07
      0.00000000000000E+00  -7.70577345171149E-14   0.00000000000000E+00   1.31975260453700E-16   6.82857828589732E-23
      7.70259920025580E-11   7.70261239778868E-11  -1.30712893347917E-18  -5.37145317366640E-03  -5.37145317367983E-03
      0.00000000000000E+00   0.00000000000000E+00   1.34352427468641E-11   0.00000000000000E+00   1.34352427468641E-11
      5.34933121651033E-18  -3.45154001728543E-01  -3.45125503543931E-01   0.00000000000000E+00  -3.11960998379436E-13
     -1.25823515519389E-22  -9.01494057262466E-11  -9.04613667247518E-11  -4.04220228303116E-18
      9.74231424687086E-07
      0.00000000000000E+00  -8.06396792682085E-14   0.00000000000000E+00   1.30488205549388E-16   7.70542646351653E-23
      8.06271021689011E-11   8.06272326571837E-11  -1.30579301794651E-18  -5.32056261572633E-03  -5.32056261573933E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29964157556580E-11   0.00000000000000E+00   1.29964157556580E-11
      5.37532404802164E-18  -3.59518210466811E-01  -3.59488716225875E-01   0.00000000000000E+00  -3.15489129376510E-13
     -1.27263649754044E-22  -9.33081592833366E-11  -9.36236484128403E-11  -4.06953103007513E-18
      9.76231424687086E-07
      0.00000000000000E+00  -8.42216240193020E-14   0.00000000000000E+00   1.29893901815176E-16   8.43965616333271E-23
      8.42417798251815E-11   8.42419097191678E-11  -1.30448606001203E-18  -5.28009458554400E-03  -5.28009458555663E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26234169248255E-11   0.00000000000000E+00   1.26234169248255E-11
      5.40057088187129E-18  -3.73642541616929E-01  -3.73612026317289E-01   0.00000000000000E+00  -3.21434950905183E-13
     -1.28710989644706E-22  -9.65438916929606E-11  -9.68653266439944E-11  -4.09608482185927E-18
      9.78231424687086E-07
      0.00000000000000E+00  -8.78954135076031E-14   0.00000000000000E+00   1.29733109735554E-16   9.05022991650361E-23
      8.78778749991697E-11   8.78780047323699E-11  -1.30320169540625E-18  -5.24999582205270E-03  -5.24999582206498E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22739865416946E-11   0.00000000000000E+00   1.22739865416946E-11
      5.42511885495468E-18  -3.87546571232249E-01  -3.87515020714229E-01   0.00000000000000E+00  -3.28565492376097E-13
     -1.30170259757982E-22  -9.98234257815579E-11  -1.00151991274064E-10  -4.12191715954843E-18
      9.80231424687086E-07
      0.00000000000000E+00  -9.15692029959042E-14   0.00000000000000E+00   1.29499268840101E-16   9.55766221530739E-23
      9.15293515499220E-11   9.15294810492864E-11  -1.30193699248487E-18  -5.23089316079295E-03  -5.23089316080485E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19032804444943E-11   0.00000000000000E+00   1.19032804444943E-11
      5.44892541584367E-18  -4.01199907404182E-01  -4.01167323538957E-01   0.00000000000000E+00  -3.35396353370286E-13
     -1.31639219614148E-22  -1.03097365140279E-10  -1.03432761493781E-10  -4.14698842335880E-18
      9.82231424687086E-07
      0.00000000000000E+00  -9.51511477469977E-14   0.00000000000000E+00   1.29407461663428E-16   9.98201972190946E-23
      9.51955785366370E-11   9.51957079441984E-11  -1.30068755859331E-18  -5.22423142120799E-03  -5.22423142121950E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15170997702494E-11   0.00000000000000E+00   1.15170997702494E-11
      5.47195961538417E-18  -4.14587729396608E-01  -4.14554112426528E-01   0.00000000000000E+00  -3.42385273190963E-13
     -1.33117512281606E-22  -1.06370422441124E-10  -1.06712807714448E-10  -4.17127205679086E-18
      9.84231424687086E-07
      0.00000000000000E+00  -9.89167819725063E-14   0.00000000000000E+00   1.29718630821612E-16   1.03412295175042E-22
      9.88818415784966E-11   9.88819712972308E-11  -1.29944633743353E-18  -5.23259404071554E-03  -5.23259404072666E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11216133472713E-11   0.00000000000000E+00   1.11216133472713E-11
      5.49420284207871E-18  -4.27708146410657E-01  -4.27673492969783E-01   0.00000000000000E+00  -3.49833089144391E-13
     -1.34605797439029E-22  -1.09653751555223E-10  -1.10003584644502E-10  -4.19475650464518E-18
      9.86231424687086E-07
      0.00000000000000E+00  -1.02590571460807E-13   0.00000000000000E+00   1.30802399184960E-16   1.06505753796026E-22
      1.02601491717088E-10   1.02601622519594E-10  -1.29820194016314E-18  -5.26051858920994E-03  -5.26051858922065E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07169866953608E-11   0.00000000000000E+00   1.07169866953608E-11
      5.51563681546944E-18  -4.40564155843461E-01  -4.40528458308416E-01   0.00000000000000E+00  -3.57722442104370E-13
     -1.36104307451202E-22  -1.12960886772713E-10  -1.13318609214954E-10  -4.21743487530630E-18
      9.88231424687086E-07
      0.00000000000000E+00  -1.06356205686316E-13   0.00000000000000E+00   1.33389671077462E-16   1.09232515963071E-22
      1.06383590745356E-10   1.06383724135136E-10  -1.29693444317115E-18  -5.31639846546383E-03  -5.31639846547413E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02980324424402E-11   0.00000000000000E+00   1.02980324424402E-11
      5.53623288035432E-18  -4.53160272344530E-01  -4.53123515571746E-01   0.00000000000000E+00  -3.65834262344876E-13
     -1.37612004535774E-22  -1.16315922315095E-10  -1.16681756577578E-10  -4.23929843718316E-18
      9.90231424687086E-07
      0.00000000000000E+00  -1.10305529386240E-13   0.00000000000000E+00   1.39208970102865E-16   1.11719660492681E-22
      1.10291951789299E-10   1.10292090998380E-10  -1.29560533549743E-18  -5.41699424086839E-03  -5.41699424087824E-03
      0.00000000000000E+00   0.00000000000000E+00   9.85069852164239E-12   0.00000000000000E+00   9.85069852164239E-12
      5.55593427739760E-18  -4.65501356260515E-01  -4.65463509431569E-01   0.00000000000000E+00  -3.73712726659320E-13
     -1.39125704924817E-22  -1.19769076793224E-10  -1.20142789520022E-10  -4.26032894190018E-18
      9.92231424687086E-07
      0.00000000000000E+00  -1.14438542560578E-13   0.00000000000000E+00   1.51810513917658E-16   1.14126205054424E-22
      1.14475630970590E-10   1.14475782781218E-10  -1.29413163385830E-18  -5.59911394603385E-03  -5.59911394604319E-03
      0.00000000000000E+00   0.00000000000000E+00   9.33919404002015E-12   0.00000000000000E+00   9.33919404002015E-12
      5.57461266547764E-18  -4.77592137022427E-01  -4.77553133639304E-01   0.00000000000000E+00  -3.80385441267201E-13
     -1.40638255528564E-22  -1.23434591379831E-10  -1.23814976821238E-10  -4.28048103161934E-18
      9.94231424687086E-07
      0.00000000000000E+00  -1.19306313632577E-13   0.00000000000000E+00   1.82333826255278E-16   1.16745231218065E-22
      1.19323232219472E-10   1.19323414553415E-10  -1.29230967690311E-18  -5.95418845554824E-03  -5.95418845555690E-03
      0.00000000000000E+00   0.00000000000000E+00   8.66379663338980E-12   0.00000000000000E+00   8.66379663338980E-12
      5.59194025874442E-18  -4.89436760006621E-01  -4.89396442570138E-01   0.00000000000000E+00  -3.83400298579861E-13
     -1.42133264260175E-22  -1.27603810888084E-10  -1.27987211186806E-10  -4.29963058184132E-18
      9.96231424687086E-07
      0.00000000000000E+00  -1.26010979448727E-13   0.00000000000000E+00   2.69454612108579E-16   1.20359031846639E-22
      1.26024011933740E-10   1.26024281388473E-10  -1.28955182688450E-18  -6.74808895180644E-03  -6.74808895181395E-03
      0.00000000000000E+00   0.00000000000000E+00   7.50387917801567E-12   0.00000000000000E+00   7.50387917801567E-12
      5.60694801710045E-18  -5.01037628301999E-01  -5.00995565683419E-01   0.00000000000000E+00  -3.75172445957374E-13
     -1.43566747976932E-22  -1.33152988120387E-10  -1.33528160566488E-10  -4.31739619021595E-18
      9.98231424687085E-07
      0.00000000000000E+00  -1.38961087394988E-13   0.00000000000000E+00   5.38550152569414E-16   1.27661211659005E-22
      1.38942437396828E-10   1.38942975947108E-10  -1.28386480411328E-18  -8.88432154205435E-03  -8.88432154205903E-03
      0.00000000000000E+00   0.00000000000000E+00   4.68232681319488E-12   0.00000000000000E+00   4.68232681319488E-12
      5.61631267072684E-18  -5.12390914625706E-01  -5.12345671638251E-01   0.00000000000000E+00  -3.28046863149057E-13
     -1.44795809099081E-22  -1.43297255897010E-10  -1.43625302760303E-10  -4.33244786661357E-18
      1.00000000000000E-06
      0.00000000000000E+00  -1.67524800666529E-13   0.00000000000000E+00   1.33211821822657E-15   1.43938685578840E-22
      1.67514468291679E-10   1.67515800410041E-10  -1.27182809731579E-18  -1.39517277457551E-02  -1.39517277457528E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.27755972233768E-12   0.00000000000000E+00  -2.27755972233768E-12
      5.61228463482823E-18  -5.22218478682780E-01  -5.22166427837883E-01   0.00000000000000E+00  -1.82444074000976E-13
     -1.45391328027178E-22  -1.65055796613556E-10  -1.65238240687702E-10  -4.34045653751244E-18
}
